/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import java.util.stream.Collectors;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmNumType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmCopy;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFill;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmInt64Subtype;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class AddressIntrinsic
implements WasmGCIntrinsic {
    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "toInt": 
            case "toStructure": {
                return context.generate(invocation.getArguments().get(0));
            }
            case "toLong": {
                WasmExpression value = context.generate(invocation.getArguments().get(0));
                return new WasmConversion(WasmNumType.INT32, WasmNumType.INT64, false, value);
            }
            case "fromInt": {
                return context.generate(invocation.getArguments().get(0));
            }
            case "fromLong": {
                WasmExpression value = context.generate(invocation.getArguments().get(0));
                return new WasmConversion(WasmNumType.INT64, WasmNumType.INT32, false, value);
            }
            case "add": {
                WasmExpression base = context.generate(invocation.getArguments().get(0));
                if (invocation.getMethod().parameterCount() == 1) {
                    WasmExpression offset = context.generate(invocation.getArguments().get(1));
                    if (invocation.getMethod().parameterType(0) == ValueType.LONG) {
                        offset = new WasmConversion(WasmNumType.INT64, WasmNumType.INT32, false, offset);
                    }
                    return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, base, offset);
                }
                WasmExpression offset = context.generate(invocation.getArguments().get(2));
                Object type = ((ConstantExpr)invocation.getArguments().get(1)).getValue();
                String className = ((ValueType.Object)type).getClassName();
                int size = context.classInfoProvider().getHeapSize(className);
                int alignment = context.classInfoProvider().getHeapAlignment(className);
                size = WasmClassGenerator.align(size, alignment);
                offset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.MUL, offset, new WasmInt32Constant(size));
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, base, offset);
            }
            case "getByte": {
                return new WasmLoadInt32(1, context.generate(invocation.getArguments().get(0)), WasmInt32Subtype.INT8);
            }
            case "getShort": {
                return new WasmLoadInt32(2, context.generate(invocation.getArguments().get(0)), WasmInt32Subtype.INT16);
            }
            case "getChar": {
                return new WasmLoadInt32(2, context.generate(invocation.getArguments().get(0)), WasmInt32Subtype.UINT16);
            }
            case "getAddress": 
            case "getInt": {
                return new WasmLoadInt32(4, context.generate(invocation.getArguments().get(0)), WasmInt32Subtype.INT32);
            }
            case "getLong": {
                return new WasmLoadInt64(8, context.generate(invocation.getArguments().get(0)), WasmInt64Subtype.INT64);
            }
            case "getFloat": {
                return new WasmLoadFloat32(4, context.generate(invocation.getArguments().get(0)));
            }
            case "getDouble": {
                return new WasmLoadFloat64(8, context.generate(invocation.getArguments().get(0)));
            }
            case "putByte": {
                WasmExpression address = context.generate(invocation.getArguments().get(0));
                WasmExpression value = context.generate(invocation.getArguments().get(1));
                return new WasmStoreInt32(1, address, value, WasmInt32Subtype.INT8);
            }
            case "putShort": {
                WasmExpression address = context.generate(invocation.getArguments().get(0));
                WasmExpression value = context.generate(invocation.getArguments().get(1));
                return new WasmStoreInt32(2, address, value, WasmInt32Subtype.INT16);
            }
            case "putChar": {
                WasmExpression address = context.generate(invocation.getArguments().get(0));
                WasmExpression value = context.generate(invocation.getArguments().get(1));
                return new WasmStoreInt32(2, address, value, WasmInt32Subtype.UINT16);
            }
            case "putAddress": 
            case "putInt": {
                WasmExpression address = context.generate(invocation.getArguments().get(0));
                WasmExpression value = context.generate(invocation.getArguments().get(1));
                return new WasmStoreInt32(4, address, value, WasmInt32Subtype.INT32);
            }
            case "putLong": {
                WasmExpression address = context.generate(invocation.getArguments().get(0));
                WasmExpression value = context.generate(invocation.getArguments().get(1));
                return new WasmStoreInt64(8, address, value, WasmInt64Subtype.INT64);
            }
            case "putFloat": {
                WasmExpression address = context.generate(invocation.getArguments().get(0));
                WasmExpression value = context.generate(invocation.getArguments().get(1));
                return new WasmStoreFloat32(4, address, value);
            }
            case "putDouble": {
                WasmExpression address = context.generate(invocation.getArguments().get(0));
                WasmExpression value = context.generate(invocation.getArguments().get(1));
                return new WasmStoreFloat64(8, address, value);
            }
            case "sizeOf": {
                return new WasmInt32Constant(4);
            }
            case "align": {
                MethodReference delegate = new MethodReference(WasmRuntime.class.getName(), invocation.getMethod().getDescriptor());
                WasmCall call = new WasmCall(context.functions().forStaticMethod(delegate));
                call.getArguments().addAll(invocation.getArguments().stream().map(context::generate).collect(Collectors.toList()));
                return call;
            }
            case "isLessThan": {
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_UNSIGNED, context.generate(invocation.getArguments().get(0)), context.generate(invocation.getArguments().get(1)));
            }
            case "diff": {
                WasmExpression result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, context.generate(invocation.getArguments().get(0)), context.generate(invocation.getArguments().get(1)));
                result = new WasmConversion(WasmNumType.INT32, WasmNumType.INT64, true, result);
                result.setLocation(invocation.getLocation());
                return result;
            }
            case "fill": {
                WasmFill fill = new WasmFill();
                fill.setIndex(context.generate(invocation.getArguments().get(0)));
                fill.setValue(context.generate(invocation.getArguments().get(1)));
                fill.setCount(context.generate(invocation.getArguments().get(2)));
                return fill;
            }
            case "fillZero": {
                WasmFill fill = new WasmFill();
                fill.setIndex(context.generate(invocation.getArguments().get(0)));
                fill.setValue(new WasmInt32Constant(0));
                fill.setCount(context.generate(invocation.getArguments().get(1)));
                return fill;
            }
            case "moveMemoryBlock": {
                WasmCopy copy = new WasmCopy();
                copy.setSourceIndex(context.generate(invocation.getArguments().get(0)));
                copy.setDestinationIndex(context.generate(invocation.getArguments().get(1)));
                copy.setCount(context.generate(invocation.getArguments().get(2)));
                return copy;
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }

    private static int getAlignment(ValueType type) {
        return WasmClassGenerator.getTypeSize(type);
    }
}

