/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.WasmGeneratorUtil;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.interop.Function;
import org.teavm.model.MethodReference;

public class FunctionIntrinsic
implements WasmIntrinsic {
    private WasmClassGenerator classGenerator;

    public FunctionIntrinsic(WasmClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (methodReference.getClassName().equals(Function.class.getName()) && methodReference.getName().equals("isNull")) {
            return false;
        }
        return this.classGenerator.isFunctionClass(methodReference.getClassName());
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        WasmType[] parameterTypes = new WasmType[invocation.getMethod().parameterCount()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = WasmGeneratorUtil.mapType(invocation.getMethod().parameterType(i));
        }
        WasmType returnType = WasmGeneratorUtil.mapType(invocation.getMethod().getReturnType());
        WasmFunctionType functionType = manager.getFunctionTypes().of(returnType, parameterTypes);
        WasmExpression selector = manager.generate(invocation.getArguments().get(0));
        WasmIndirectCall call = new WasmIndirectCall(selector, functionType);
        for (int i = 1; i < invocation.getArguments().size(); ++i) {
            call.getArguments().add(manager.generate(invocation.getArguments().get(i)));
        }
        return call;
    }
}

