/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generators.gc;

import org.teavm.backend.wasm.generators.gc.WasmGCCustomGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorContext;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.model.MethodReference;

public class ArrayGenerator
implements WasmGCCustomGenerator {
    @Override
    public void apply(MethodReference method, WasmFunction function, WasmGCCustomGeneratorContext context) {
        WasmStructure clsStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
        WasmLocal classLocal = new WasmLocal(clsStruct.getReference());
        WasmLocal sizeLocal = new WasmLocal(WasmType.INT32);
        function.add(classLocal);
        function.add(sizeLocal);
        WasmStructGet constructorRef = new WasmStructGet(clsStruct, new WasmGetLocal(classLocal), context.classInfoProvider().getNewArrayFunctionOffset());
        WasmFunctionType functionType = context.functionTypes().of(context.classInfoProvider().getClassInfo("java.lang.Object").getType(), context.classInfoProvider().getClassInfo("java.lang.Class").getType(), WasmType.INT32);
        WasmCallReference result = new WasmCallReference(constructorRef, functionType);
        result.getArguments().add(new WasmGetLocal(classLocal));
        result.getArguments().add(new WasmGetLocal(sizeLocal));
        function.getBody().add(result);
    }
}

