/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.strings;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.teavm.backend.wasm.BaseWasmFunctionRepository;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.generate.gc.WasmGCInitializerContributor;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCStandardClasses;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringConstant;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringProvider;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmMemorySegment;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.render.WasmBinaryWriter;
import org.teavm.backend.wasm.runtime.StringInternPool;
import org.teavm.backend.wasm.runtime.gc.WasmGCSupport;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.MethodReference;

public class WasmGCStringPool
implements WasmGCStringProvider,
WasmGCInitializerContributor {
    private WasmGCStandardClasses standardClasses;
    private WasmModule module;
    private WasmBinaryWriter binaryWriter = new WasmBinaryWriter();
    private Map<String, WasmGCStringConstant> stringMap = new LinkedHashMap<String, WasmGCStringConstant>();
    private BaseWasmFunctionRepository functionProvider;
    private WasmFunction initNextStringFunction;
    private WasmFunction initStringsFunction;
    private WasmArray stringsArray;
    private WasmGCNameProvider names;
    private WasmFunctionTypes functionTypes;
    private DependencyInfo dependencyInfo;

    public WasmGCStringPool(WasmGCStandardClasses standardClasses, WasmModule module, BaseWasmFunctionRepository functionProvider, WasmGCNameProvider names, WasmFunctionTypes functionTypes, DependencyInfo dependencyInfo) {
        this.standardClasses = standardClasses;
        this.module = module;
        this.functionProvider = functionProvider;
        this.names = names;
        this.functionTypes = functionTypes;
        this.dependencyInfo = dependencyInfo;
    }

    @Override
    public void contributeToInitializerDefinitions(WasmFunction function) {
        WasmMemorySegment segment = new WasmMemorySegment();
        this.module.getSegments().add(segment);
        segment.setData(this.binaryWriter.getData());
    }

    @Override
    public void contributeToInitializer(WasmFunction function) {
        if (this.initNextStringFunction == null) {
            return;
        }
        if (this.hasIntern()) {
            WasmFunction internInit = this.functionProvider.forStaticMethod(new MethodReference(StringInternPool.class, "<clinit>", Void.TYPE));
            function.getBody().add(new WasmCall(internInit));
        }
        Iterator<WasmGCStringConstant> stringIterator = this.stringMap.values().iterator();
        while (stringIterator.hasNext()) {
            WasmArrayNewFixed array = new WasmArrayNewFixed(this.stringsArray);
            for (int elementCount = 0; elementCount < 10000 && stringIterator.hasNext(); ++elementCount) {
                array.getElements().add(new WasmGetGlobal(stringIterator.next().global));
            }
            function.getBody().add(new WasmCall(this.initStringsFunction, array));
        }
    }

    @Override
    public WasmGCStringConstant getStringConstant(String string) {
        return this.stringMap.computeIfAbsent(string, s -> {
            if (this.initNextStringFunction == null) {
                this.createInitNextStringFunction();
                this.createInitStringsFunction();
            }
            this.binaryWriter.writeLEB(string.length());
            this.writeWTF8(string, this.binaryWriter);
            String brief = string.length() > 16 ? string.substring(0, 16) : string;
            String globalName = this.names.topLevel("teavm@string<" + this.stringMap.size() + ">" + WasmGCNameProvider.sanitize(brief));
            WasmType.CompositeReference globalType = this.standardClasses.stringClass().getStructure().getNonNullReference();
            WasmGlobal global = new WasmGlobal(globalName, globalType, new WasmStructNewDefault(this.standardClasses.stringClass().getStructure()));
            global.setImmutable(true);
            this.module.globals.add(global);
            return new WasmGCStringConstant(this.stringMap.size(), global);
        });
    }

    private void writeWTF8(String s, WasmBinaryWriter writer) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                writer.writeByte(c);
                continue;
            }
            if (c < '\u0800') {
                writer.writeByte(0xC0 | c >> 6 & 0x1F);
                writer.writeByte(0x80 | c & 0x3F);
                continue;
            }
            if (c >= '\u10000') continue;
            writer.writeByte(0xE0 | c >> 12 & 0x1F);
            writer.writeByte(0x80 | c >> 6 & 0x3F);
            writer.writeByte(0x80 | c & 0x3F);
        }
    }

    private void createInitStringsFunction() {
        this.stringsArray = new WasmArray(this.names.topLevel("teavm@stringArray"), this.standardClasses.stringClass().getStructure().getNonNullReference().asStorage());
        this.module.types.add(this.stringsArray);
        WasmFunction function = new WasmFunction(this.functionTypes.of(null, this.stringsArray.getNonNullReference()));
        function.setName(this.names.topLevel("teavm@initStrings"));
        this.module.functions.add(function);
        WasmLocal stringsLocal = new WasmLocal(this.stringsArray.getNonNullReference(), "strings");
        WasmLocal indexLocal = new WasmLocal(WasmType.INT32, "index");
        WasmLocal lengthLocal = new WasmLocal(WasmType.INT32, "length");
        function.add(stringsLocal);
        function.add(indexLocal);
        function.add(lengthLocal);
        WasmArrayLength length = new WasmArrayLength(new WasmGetLocal(stringsLocal));
        function.getBody().add(new WasmSetLocal(lengthLocal, length));
        function.getBody().add(new WasmSetLocal(indexLocal, new WasmInt32Constant(0)));
        WasmBlock loop = new WasmBlock(true);
        function.getBody().add(loop);
        WasmArrayGet get = new WasmArrayGet(this.stringsArray, new WasmGetLocal(stringsLocal), new WasmGetLocal(indexLocal));
        loop.getBody().add(new WasmCall(this.initNextStringFunction, get));
        WasmIntBinary next = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, new WasmGetLocal(indexLocal), new WasmInt32Constant(1));
        loop.getBody().add(new WasmSetLocal(indexLocal, next));
        WasmIntBinary compare = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_UNSIGNED, new WasmGetLocal(indexLocal), new WasmGetLocal(lengthLocal));
        loop.getBody().add(new WasmBranch(compare, loop));
        this.initStringsFunction = function;
    }

    private void createInitNextStringFunction() {
        WasmGCClassInfo stringTypeInfo = this.standardClasses.stringClass();
        WasmFunction nextCharArrayFunction = this.functionProvider.forStaticMethod(new MethodReference(WasmGCSupport.class, "nextCharArray", char[].class));
        WasmFunction function = new WasmFunction(this.functionTypes.of(null, stringTypeInfo.getStructure().getNonNullReference()));
        function.setName(this.names.topLevel("teavm@initNextString"));
        WasmLocal stringLocal = new WasmLocal(stringTypeInfo.getType());
        function.add(stringLocal);
        WasmCall value = new WasmCall(nextCharArrayFunction);
        function.getBody().add(new WasmStructSet(stringTypeInfo.getStructure(), new WasmGetLocal(stringLocal), 2, value));
        function.getBody().add(new WasmStructSet(stringTypeInfo.getStructure(), new WasmGetLocal(stringLocal), 0, new WasmGetGlobal(stringTypeInfo.getVirtualTablePointer())));
        if (this.hasIntern()) {
            WasmFunction queryFunction = this.functionProvider.forStaticMethod(new MethodReference(StringInternPool.class, "query", String.class, String.class));
            function.getBody().add(new WasmDrop(new WasmCall(queryFunction, new WasmGetLocal(stringLocal))));
            this.functionProvider.forStaticMethod(new MethodReference(StringInternPool.class, "<clinit>", Void.TYPE));
        }
        this.module.functions.add(function);
        this.initNextStringFunction = function;
    }

    private boolean hasIntern() {
        MethodDependencyInfo intern = this.dependencyInfo.getMethod(new MethodReference(String.class, "intern", String.class));
        return intern != null && intern.isUsed();
    }
}

