/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.classes;

import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.function.Function;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIntUnaryOperation;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.model.ValueType;

class WasmGCNewArrayFunctionGenerator {
    private WasmModule module;
    private WasmFunctionTypes functionTypes;
    private WasmGCClassInfoProvider classInfoProvider;
    private WasmFunctionType newArrayFunctionType;
    private WasmGCNameProvider names;
    private Queue<Runnable> queue;
    private WasmFunction newObjectArrayFunction;

    WasmGCNewArrayFunctionGenerator(WasmModule module, WasmFunctionTypes functionTypes, WasmGCClassInfoProvider classInfoProvider, WasmGCNameProvider names, Queue<Runnable> queue) {
        this.module = module;
        this.functionTypes = functionTypes;
        this.classInfoProvider = classInfoProvider;
        this.names = names;
        this.queue = queue;
    }

    WasmFunction generateNewArrayFunction(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            WasmGCClassInfo classInfo = this.classInfoProvider.getClassInfo(ValueType.arrayOf(itemType));
            WasmType.CompositeReference classClass = this.classInfoProvider.getClassInfo("java.lang.Class").getType();
            WasmFunctionType functionType = new WasmFunctionType(null, classInfo.getType(), List.of(classClass, WasmType.INT32));
            this.module.types.add(functionType);
            functionType.setFinal(true);
            functionType.getSupertypes().add(this.getNewArrayFunctionType());
            WasmFunction function = new WasmFunction(functionType);
            function.setName(this.names.topLevel("Array<" + this.names.suggestForType(itemType) + ">@new"));
            this.module.functions.add(function);
            this.queue.add(() -> {
                WasmLocal clsLocal = new WasmLocal(classClass, "this");
                WasmLocal sizeLocal = new WasmLocal(WasmType.INT32, "length");
                function.add(clsLocal);
                function.add(sizeLocal);
                WasmLocal targetVar = new WasmLocal(classInfo.getType(), "result");
                function.add(targetVar);
                function.getBody().add(this.allocateArray(itemType, sizeLocal));
            });
            return function;
        }
        return this.getNewObjectArrayFunction();
    }

    private WasmExpression allocateArray(ValueType itemType, WasmLocal sizeLocal) {
        WasmGCClassInfo classInfo = this.classInfoProvider.getClassInfo(ValueType.arrayOf(itemType));
        WasmType.CompositeReference wasmArrayType = (WasmType.CompositeReference)classInfo.getStructure().getFields().get(2).getUnpackedType();
        WasmArray wasmArray = (WasmArray)wasmArrayType.composite;
        WasmStructNew structNew = new WasmStructNew(classInfo.getStructure());
        structNew.getInitializers().add(new WasmGetGlobal(classInfo.getVirtualTablePointer()));
        structNew.getInitializers().add(new WasmNullConstant(WasmType.Reference.EQ));
        structNew.getInitializers().add(new WasmArrayNewDefault(wasmArray, new WasmGetLocal(sizeLocal)));
        return structNew;
    }

    WasmFunction getNewObjectArrayFunction() {
        if (this.newObjectArrayFunction == null) {
            this.newObjectArrayFunction = this.generateNewObjectArrayFunction();
        }
        return this.newObjectArrayFunction;
    }

    private WasmFunction generateNewObjectArrayFunction() {
        WasmGCClassInfo classInfo = this.classInfoProvider.getClassInfo(ValueType.arrayOf(ValueType.object("java.lang.Object")));
        WasmGCClassInfo classClass = this.classInfoProvider.getClassInfo("java.lang.Class");
        WasmFunctionType functionType = new WasmFunctionType(null, classInfo.getType(), List.of(classClass.getType(), WasmType.INT32));
        this.module.types.add(functionType);
        functionType.setFinal(true);
        functionType.getSupertypes().add(this.getNewArrayFunctionType());
        WasmFunction function = new WasmFunction(functionType);
        function.setName(this.names.topLevel("Array<" + this.names.suggestForClass("java.lang.Object") + ">@new"));
        this.module.functions.add(function);
        this.queue.add(() -> {
            WasmLocal clsLocal = new WasmLocal(classClass.getType(), "this");
            WasmLocal sizeLocal = new WasmLocal(WasmType.INT32, "length");
            function.add(clsLocal);
            function.add(sizeLocal);
            WasmLocal targetVar = new WasmLocal(classInfo.getType(), "result");
            function.add(targetVar);
            WasmType.CompositeReference wasmArrayType = (WasmType.CompositeReference)classInfo.getStructure().getFields().get(2).getUnpackedType();
            WasmArray wasmArray = (WasmArray)wasmArrayType.composite;
            WasmCall arrayCls = new WasmCall(this.classInfoProvider.getGetArrayClassFunction(), new WasmGetLocal(clsLocal));
            WasmStructGet arrayVt = new WasmStructGet(classClass.getStructure(), arrayCls, this.classInfoProvider.getClassVtFieldOffset());
            WasmStructNew structNew = new WasmStructNew(classInfo.getStructure());
            structNew.getInitializers().add(arrayVt);
            structNew.getInitializers().add(new WasmNullConstant(WasmType.Reference.EQ));
            structNew.getInitializers().add(new WasmArrayNewDefault(wasmArray, new WasmGetLocal(sizeLocal)));
            function.getBody().add(structNew);
        });
        return function;
    }

    WasmFunction generateNewMultiArrayFunction(int depth) {
        ValueType.Array arrayType = ValueType.arrayOf(ValueType.object("java.lang.Object"));
        WasmGCClassInfo arrayClass = this.classInfoProvider.getClassInfo(arrayType);
        WasmGCClassInfo objectClass = this.classInfoProvider.getClassInfo("java.lang.Object");
        WasmGCClassInfo classClass = this.classInfoProvider.getClassInfo("java.lang.Class");
        Object[] parameterTypes = new WasmType[depth + 1];
        Arrays.fill(parameterTypes, WasmType.INT32);
        parameterTypes[0] = classClass.getType();
        WasmFunctionType functionType = this.functionTypes.of(arrayClass.getType(), (WasmType[])parameterTypes);
        WasmFunction function = new WasmFunction(functionType);
        function.setName(this.names.topLevel(this.names.suggestForType(arrayType) + "@new:" + depth));
        this.module.functions.add(function);
        this.queue.add(() -> {
            Function<WasmExpression[], WasmExpression> nextArrayConstructor;
            WasmLocal itemTypeLocal = new WasmLocal(classClass.getType(), "itemType");
            function.add(itemTypeLocal);
            WasmLocal[] dimensionLocals = new WasmLocal[depth];
            for (int i = 0; i < depth; ++i) {
                WasmLocal dimensionLocal;
                dimensionLocals[i] = dimensionLocal = new WasmLocal(WasmType.INT32, "dim" + i);
                function.add(dimensionLocal);
            }
            WasmLocal indexLocal = new WasmLocal(WasmType.INT32, "index");
            WasmLocal nextItemTypeLocal = new WasmLocal(classClass.getType(), "nextItemType");
            function.add(indexLocal);
            function.add(nextItemTypeLocal);
            WasmField dataField = arrayClass.getStructure().getFields().get(2);
            WasmType.CompositeReference dataFieldTypeRef = (WasmType.CompositeReference)dataField.getUnpackedType();
            WasmArray dataArray = (WasmArray)dataFieldTypeRef.composite;
            WasmLocal dataLocal = new WasmLocal(dataArray.getReference(), "data");
            function.add(dataLocal);
            WasmLocal resultVar = new WasmLocal(arrayClass.getType(), "result");
            function.add(resultVar);
            WasmFunction allocFunction = this.getNewObjectArrayFunction();
            function.getBody().add(new WasmSetLocal(resultVar, new WasmCall(allocFunction, new WasmGetLocal(itemTypeLocal), new WasmGetLocal(dimensionLocals[0]))));
            function.getBody().add(new WasmSetLocal(dataLocal, new WasmStructGet(arrayClass.getStructure(), new WasmGetLocal(resultVar), 2)));
            function.getBody().add(new WasmSetLocal(nextItemTypeLocal, new WasmStructGet(classClass.getStructure(), new WasmGetLocal(itemTypeLocal), this.classInfoProvider.getClassArrayItemOffset())));
            WasmBlock zeroGuard = new WasmBlock(false);
            function.getBody().add(zeroGuard);
            zeroGuard.getBody().add(new WasmBranch(new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.EQZ, new WasmGetLocal(dimensionLocals[0])), zeroGuard));
            if (depth == 2) {
                WasmFunctionType nextFunctionType = this.functionTypes.of(objectClass.getType(), classClass.getType(), WasmType.INT32);
                WasmLocal createNextArrayLocal = new WasmLocal(nextFunctionType.getReference(), "createNextArray");
                function.add(createNextArrayLocal);
                zeroGuard.getBody().add(new WasmSetLocal(createNextArrayLocal, new WasmStructGet(classClass.getStructure(), new WasmGetLocal(nextItemTypeLocal), this.classInfoProvider.getNewArrayFunctionOffset())));
                nextArrayConstructor = args -> new WasmCallReference(new WasmGetLocal(createNextArrayLocal), nextFunctionType, (WasmExpression)args);
            } else {
                WasmFunction nextFunction = this.classInfoProvider.getMultiArrayConstructor(depth - 1);
                nextArrayConstructor = args -> new WasmCall(nextFunction, (WasmExpression)args);
            }
            WasmBlock loop = new WasmBlock(true);
            zeroGuard.getBody().add(loop);
            WasmExpression[] args2 = new WasmExpression[depth];
            args2[0] = new WasmGetLocal(nextItemTypeLocal);
            for (int i = 1; i < args2.length; ++i) {
                args2[i] = new WasmGetLocal(dimensionLocals[i]);
            }
            loop.getBody().add(new WasmArraySet(dataArray, new WasmGetLocal(dataLocal), new WasmGetLocal(indexLocal), nextArrayConstructor.apply(args2)));
            WasmIntBinary incrementIndex = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, new WasmGetLocal(indexLocal), new WasmInt32Constant(1));
            loop.getBody().add(new WasmSetLocal(indexLocal, incrementIndex));
            WasmIntBinary continueCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_UNSIGNED, new WasmGetLocal(indexLocal), new WasmGetLocal(dimensionLocals[0]));
            loop.getBody().add(new WasmBranch(continueCondition, loop));
            function.getBody().add(new WasmGetLocal(resultVar));
        });
        return function;
    }

    WasmFunctionType getNewArrayFunctionType() {
        if (this.newArrayFunctionType == null) {
            this.newArrayFunctionType = this.functionTypes.of(this.classInfoProvider.getClassInfo("java.lang.Object").getType(), this.classInfoProvider.getClassInfo("java.lang.Class").getType(), WasmType.INT32);
            this.newArrayFunctionType.setFinal(false);
        }
        return this.newArrayFunctionType;
    }
}

