/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.classes;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teavm.backend.wasm.BaseWasmFunctionRepository;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTable;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableEntry;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableProvider;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.gc.WasmGCInitializerContributor;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.annotations.WasmGCAnnotationsGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapperFactory;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapperFactoryContext;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCNewArrayFunctionGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCReflectionGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCReflectionProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCStandardClasses;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCSupertypeFunctionGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCSupertypeFunctionProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCSystemFunctionGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCTypeMapper;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationUtil;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringConstant;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringPool;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStorageType;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullCondition;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmSignedType;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.runtime.StringInternPool;
import org.teavm.backend.wasm.runtime.gc.WasmGCSupport;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.hppc.ObjectByteHashMap;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.interop.Structure;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.PrimitiveType;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.ClassInitializerInfo;
import org.teavm.model.analysis.ClassMetadataRequirements;
import org.teavm.model.classes.TagRegistry;
import org.teavm.model.util.ReflectionUtil;

public class WasmGCClassGenerator
implements WasmGCClassInfoProvider,
WasmGCInitializerContributor {
    private static final MethodDescriptor CLINIT_METHOD_DESC = new MethodDescriptor("<clinit>", ValueType.VOID);
    private static final MethodDescriptor CLONE_METHOD_DESC = new MethodDescriptor("clone", ValueType.object("java.lang.Object"));
    private static final MethodDescriptor GET_CLASS_METHOD = new MethodDescriptor("getClass", ValueType.parse(Class.class));
    private static final FieldReference FAKE_CLASS_FIELD = new FieldReference(Object.class.getName(), "class");
    private static final FieldReference FAKE_MONITOR_FIELD = new FieldReference(Object.class.getName(), "monitor");
    private static final FieldReference FAKE_VT_FIELD = new FieldReference(Object.class.getName(), "vt");
    private static final ValueType OBJECT_TYPE = ValueType.parse(Object.class);
    private final WasmModule module;
    private ClassReaderSource classSource;
    private ClassReaderSource originalClassSource;
    private ClassHierarchy hierarchy;
    private WasmFunctionTypes functionTypes;
    private TagRegistry tagRegistry;
    private ClassMetadataRequirements metadataRequirements;
    private WasmGCVirtualTableProvider virtualTables;
    private BaseWasmFunctionRepository functionProvider;
    private Map<ValueType, WasmGCClassInfo> classInfoMap = new LinkedHashMap<ValueType, WasmGCClassInfo>();
    private Queue<Runnable> queue = new ArrayDeque<Runnable>();
    private ObjectIntMap<FieldReference> fieldIndexes = new ObjectIntHashMap<FieldReference>();
    private Map<FieldReference, WasmGlobal> staticFieldLocations = new HashMap<FieldReference, WasmGlobal>();
    private List<Consumer<WasmFunction>> staticFieldInitializers = new ArrayList<Consumer<WasmFunction>>();
    private ClassInitializerInfo classInitializerInfo;
    private ObjectByteHashMap<String> heapStructures = new ObjectByteHashMap();
    public final WasmGCStringPool strings;
    public final WasmGCStandardClasses standardClasses;
    public final WasmGCTypeMapper typeMapper;
    private final WasmGCNameProvider names;
    private List<WasmExpression> initializerFunctionStatements = new ArrayList<WasmExpression>();
    private List<Consumer<WasmFunction>> annotationInitStatements = new ArrayList<Consumer<WasmFunction>>();
    private WasmGCAnnotationsGenerator annotationsGenerator;
    private WasmFunction createPrimitiveClassFunction;
    private WasmFunction getArrayClassFunction;
    private WasmFunction fillArrayClassFunction;
    private WasmFunction fillRegularClassFunction;
    private final WasmGCSupertypeFunctionGenerator supertypeGenerator;
    private final WasmGCNewArrayFunctionGenerator newArrayGenerator;
    private String arrayDataFieldName;
    private WasmGlobal lastRegularClassGlobal;
    private int classTagOffset;
    private int classFlagsOffset = -1;
    private int classVtOffset = -1;
    private int classNameOffset;
    private int classSimpleNameOffset;
    private int classCanonicalNameOffset;
    private int classParentOffset = -1;
    private int classArrayOffset;
    private int classArrayItemOffset;
    private int classNewArrayOffset;
    private int classSupertypeFunctionOffset;
    private int classEnclosingClassOffset;
    private int classDeclaringClassOffset;
    private int classAnnotationsOffset = -1;
    private int classInterfacesOffset = -1;
    private int classFieldsOffset = -1;
    private int classMethodsOffset = -1;
    private int classInstantiatorOffset = -1;
    private int classInitializerOffset = -1;
    private int previousRegularClassOffset = -1;
    private int enumConstantsFunctionOffset = -1;
    private int arrayLengthOffset = -1;
    private int arrayGetOffset = -1;
    private int arraySetOffset = -1;
    private int arrayCopyOffset = -1;
    private int cloneOffset = -1;
    private int servicesOffset = -1;
    private int throwableNativeOffset = -1;
    private WasmStructure arrayVirtualTableStruct;
    private WasmFunction arrayGetObjectFunction;
    private WasmFunction arraySetObjectFunction;
    private WasmFunction arrayLengthObjectFunction;
    private WasmFunction arrayCopyObjectFunction;
    private WasmFunctionType arrayGetType;
    private WasmFunctionType arraySetType;
    private WasmFunctionType arrayLengthType;
    private WasmFunctionType arrayCopyType;
    private List<WasmFunction> multiArrayFunctions = new ArrayList<WasmFunction>();
    private List<WasmStructure> nonInitializedStructures = new ArrayList<WasmStructure>();
    private WasmArray objectArrayType;
    private boolean hasLoadServices;
    private WasmGCSystemFunctionGenerator systemFunctions;
    private boolean compactMode;
    private WasmGCReflectionGenerator reflectionGenerator;

    public WasmGCClassGenerator(WasmModule module, ClassReaderSource classSource, ClassReaderSource originalClassSource, ClassHierarchy hierarchy, DependencyInfo dependencyInfo, WasmFunctionTypes functionTypes, TagRegistry tagRegistry, ClassMetadataRequirements metadataRequirements, WasmGCVirtualTableProvider virtualTables, BaseWasmFunctionRepository functionProvider, WasmGCNameProvider names, ClassInitializerInfo classInitializerInfo, List<WasmGCCustomTypeMapperFactory> customTypeMapperFactories) {
        this.module = module;
        this.classSource = classSource;
        this.originalClassSource = originalClassSource;
        this.hierarchy = hierarchy;
        this.functionTypes = functionTypes;
        this.tagRegistry = tagRegistry;
        this.metadataRequirements = metadataRequirements;
        this.virtualTables = virtualTables;
        this.functionProvider = functionProvider;
        this.names = names;
        this.classInitializerInfo = classInitializerInfo;
        this.standardClasses = new WasmGCStandardClasses(this);
        this.systemFunctions = new WasmGCSystemFunctionGenerator(this, module, functionTypes, names, virtualTables, this.standardClasses);
        this.strings = new WasmGCStringPool(this.standardClasses, module, functionProvider, names, functionTypes, dependencyInfo);
        this.supertypeGenerator = new WasmGCSupertypeFunctionGenerator(module, this, names, tagRegistry, functionTypes, this.queue);
        this.newArrayGenerator = new WasmGCNewArrayFunctionGenerator(module, functionTypes, this, names, this.queue);
        this.typeMapper = new WasmGCTypeMapper(classSource, this, functionTypes);
        WasmGCCustomTypeMapperFactoryContext customTypeMapperFactoryContext = this.customTypeMapperFactoryContext();
        this.typeMapper.setCustomTypeMappers(customTypeMapperFactories.stream().map(factory -> factory.createTypeMapper(customTypeMapperFactoryContext)).collect(Collectors.toList()));
        MethodDependencyInfo loadServicesMethod = dependencyInfo.getMethod(new MethodReference(ServiceLoader.class, "loadServices", Class.class, Object[].class));
        if (loadServicesMethod != null && loadServicesMethod.isUsed()) {
            this.hasLoadServices = true;
        }
        this.annotationsGenerator = new WasmGCAnnotationsGenerator(classSource, metadataRequirements, this, this.strings, this.annotationInitStatements);
        this.reflectionGenerator = new WasmGCReflectionGenerator(module, functionTypes, this, names);
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    private WasmGCCustomTypeMapperFactoryContext customTypeMapperFactoryContext() {
        return new WasmGCCustomTypeMapperFactoryContext(){

            @Override
            public ClassReaderSource originalClasses() {
                return WasmGCClassGenerator.this.originalClassSource;
            }

            @Override
            public ClassReaderSource classes() {
                return WasmGCClassGenerator.this.classSource;
            }

            @Override
            public WasmModule module() {
                return WasmGCClassGenerator.this.module;
            }

            @Override
            public WasmGCClassInfoProvider classInfoProvider() {
                return WasmGCClassGenerator.this;
            }

            @Override
            public WasmGCNameProvider names() {
                return WasmGCClassGenerator.this.names;
            }

            @Override
            public WasmGCTypeMapper typeMapper() {
                return WasmGCClassGenerator.this.typeMapper;
            }

            @Override
            public WasmFunctionTypes functionTypes() {
                return WasmGCClassGenerator.this.functionTypes;
            }
        };
    }

    public WasmGCSupertypeFunctionProvider getSupertypeProvider() {
        return this.supertypeGenerator;
    }

    public boolean process() {
        if (this.queue.isEmpty()) {
            return false;
        }
        while (!this.queue.isEmpty()) {
            Runnable action = this.queue.remove();
            action.run();
            this.initStructures();
        }
        return true;
    }

    public boolean hasSomethingToGenerate() {
        return !this.queue.isEmpty();
    }

    private void initStructures() {
        if (this.nonInitializedStructures.isEmpty()) {
            return;
        }
        List<WasmStructure> copy = List.copyOf(this.nonInitializedStructures);
        this.nonInitializedStructures.clear();
        for (WasmStructure structure : copy) {
            structure.init();
        }
    }

    @Override
    public void contributeToInitializerDefinitions(WasmFunction function) {
    }

    @Override
    public void contributeToInitializer(WasmFunction function) {
        function.getBody().addAll(this.initializerFunctionStatements);
        this.initializerFunctionStatements.clear();
        for (WasmGCClassInfo wasmGCClassInfo : this.classInfoMap.values()) {
            if (wasmGCClassInfo.supertypeFunction != null) {
                function.getBody().add(this.setClassField(wasmGCClassInfo, this.classSupertypeFunctionOffset, new WasmFunctionReference(wasmGCClassInfo.supertypeFunction)));
            }
            if (wasmGCClassInfo.initArrayFunction == null) continue;
            function.getBody().add(this.setClassField(wasmGCClassInfo, this.classNewArrayOffset, new WasmFunctionReference(wasmGCClassInfo.initArrayFunction)));
        }
        for (Consumer consumer : this.staticFieldInitializers) {
            consumer.accept(function);
        }
        if (!this.annotationInitStatements.isEmpty()) {
            WasmFunction annotationsFunction = new WasmFunction(this.functionTypes.of(null, new WasmType[0]));
            annotationsFunction.setName(this.names.topLevel("teavm@initClassAnnotations"));
            this.module.functions.add(annotationsFunction);
            function.getBody().add(new WasmCall(annotationsFunction));
            for (Consumer<WasmFunction> contributor : this.annotationInitStatements) {
                contributor.accept(annotationsFunction);
            }
        }
    }

    private boolean isHeapStructure(String className) {
        byte result = this.heapStructures.getOrDefault(className, (byte)-1);
        if (result < 0) {
            ClassReader cls;
            result = className.equals(Structure.class.getName()) ? (byte)1 : ((cls = this.classSource.get(className)) != null && cls.getParent() != null && this.isHeapStructure(cls.getParent()) ? (byte)1 : 0);
            this.heapStructures.put(className, result);
        }
        return result != 0;
    }

    @Override
    public WasmGCClassInfo getClassInfo(ValueType type) {
        WasmGCClassInfo classInfo = this.classInfoMap.get(type);
        if (classInfo == null) {
            WasmGCClassInfo finalClassInfo = classInfo = new WasmGCClassInfo(type);
            this.queue.add(() -> {
                if (finalClassInfo.initializer != null) {
                    finalClassInfo.initializer.accept(this.initializerFunctionStatements);
                    finalClassInfo.initializer = null;
                }
            });
            this.classInfoMap.put(type, classInfo);
            WasmGCVirtualTable virtualTable = null;
            if (!(type instanceof ValueType.Primitive)) {
                ClassReader classReader;
                String name = type instanceof ValueType.Object ? ((ValueType.Object)type).getClassName() : null;
                boolean isInterface = false;
                ClassReader classReader2 = classReader = name != null ? this.classSource.get(name) : null;
                if (classReader != null && classReader.hasModifier(ElementModifier.INTERFACE)) {
                    isInterface = true;
                    classInfo.structure = this.standardClasses.objectClass().structure;
                } else {
                    ValueType itemType;
                    if (type instanceof ValueType.Array && !((itemType = ((ValueType.Array)type).getItemType()) instanceof ValueType.Primitive) && !itemType.equals(OBJECT_TYPE)) {
                        classInfo.structure = this.getClassInfo((ValueType)ValueType.arrayOf((ValueType)WasmGCClassGenerator.OBJECT_TYPE)).structure;
                    }
                    if (classInfo.structure == null) {
                        if (name != null && this.isHeapStructure(name)) {
                            classInfo.heapStructure = true;
                        } else {
                            String structName = this.names.topLevel(this.names.suggestForType(type));
                            classInfo.structure = new WasmStructure(structName, fields -> this.fillFields(finalClassInfo, (List<WasmField>)fields, type));
                            classInfo.structure.setNominal(true);
                            this.module.types.add(classInfo.structure);
                            this.nonInitializedStructures.add(classInfo.structure);
                        }
                    }
                }
                if (!classInfo.isHeapStructure()) {
                    if (name != null) {
                        virtualTable = this.virtualTables.lookup(name);
                        if (isInterface && virtualTable != null && !virtualTable.isFakeInterfaceRepresentative()) {
                            virtualTable = null;
                        }
                        if (classReader != null && classReader.getParent() != null && !isInterface) {
                            classInfo.structure.setSupertype(this.getClassInfo((String)classReader.getParent()).structure);
                        }
                    } else {
                        virtualTable = this.virtualTables.lookup("java.lang.Object");
                        classInfo.structure.setSupertype(this.standardClasses.objectClass().structure);
                    }
                }
            }
            String pointerName = this.names.topLevel(this.names.suggestForType(type) + "@class");
            String vtName = this.names.topLevel(this.names.suggestForType(type) + "@vt");
            if (virtualTable != null) {
                if (type instanceof ValueType.Object) {
                    if (virtualTable.isUsed()) {
                        this.initRegularVirtualTableStructure(classInfo, ((ValueType.Object)type).getClassName());
                    } else {
                        WasmGCVirtualTable usedVt = virtualTable.getFirstUsed();
                        classInfo.virtualTableStructure = usedVt != null ? this.getClassInfo((String)usedVt.getClassName()).virtualTableStructure : this.standardClasses.objectClass().virtualTableStructure;
                    }
                } else {
                    classInfo.virtualTableStructure = this.getArrayVirtualTableStructure();
                }
            } else {
                classInfo.virtualTableStructure = this.standardClasses.objectClass().virtualTableStructure;
            }
            WasmStructure vtStructure = classInfo.virtualTableStructure;
            if (vtStructure != null) {
                WasmStructure classStructure = this.standardClasses.classClass().getStructure();
                classInfo.pointer = new WasmGlobal(pointerName, classStructure.getNonNullReference(), new WasmStructNewDefault(classStructure));
                classInfo.pointer.setImmutable(true);
                this.module.globals.add(classInfo.pointer);
                if (virtualTable != null && virtualTable.isConcrete()) {
                    classInfo.virtualTablePointer = new WasmGlobal(vtName, vtStructure.getNonNullReference(), new WasmStructNewDefault(vtStructure));
                    if (this.compactMode) {
                        WasmGCClassInfo cls = classInfo;
                        WasmGCVirtualTable vt = virtualTable;
                        this.queue.add(() -> cls.virtualTablePointer.setInitialValue(this.fillVirtualTableInitializer(vt, cls)));
                    }
                    classInfo.virtualTablePointer.setImmutable(true);
                    this.module.globals.add(classInfo.virtualTablePointer);
                }
                if (type instanceof ValueType.Primitive) {
                    this.initPrimitiveClass(classInfo, (ValueType.Primitive)type);
                } else if (type instanceof ValueType.Void) {
                    this.initVoidClass(classInfo);
                } else if (type instanceof ValueType.Array) {
                    this.initArrayClass(classInfo, (ValueType.Array)type);
                } else if (type instanceof ValueType.Object) {
                    this.initRegularClass(classInfo, virtualTable, ((ValueType.Object)type).getClassName());
                }
                ClassMetadataRequirements.Info req = this.metadataRequirements.getInfo(type);
                if (req != null) {
                    if (type instanceof ValueType.Primitive) {
                        classInfo.initArrayFunction = this.getArrayConstructor(classInfo.getValueType());
                        classInfo.initArrayFunction.setReferenced(true);
                    }
                    if (req.isAssignable() && !(type instanceof ValueType.Array)) {
                        WasmFunction supertypeFunction = this.supertypeGenerator.getIsSupertypeFunction(classInfo.getValueType());
                        supertypeFunction.setReferenced(true);
                        classInfo.supertypeFunction = supertypeFunction;
                    }
                }
            }
        }
        return classInfo;
    }

    @Override
    public WasmFunction getArrayConstructor(ValueType type) {
        WasmGCClassInfo arrayInfo = this.getClassInfo(type);
        WasmFunction function = arrayInfo.newArrayFunction;
        if (function == null) {
            arrayInfo.newArrayFunction = function = this.newArrayGenerator.generateNewArrayFunction(type);
        }
        return function;
    }

    @Override
    public WasmFunction getMultiArrayConstructor(int depth) {
        if (depth >= this.multiArrayFunctions.size()) {
            this.multiArrayFunctions.addAll(Collections.nCopies(depth + 1, null));
        }
        WasmFunction result = this.newArrayGenerator.generateNewMultiArrayFunction(depth);
        this.multiArrayFunctions.set(depth, result);
        return result;
    }

    public int getClassTagOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classTagOffset;
    }

    @Override
    public int getClassArrayItemOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classArrayItemOffset;
    }

    @Override
    public int getClassFlagsOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classFlagsOffset;
    }

    @Override
    public int getClassVtFieldOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classVtOffset;
    }

    @Override
    public int getClassSupertypeFunctionOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classSupertypeFunctionOffset;
    }

    @Override
    public int getClassEnclosingClassOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classEnclosingClassOffset;
    }

    @Override
    public int getClassDeclaringClassOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classDeclaringClassOffset;
    }

    @Override
    public int getClassParentOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classParentOffset;
    }

    @Override
    public int getClassNameOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classNameOffset;
    }

    @Override
    public int getClassSimpleNameOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classSimpleNameOffset;
    }

    @Override
    public int getClassCanonicalNameOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classCanonicalNameOffset;
    }

    @Override
    public int getClassAnnotationsOffset() {
        return this.classAnnotationsOffset;
    }

    @Override
    public int getClassInterfacesOffset() {
        return this.classInterfacesOffset;
    }

    @Override
    public int getClassFieldsOffset() {
        return this.classFieldsOffset;
    }

    @Override
    public int getClassMethodsOffset() {
        return this.classMethodsOffset;
    }

    @Override
    public int getClassInstantiatorOffset() {
        return this.classInstantiatorOffset;
    }

    @Override
    public int getClassInitializerOffset() {
        return this.classInitializerOffset;
    }

    @Override
    public int getPreviousRegularClassOffset() {
        return this.previousRegularClassOffset;
    }

    @Override
    public WasmGlobal getLastRegularClassGlobal() {
        return this.lastRegularClassGlobal;
    }

    @Override
    public int getNewArrayFunctionOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classNewArrayOffset;
    }

    @Override
    public int getCloneOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.cloneOffset;
    }

    @Override
    public int getServicesOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.servicesOffset;
    }

    @Override
    public int getThrowableNativeOffset() {
        return this.throwableNativeOffset;
    }

    private void initPrimitiveClass(WasmGCClassInfo classInfo, ValueType.Primitive type) {
        classInfo.initializer = target -> {
            int kind;
            switch (type.getKind()) {
                case BOOLEAN: {
                    kind = 0;
                    break;
                }
                case BYTE: {
                    kind = 1;
                    break;
                }
                case SHORT: {
                    kind = 2;
                    break;
                }
                case CHARACTER: {
                    kind = 3;
                    break;
                }
                case INTEGER: {
                    kind = 4;
                    break;
                }
                case LONG: {
                    kind = 5;
                    break;
                }
                case FLOAT: {
                    kind = 6;
                    break;
                }
                case DOUBLE: {
                    kind = 7;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ClassMetadataRequirements.Info req = this.metadataRequirements.getInfo(type);
            String name = req != null && req.name() ? ReflectionUtil.typeName(type.getKind()) : null;
            target.add(this.fillPrimitiveClass(classInfo.pointer, name, kind));
        };
    }

    private void initVoidClass(WasmGCClassInfo classInfo) {
        classInfo.initializer = target -> target.add(this.fillPrimitiveClass(classInfo.pointer, "void", 8));
    }

    private void initRegularClass(WasmGCClassInfo classInfo, WasmGCVirtualTable virtualTable, String name) {
        ClassReader cls = this.classSource.get(name);
        if (this.classInitializerInfo.isDynamicInitializer(name) && cls != null && cls.getMethod(CLINIT_METHOD_DESC) != null) {
            WasmFunctionType clinitType = this.functionTypes.of(null, new WasmType[0]);
            String wasmName = this.names.topLevel(this.names.suggestForClass(name) + "@initializer");
            classInfo.initializerPointer = new WasmGlobal(wasmName, clinitType.getReference(), new WasmNullConstant(clinitType.getReference()));
            this.module.globals.add(classInfo.initializerPointer);
        }
        classInfo.initializer = target -> {
            WasmGlobal namePtr;
            this.standardClasses.classClass().getStructure().init();
            List<TagRegistry.Range> ranges = this.tagRegistry.getRanges(name);
            int tag = ranges.stream().mapToInt(range -> range.lower).min().orElse(0);
            int flags = cls != null ? this.getFlags(cls) : 0;
            target.add(new WasmCall(this.getFillRegularClassFunction(), new WasmGetGlobal(classInfo.pointer), new WasmInt32Constant(tag), new WasmInt32Constant(flags)));
            ClassMetadataRequirements.Info metadataReq = this.metadataRequirements.getInfo(name);
            if (metadataReq.name()) {
                namePtr = this.strings.getStringConstant((String)name).global;
                target.add(this.setClassField(classInfo, this.classNameOffset, new WasmGetGlobal(namePtr)));
            }
            if (cls != null) {
                WasmGCClassInfo owner;
                if (metadataReq.simpleName() && cls.getSimpleName() != null) {
                    namePtr = this.strings.getStringConstant((String)cls.getSimpleName()).global;
                    target.add(this.setClassField(classInfo, this.classSimpleNameOffset, new WasmGetGlobal(namePtr)));
                }
                if (cls.getParent() != null && metadataReq.superclass()) {
                    WasmGCClassInfo parent = this.getClassInfo(cls.getParent());
                    target.add(this.setClassField(classInfo, this.classParentOffset, new WasmGetGlobal(parent.pointer)));
                }
                if (cls.getOwnerName() != null && metadataReq.enclosingClass()) {
                    owner = this.getClassInfo(cls.getOwnerName());
                    target.add(this.setClassField(classInfo, this.classEnclosingClassOffset, new WasmGetGlobal(owner.pointer)));
                }
                if (cls.getDeclaringClassName() != null && metadataReq.declaringClass()) {
                    owner = this.getClassInfo(cls.getDeclaringClassName());
                    target.add(this.setClassField(classInfo, this.classDeclaringClassOffset, new WasmGetGlobal(owner.pointer)));
                }
                if (metadataReq.cloneMethod()) {
                    WasmFunction cloneFunction = this.hierarchy.isSuperType("java.lang.Cloneable", name, false) ? this.generateCloneFunction(classInfo, name) : this.functionProvider.forStaticMethod(new MethodReference(WasmGCSupport.class, "defaultClone", Object.class, Object.class));
                    cloneFunction.setReferenced(true);
                    target.add(this.setClassField(classInfo, this.cloneOffset, new WasmFunctionReference(cloneFunction)));
                }
                if (metadataReq.enumConstants() && cls.hasModifier(ElementModifier.ENUM)) {
                    target.add(this.setClassField(classInfo, this.enumConstantsFunctionOffset, new WasmFunctionReference(this.createEnumConstantsFunction(classInfo, cls))));
                }
                if (metadataReq.interfaces() && !cls.getInterfaces().isEmpty()) {
                    target.add(this.setClassField(classInfo, this.classInterfacesOffset, this.createInterfacesArray(cls)));
                }
            }
            if (classInfo.virtualTablePointer != null) {
                if (this.compactMode) {
                    this.assignVTToClass(classInfo, (List<WasmExpression>)target);
                } else {
                    this.fillVirtualTableMethods((List<WasmExpression>)target, virtualTable, classInfo);
                }
            }
            if (classInfo.initializerPointer != null) {
                WasmFunction initFunction = this.functionProvider.forStaticMethod(new MethodReference(name, CLINIT_METHOD_DESC));
                initFunction.setReferenced(true);
                classInfo.initializerPointer.setInitialValue(new WasmFunctionReference(initFunction));
                if (this.classInitializerOffset >= 0 && metadataReq != null && metadataReq.classInit()) {
                    target.add(this.setClassField(classInfo, this.classInitializerOffset, new WasmFunctionReference(initFunction)));
                }
            }
        };
        this.annotationsGenerator.addClassAnnotations(name, classInfo);
    }

    private WasmExpression createInterfacesArray(ClassReader cls) {
        WasmArrayNewFixed result = new WasmArrayNewFixed(this.getObjectArrayType());
        for (String itf : cls.getInterfaces()) {
            result.getElements().add(new WasmGetGlobal(this.getClassInfo(itf).getPointer()));
        }
        return result;
    }

    private void assignClassToVT(WasmGCVirtualTable virtualTable, WasmGCClassInfo classInfo, List<WasmExpression> target) {
        if (virtualTable != null) {
            while (virtualTable.getParent() != null) {
                virtualTable = virtualTable.getParent();
            }
            if (!virtualTable.getClassName().equals("java.lang.Object")) {
                return;
            }
        }
        WasmStructure vtStruct = this.standardClasses.objectClass().getVirtualTableStructure();
        this.standardClasses.classClass().getStructure().init();
        target.add(new WasmStructSet(vtStruct, new WasmGetGlobal(classInfo.virtualTablePointer), 0, new WasmGetGlobal(classInfo.pointer)));
        this.assignVTToClass(classInfo, target);
    }

    private void assignVTToClass(WasmGCClassInfo classInfo, List<WasmExpression> target) {
        target.add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetGlobal(classInfo.pointer), this.getClassVtFieldOffset(), new WasmGetGlobal(classInfo.virtualTablePointer)));
    }

    private int getFlags(ClassReader cls) {
        AnnotationReader retention;
        int flags = 0;
        switch (cls.getLevel()) {
            case PUBLIC: {
                flags |= 1;
                break;
            }
            case PRIVATE: {
                flags |= 2;
                break;
            }
            case PROTECTED: {
                flags |= 4;
                break;
            }
        }
        if (cls.hasModifier(ElementModifier.ABSTRACT)) {
            flags |= 0x400;
        }
        if (cls.hasModifier(ElementModifier.INTERFACE)) {
            flags |= 0x200;
        }
        if (cls.hasModifier(ElementModifier.FINAL)) {
            flags |= 0x10;
        }
        if (cls.hasModifier(ElementModifier.ANNOTATION)) {
            flags |= 0x2000;
        }
        if (cls.hasModifier(ElementModifier.SYNTHETIC)) {
            flags |= 0x4000;
        }
        if (cls.hasModifier(ElementModifier.ENUM)) {
            flags |= 0x1000;
        }
        if (cls.hasModifier(ElementModifier.ANNOTATION) && (retention = cls.getAnnotations().get(Retention.class.getName())) != null && retention.getValue("value").getEnumValue().getFieldName().equals("RUNTIME") && cls.getAnnotations().get(Inherited.class.getName()) != null) {
            flags |= 0x100000;
        }
        return flags;
    }

    private WasmFunction generateCloneFunction(WasmGCClassInfo classInfo, String className) {
        WasmFunction function = new WasmFunction(this.functionTypes.of(this.standardClasses.objectClass().getType(), this.standardClasses.objectClass().getType()));
        function.setName(this.names.topLevel(className + "@clone"));
        this.module.functions.add(function);
        WasmLocal objLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "obj");
        WasmLocal castObjLocal = new WasmLocal(classInfo.getType(), "castObj");
        function.add(objLocal);
        function.add(castObjLocal);
        WasmCast cast = new WasmCast(new WasmGetLocal(objLocal), classInfo.getStructure().getReference());
        function.getBody().add(new WasmSetLocal(castObjLocal, cast));
        WasmStructNew copy = new WasmStructNew(classInfo.structure);
        for (int i = 0; i < classInfo.structure.getFields().size(); ++i) {
            if (i == 1) {
                copy.getInitializers().add(new WasmNullConstant(WasmType.Reference.EQ));
                continue;
            }
            WasmStorageType fieldType = classInfo.structure.getFields().get(i).getType();
            WasmStructGet getExpr = new WasmStructGet(classInfo.structure, new WasmGetLocal(castObjLocal), i);
            if (fieldType instanceof WasmStorageType.Packed) {
                getExpr.setSignedType(WasmSignedType.UNSIGNED);
            }
            copy.getInitializers().add(getExpr);
        }
        function.getBody().add(copy);
        return function;
    }

    private void fillVirtualTableMethods(List<WasmExpression> target, WasmGCVirtualTable virtualTable, WasmGCClassInfo classInfo) {
        WasmGCVirtualTable usedVt = virtualTable.getFirstUsed();
        if (usedVt == null) {
            return;
        }
        WasmGlobal global = classInfo.virtualTablePointer;
        WasmStructure structure = classInfo.virtualTableStructure;
        boolean isObject = this.isObject(usedVt);
        if (isObject) {
            target.add(new WasmCall(this.systemFunctions.getFillObjectVirtualTableFunction(), new WasmGetGlobal(global), new WasmGetGlobal(classInfo.pointer)));
        }
        for (int i = 0; i < usedVt.getEntries().size(); ++i) {
            WasmGCVirtualTableEntry entry = virtualTable.getEntries().get(i);
            MethodReference implementor = virtualTable.implementor(entry);
            if (implementor == null || isObject && implementor.getClassName().equals("java.lang.Object")) continue;
            this.fillVirtualTableEntry(target, global, structure, virtualTable, entry);
        }
        if (!isObject) {
            this.assignClassToVT(virtualTable, classInfo, target);
        }
    }

    private WasmExpression fillVirtualTableInitializer(WasmGCVirtualTable virtualTable, WasmGCClassInfo classInfo) {
        int i;
        WasmGCVirtualTable usedVt = virtualTable.getFirstUsed();
        if (usedVt == null) {
            return new WasmStructNewDefault(classInfo.structure);
        }
        WasmExpression[] entries = new WasmExpression[classInfo.virtualTableStructure.getFields().size()];
        for (i = 0; i < usedVt.getEntries().size(); ++i) {
            WasmGCVirtualTableEntry entry = virtualTable.getEntries().get(i);
            MethodReference implementor = virtualTable.implementor(entry);
            if (implementor == null) continue;
            WasmFunction function = this.functionProvider.forInstanceMethod(implementor);
            function.setReferenced(true);
            entries[entry.getIndex() + 1] = new WasmFunctionReference(function);
        }
        if (classInfo.getValueType() instanceof ValueType.Array) {
            this.applyArrayVirtualTable(entries, (ValueType.Array)classInfo.getValueType(), classInfo.structure);
        }
        entries[0] = new WasmGetGlobal(classInfo.pointer);
        for (i = 1; i < classInfo.virtualTableStructure.getFields().size(); ++i) {
            if (entries[i] != null) continue;
            WasmType functionType = classInfo.virtualTableStructure.getFields().get(i).getUnpackedType();
            entries[i] = new WasmNullConstant((WasmType.Reference)functionType);
        }
        WasmStructNew result = new WasmStructNew(classInfo.virtualTableStructure);
        result.getInitializers().addAll(List.of(entries));
        return result;
    }

    private void applyArrayVirtualTable(WasmExpression[] entries, ValueType.Array type, WasmStructure objectStructure) {
        WasmStructure structure = this.getArrayVirtualTableStructure();
        structure.init();
        ValueType itemType = type.getItemType();
        ClassMetadataRequirements.Info info = this.metadataRequirements.getInfo(type);
        if (info.arrayLength()) {
            WasmFunction lengthFunction = this.getArrayLengthFunction(objectStructure);
            entries[this.arrayLengthOffset] = new WasmFunctionReference(lengthFunction);
        }
        if (info.arrayGet()) {
            WasmFunction getFunction = this.getArrayGetFunction(itemType);
            entries[this.arrayGetOffset] = new WasmFunctionReference(getFunction);
        }
        if (info.arraySet()) {
            WasmFunction setFunction = this.getArraySetFunction(itemType);
            entries[this.arraySetOffset] = new WasmFunctionReference(setFunction);
        }
        if (info.arrayCopy()) {
            WasmFunction copyFunction = this.getArrayCopyFunction(itemType);
            entries[this.arrayCopyOffset] = new WasmFunctionReference(copyFunction);
        }
    }

    private boolean isObject(WasmGCVirtualTable vt) {
        while (vt != null) {
            if (vt.getClassName().equals("java.lang.Object")) {
                return true;
            }
            vt = vt.getParent();
        }
        return false;
    }

    private void fillArrayVirtualTableMethods(ValueType type, List<WasmExpression> target, WasmGlobal global, WasmGlobal classGlobal, WasmStructure objectStructure) {
        WasmStructure structure = this.getArrayVirtualTableStructure();
        structure.init();
        ValueType itemType = ((ValueType.Array)type).getItemType();
        target.add(new WasmCall(this.systemFunctions.getFillObjectVirtualTableFunction(), new WasmGetGlobal(global), new WasmGetGlobal(classGlobal)));
        ClassMetadataRequirements.Info info = this.metadataRequirements.getInfo(type);
        if (info.arrayLength()) {
            WasmFunction lengthFunction = this.getArrayLengthFunction(objectStructure);
            target.add(new WasmStructSet(structure, new WasmGetGlobal(global), this.arrayLengthOffset, new WasmFunctionReference(lengthFunction)));
        }
        if (info.arrayGet()) {
            WasmFunction getFunction = this.getArrayGetFunction(itemType);
            target.add(new WasmStructSet(structure, new WasmGetGlobal(global), this.arrayGetOffset, new WasmFunctionReference(getFunction)));
        }
        if (info.arraySet()) {
            WasmFunction setFunction = this.getArraySetFunction(itemType);
            target.add(new WasmStructSet(structure, new WasmGetGlobal(global), this.arraySetOffset, new WasmFunctionReference(setFunction)));
        }
        if (info.arrayCopy()) {
            WasmFunction copyFunction = this.getArrayCopyFunction(itemType);
            target.add(new WasmStructSet(structure, new WasmGetGlobal(global), this.arrayCopyOffset, new WasmFunctionReference(copyFunction)));
        }
    }

    private WasmFunction getArrayLengthFunction(WasmStructure objectStructure) {
        WasmType.CompositeReference arrayTypeRef = (WasmType.CompositeReference)objectStructure.getFields().get(2).getUnpackedType();
        WasmArray arrayType = (WasmArray)arrayTypeRef.composite;
        WasmType elementType = arrayType.getElementType().asUnpackedType();
        if (elementType instanceof WasmType.Reference) {
            if (this.arrayLengthObjectFunction == null) {
                this.arrayLengthObjectFunction = this.createArrayLengthFunction(objectStructure);
            }
            return this.arrayLengthObjectFunction;
        }
        return this.createArrayLengthFunction(objectStructure);
    }

    private WasmFunction createArrayLengthFunction(WasmStructure objectStructure) {
        WasmFunction function = new WasmFunction(this.functionTypes.of(WasmType.INT32, this.standardClasses.classClass().getType(), this.standardClasses.objectClass().getType()));
        function.setReferenced(true);
        function.setName(this.names.topLevel("Array<*>::length"));
        this.module.functions.add(function);
        WasmLocal classLocal = new WasmLocal(this.standardClasses.classClass().getType(), "this");
        WasmLocal objectLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "object");
        function.add(classLocal);
        function.add(objectLocal);
        WasmCast castObject = new WasmCast(new WasmGetLocal(objectLocal), objectStructure.getNonNullReference());
        WasmStructGet arrayField = new WasmStructGet(objectStructure, castObject, 2);
        WasmArrayLength result = new WasmArrayLength(arrayField);
        function.getBody().add(result);
        return function;
    }

    private WasmFunction getArrayGetFunction(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            return this.generateArrayGetPrimitiveFunction(((ValueType.Primitive)itemType).getKind());
        }
        return this.getArrayGetObjectFunction();
    }

    private WasmFunction getArrayGetObjectFunction() {
        if (this.arrayGetObjectFunction == null) {
            this.arrayGetObjectFunction = new WasmFunction(this.getArrayGetType());
            this.arrayGetObjectFunction.setName(this.names.topLevel("Array<" + this.names.suggestForClass("java.lang.Object") + "::get"));
            this.module.functions.add(this.arrayGetObjectFunction);
            this.arrayGetObjectFunction.setReferenced(true);
            WasmStructure arrayStruct = this.getClassInfo((ValueType)ValueType.arrayOf((ValueType)WasmGCClassGenerator.OBJECT_TYPE)).structure;
            WasmType.CompositeReference arrayDataTypeRef = (WasmType.CompositeReference)arrayStruct.getFields().get(2).getUnpackedType();
            WasmArray arrayDataType = (WasmArray)arrayDataTypeRef.composite;
            WasmLocal selfLocal = new WasmLocal(this.standardClasses.classClass().getType(), "this");
            WasmLocal objectLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "object");
            WasmLocal indexLocal = new WasmLocal(WasmType.INT32, "index");
            this.arrayGetObjectFunction.add(selfLocal);
            this.arrayGetObjectFunction.add(objectLocal);
            this.arrayGetObjectFunction.add(indexLocal);
            WasmCast array = new WasmCast(new WasmGetLocal(objectLocal), arrayStruct.getNonNullReference());
            WasmStructGet arrayData = new WasmStructGet(arrayStruct, array, 2);
            WasmArrayGet result = new WasmArrayGet(arrayDataType, arrayData, new WasmGetLocal(indexLocal));
            this.arrayGetObjectFunction.getBody().add(result);
        }
        return this.arrayGetObjectFunction;
    }

    private WasmFunction generateArrayGetPrimitiveFunction(PrimitiveType type) {
        Class wrapperType;
        Class<Comparable<Boolean>> primitiveType;
        WasmFunction function = new WasmFunction(this.getArrayGetType());
        function.setName(this.names.topLevel("Array<" + this.names.suggestForType(ValueType.primitive(type)) + ">::get"));
        this.module.functions.add(function);
        function.setReferenced(true);
        WasmStructure arrayStruct = this.getClassInfo((ValueType)ValueType.arrayOf((ValueType)ValueType.primitive((PrimitiveType)type))).structure;
        WasmType.CompositeReference arrayDataTypeRef = (WasmType.CompositeReference)arrayStruct.getFields().get(2).getUnpackedType();
        WasmArray arrayDataType = (WasmArray)arrayDataTypeRef.composite;
        WasmLocal classLocal = new WasmLocal(this.standardClasses.classClass().getType(), "this");
        WasmLocal objectLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "object");
        WasmLocal indexLocal = new WasmLocal(WasmType.INT32, "index");
        function.add(classLocal);
        function.add(objectLocal);
        function.add(indexLocal);
        WasmCast array = new WasmCast(new WasmGetLocal(objectLocal), arrayStruct.getNonNullReference());
        WasmStructGet arrayData = new WasmStructGet(arrayStruct, array, 2);
        WasmArrayGet result = new WasmArrayGet(arrayDataType, arrayData, new WasmGetLocal(indexLocal));
        switch (type) {
            case BOOLEAN: {
                primitiveType = Boolean.TYPE;
                wrapperType = Boolean.class;
                result.setSignedType(WasmSignedType.UNSIGNED);
                break;
            }
            case BYTE: {
                primitiveType = Byte.TYPE;
                wrapperType = Byte.class;
                result.setSignedType(WasmSignedType.SIGNED);
                break;
            }
            case SHORT: {
                primitiveType = Short.TYPE;
                wrapperType = Short.class;
                result.setSignedType(WasmSignedType.SIGNED);
                break;
            }
            case CHARACTER: {
                primitiveType = Character.TYPE;
                wrapperType = Character.class;
                result.setSignedType(WasmSignedType.UNSIGNED);
                break;
            }
            case INTEGER: {
                primitiveType = Integer.TYPE;
                wrapperType = Integer.class;
                break;
            }
            case LONG: {
                primitiveType = Long.TYPE;
                wrapperType = Long.class;
                break;
            }
            case FLOAT: {
                primitiveType = Float.TYPE;
                wrapperType = Float.class;
                break;
            }
            case DOUBLE: {
                primitiveType = Double.TYPE;
                wrapperType = Double.class;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        MethodReference method = new MethodReference(wrapperType, "valueOf", primitiveType, wrapperType);
        WasmFunction wrapFunction = this.functionProvider.forStaticMethod(method);
        WasmCall castResult = new WasmCall(wrapFunction, result);
        function.getBody().add(castResult);
        return function;
    }

    private WasmFunction getArraySetFunction(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            return this.generateArraySetPrimitiveFunction(((ValueType.Primitive)itemType).getKind());
        }
        return this.getArraySetObjectFunction();
    }

    private WasmFunction getArrayCopyFunction(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            return this.createArrayCopyFunction(itemType);
        }
        return this.getArrayCopyObjectFunction();
    }

    private WasmFunction getArraySetObjectFunction() {
        if (this.arraySetObjectFunction == null) {
            this.arraySetObjectFunction = new WasmFunction(this.getArraySetType());
            this.arraySetObjectFunction.setName(this.names.topLevel("Array<" + this.names.suggestForClass("java.lang.Object") + "::set"));
            this.module.functions.add(this.arraySetObjectFunction);
            this.arraySetObjectFunction.setReferenced(true);
            WasmStructure arrayStruct = this.getClassInfo((ValueType)ValueType.arrayOf((ValueType)WasmGCClassGenerator.OBJECT_TYPE)).structure;
            WasmType.CompositeReference arrayDataTypeRef = (WasmType.CompositeReference)arrayStruct.getFields().get(2).getUnpackedType();
            WasmArray arrayDataType = (WasmArray)arrayDataTypeRef.composite;
            WasmLocal selfLocal = new WasmLocal(this.standardClasses.classClass().getType(), "this");
            WasmLocal objectLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "object");
            WasmLocal indexLocal = new WasmLocal(WasmType.INT32, "index");
            WasmLocal valueLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "value");
            this.arraySetObjectFunction.add(selfLocal);
            this.arraySetObjectFunction.add(objectLocal);
            this.arraySetObjectFunction.add(indexLocal);
            this.arraySetObjectFunction.add(valueLocal);
            WasmCast array = new WasmCast(new WasmGetLocal(objectLocal), arrayStruct.getNonNullReference());
            WasmStructGet arrayData = new WasmStructGet(arrayStruct, array, 2);
            WasmArraySet set = new WasmArraySet(arrayDataType, arrayData, new WasmGetLocal(indexLocal), new WasmGetLocal(valueLocal));
            this.arraySetObjectFunction.getBody().add(set);
        }
        return this.arraySetObjectFunction;
    }

    private WasmFunction generateArraySetPrimitiveFunction(PrimitiveType type) {
        Class wrapperType;
        Class<Comparable<Boolean>> primitiveType;
        WasmFunction function = new WasmFunction(this.getArraySetType());
        function.setName(this.names.topLevel("Array<" + this.names.suggestForType(ValueType.primitive(type)) + ">::set"));
        this.module.functions.add(function);
        function.setReferenced(true);
        WasmStructure arrayStruct = this.getClassInfo((ValueType)ValueType.arrayOf((ValueType)ValueType.primitive((PrimitiveType)type))).structure;
        WasmType.CompositeReference arrayDataTypeRef = (WasmType.CompositeReference)arrayStruct.getFields().get(2).getUnpackedType();
        WasmArray arrayDataType = (WasmArray)arrayDataTypeRef.composite;
        WasmLocal classLocal = new WasmLocal(this.standardClasses.classClass().getType(), "this");
        WasmLocal objectLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "object");
        WasmLocal indexLocal = new WasmLocal(WasmType.INT32, "index");
        WasmLocal valueLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "value");
        function.add(classLocal);
        function.add(objectLocal);
        function.add(indexLocal);
        function.add(valueLocal);
        WasmCast array = new WasmCast(new WasmGetLocal(objectLocal), arrayStruct.getNonNullReference());
        WasmStructGet arrayData = new WasmStructGet(arrayStruct, array, 2);
        WasmArraySet set = new WasmArraySet(arrayDataType, arrayData, new WasmGetLocal(indexLocal), new WasmGetLocal(valueLocal));
        switch (type) {
            case BOOLEAN: {
                primitiveType = Boolean.TYPE;
                wrapperType = Boolean.class;
                break;
            }
            case BYTE: {
                primitiveType = Byte.TYPE;
                wrapperType = Byte.class;
                break;
            }
            case SHORT: {
                primitiveType = Short.TYPE;
                wrapperType = Short.class;
                break;
            }
            case CHARACTER: {
                primitiveType = Character.TYPE;
                wrapperType = Character.class;
                break;
            }
            case INTEGER: {
                primitiveType = Integer.TYPE;
                wrapperType = Integer.class;
                break;
            }
            case LONG: {
                primitiveType = Long.TYPE;
                wrapperType = Long.class;
                break;
            }
            case FLOAT: {
                primitiveType = Float.TYPE;
                wrapperType = Float.class;
                break;
            }
            case DOUBLE: {
                primitiveType = Double.TYPE;
                wrapperType = Double.class;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        MethodReference method = new MethodReference(wrapperType, primitiveType.getName() + "Value", primitiveType);
        WasmFunction unwrapFunction = this.functionProvider.forInstanceMethod(method);
        set.setValue(new WasmCast(set.getValue(), this.getClassInfo(ValueType.parse(wrapperType)).getType()));
        set.setValue(new WasmCall(unwrapFunction, set.getValue()));
        function.getBody().add(set);
        return function;
    }

    private WasmFunction getArrayCopyObjectFunction() {
        if (this.arrayCopyObjectFunction == null) {
            this.arrayCopyObjectFunction = this.createArrayCopyFunction(OBJECT_TYPE);
        }
        return this.arrayCopyObjectFunction;
    }

    private WasmFunction createArrayCopyFunction(ValueType type) {
        WasmFunction function = new WasmFunction(this.getArrayCopyType());
        function.setName(this.names.topLevel("Array<" + this.names.suggestForType(type) + ">::copy"));
        this.module.functions.add(function);
        function.setReferenced(true);
        WasmStructure arrayStruct = this.getClassInfo((ValueType)ValueType.arrayOf((ValueType)type)).structure;
        WasmType.CompositeReference arrayDataTypeRef = (WasmType.CompositeReference)arrayStruct.getFields().get(2).getUnpackedType();
        WasmArray arrayDataType = (WasmArray)arrayDataTypeRef.composite;
        WasmLocal thisLocal = new WasmLocal(this.standardClasses.classClass().getType(), "this");
        WasmLocal sourceLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "source");
        WasmLocal sourceIndexLocal = new WasmLocal(WasmType.INT32, "sourceIndex");
        WasmLocal targetLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "target");
        WasmLocal targetIndexLocal = new WasmLocal(WasmType.INT32, "targetIndex");
        WasmLocal countLocal = new WasmLocal(WasmType.INT32, "count");
        function.add(thisLocal);
        function.add(sourceLocal);
        function.add(sourceIndexLocal);
        function.add(targetLocal);
        function.add(targetIndexLocal);
        function.add(countLocal);
        WasmCast sourceArray = new WasmCast(new WasmGetLocal(sourceLocal), arrayStruct.getNonNullReference());
        WasmStructGet sourceArrayData = new WasmStructGet(arrayStruct, sourceArray, 2);
        WasmCast targetArray = new WasmCast(new WasmGetLocal(targetLocal), arrayStruct.getNonNullReference());
        WasmStructGet targetArrayData = new WasmStructGet(arrayStruct, targetArray, 2);
        function.getBody().add(new WasmArrayCopy(arrayDataType, targetArrayData, new WasmGetLocal(targetIndexLocal), arrayDataType, sourceArrayData, new WasmGetLocal(sourceIndexLocal), new WasmGetLocal(countLocal)));
        return function;
    }

    private WasmFunctionType getArrayGetType() {
        if (this.arrayGetType == null) {
            this.arrayGetType = this.functionTypes.of(this.standardClasses.objectClass().getType(), this.standardClasses.classClass().getType(), this.standardClasses.objectClass().getType(), WasmType.INT32);
        }
        return this.arrayGetType;
    }

    private WasmFunctionType getArraySetType() {
        if (this.arraySetType == null) {
            this.arraySetType = this.functionTypes.of(null, this.standardClasses.classClass().getType(), this.standardClasses.objectClass().getType(), WasmType.INT32, this.standardClasses.objectClass().getType());
        }
        return this.arraySetType;
    }

    private WasmFunctionType getArrayLengthType() {
        if (this.arrayLengthType == null) {
            this.arrayLengthType = this.functionTypes.of(WasmType.INT32, this.standardClasses.classClass().getType(), this.standardClasses.objectClass().getType());
        }
        return this.arrayLengthType;
    }

    private WasmFunctionType getArrayCopyType() {
        if (this.arrayCopyType == null) {
            this.arrayCopyType = this.functionTypes.of(null, this.standardClasses.classClass().getType(), this.standardClasses.objectClass().getType(), WasmType.INT32, this.standardClasses.objectClass().getType(), WasmType.INT32, WasmType.INT32);
        }
        return this.arrayCopyType;
    }

    private void fillVirtualTableEntry(List<WasmExpression> target, WasmGlobal global, WasmStructure structure, WasmGCVirtualTable virtualTable, WasmGCVirtualTableEntry entry) {
        this.fillVirtualTableEntry(target, () -> new WasmGetGlobal(global), structure, virtualTable, entry);
    }

    void fillVirtualTableEntry(List<WasmExpression> target, Supplier<WasmExpression> vtInstance, WasmStructure structure, WasmGCVirtualTable virtualTable, WasmGCVirtualTableEntry entry) {
        MethodReference implementor = virtualTable.implementor(entry);
        if (entry.getOrigin() != virtualTable) {
            structure = this.getClassInfo((String)entry.getOrigin().getClassName()).virtualTableStructure;
        }
        if (implementor != null && !entry.getMethod().equals(GET_CLASS_METHOD)) {
            int fieldIndex = 1 + entry.getIndex();
            WasmType.CompositeReference expectedType = (WasmType.CompositeReference)structure.getFields().get(fieldIndex).getUnpackedType();
            WasmFunctionType expectedFunctionType = (WasmFunctionType)expectedType.composite;
            WasmFunction function = this.functionProvider.forInstanceMethod(implementor);
            if (!entry.getOrigin().getClassName().equals(implementor.getClassName()) || expectedFunctionType != function.getType()) {
                WasmFunction wrapperFunction = new WasmFunction(expectedFunctionType);
                wrapperFunction.setName(this.names.topLevel(this.names.suggestForMethod(implementor) + "@caller"));
                this.module.functions.add(wrapperFunction);
                WasmCall call = new WasmCall(function);
                WasmLocal instanceParam = new WasmLocal(this.getClassInfo(virtualTable.getClassName()).getType());
                wrapperFunction.add(instanceParam);
                WasmType.CompositeReference castTarget = this.getClassInfo(implementor.getClassName()).getStructure().getReference();
                call.getArguments().add(new WasmCast(new WasmGetLocal(instanceParam), castTarget));
                WasmLocal[] params = new WasmLocal[entry.getMethod().parameterCount()];
                for (int i = 0; i < entry.getMethod().parameterCount(); ++i) {
                    params[i] = new WasmLocal(this.typeMapper.mapType(entry.getMethod().parameterType(i)));
                    call.getArguments().add(new WasmGetLocal(params[i]));
                    wrapperFunction.add(params[i]);
                }
                wrapperFunction.getBody().add(call);
                function = wrapperFunction;
            }
            function.setReferenced(true);
            WasmFunctionReference ref = new WasmFunctionReference(function);
            target.add(new WasmStructSet(structure, vtInstance.get(), fieldIndex, ref));
        }
    }

    private WasmFunction generateArrayCloneMethod(WasmStructure objectStructure, ValueType itemType) {
        WasmType.CompositeReference arrayTypeRef = (WasmType.CompositeReference)objectStructure.getFields().get(2).getUnpackedType();
        WasmArray arrayType = (WasmArray)arrayTypeRef.composite;
        WasmFunctionType type = this.typeMapper.getFunctionType(this.standardClasses.objectClass().getType(), CLONE_METHOD_DESC);
        WasmFunction function = new WasmFunction(type);
        function.setName(this.names.topLevel("Array<" + this.names.suggestForType(itemType) + ">::clone"));
        this.module.functions.add(function);
        WasmLocal instanceLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "instance");
        WasmLocal originalLocal = new WasmLocal(objectStructure.getReference(), "original");
        WasmLocal originalDataLocal = new WasmLocal(arrayType.getNonNullReference(), "originalData");
        WasmLocal dataCopyLocal = new WasmLocal(arrayType.getNonNullReference(), "resultData");
        function.add(instanceLocal);
        function.add(originalLocal);
        function.add(originalDataLocal);
        function.add(dataCopyLocal);
        WasmStructNew newExpr = new WasmStructNew(objectStructure);
        function.getBody().add(new WasmSetLocal(originalLocal, new WasmCast(new WasmGetLocal(instanceLocal), objectStructure.getNonNullReference())));
        WasmStructGet classValue = new WasmStructGet(objectStructure, new WasmGetLocal(originalLocal), 0);
        newExpr.getInitializers().add(classValue);
        newExpr.getInitializers().add(new WasmNullConstant(WasmType.Reference.EQ));
        WasmStructGet originalDataValue = new WasmStructGet(objectStructure, new WasmGetLocal(originalLocal), 2);
        function.getBody().add(new WasmSetLocal(originalDataLocal, originalDataValue));
        WasmArrayLength originalLength = new WasmArrayLength(new WasmGetLocal(originalDataLocal));
        function.getBody().add(new WasmSetLocal(dataCopyLocal, new WasmArrayNewDefault(arrayType, originalLength)));
        newExpr.getInitializers().add(new WasmGetLocal(dataCopyLocal));
        function.getBody().add(new WasmArrayCopy(arrayType, new WasmGetLocal(dataCopyLocal), new WasmInt32Constant(0), arrayType, new WasmGetLocal(originalDataLocal), new WasmInt32Constant(0), new WasmArrayLength(new WasmGetLocal(originalDataLocal))));
        function.getBody().add(newExpr);
        return function;
    }

    private void initRegularVirtualTableStructure(WasmGCClassInfo classInfo, String className) {
        WasmStructure structure;
        WasmGCVirtualTable virtualTable = this.virtualTables.lookup(className);
        String wasmName = this.names.topLevel("VT<" + this.names.suggestForClass(className) + ">");
        classInfo.virtualTableStructure = structure = new WasmStructure(wasmName, fields -> {
            this.addVirtualTableBaseFields((List<WasmField>)fields);
            this.addVirtualTableFields((List<WasmField>)fields, virtualTable);
        });
        this.nonInitializedStructures.add(structure);
        WasmGCVirtualTable usedParent = virtualTable.getUsedParent();
        WasmStructure supertype = usedParent != null ? this.getClassInfo(usedParent.getClassName()).getVirtualTableStructure() : null;
        structure.setSupertype(supertype);
        this.module.types.add(structure);
    }

    private void addVirtualTableBaseFields(List<WasmField> fields) {
        WasmField classField = new WasmField(this.standardClasses.classClass().getType().asStorage());
        classField.setName(this.names.forMemberField(FAKE_CLASS_FIELD));
        fields.add(classField);
    }

    private void addSystemFields(List<WasmField> fields) {
        WasmField vtField = new WasmField(this.standardClasses.objectClass().getVirtualTableStructure().getReference().asStorage());
        vtField.setName(this.names.forMemberField(FAKE_VT_FIELD));
        fields.add(vtField);
        WasmField monitorField = new WasmField(WasmType.Reference.EQ.asStorage());
        monitorField.setName(this.names.forMemberField(FAKE_MONITOR_FIELD));
        fields.add(monitorField);
    }

    private void addVirtualTableFields(List<WasmField> fields, WasmGCVirtualTable virtualTable) {
        for (WasmGCVirtualTableEntry wasmGCVirtualTableEntry : virtualTable.getEntries()) {
            WasmType.SpecialReference receiverType = this.compactMode ? WasmType.Reference.ANY : this.getClassInfo(wasmGCVirtualTableEntry.getOrigin().getClassName()).getType();
            WasmFunctionType functionType = this.typeMapper.getFunctionType(receiverType, wasmGCVirtualTableEntry.getMethod());
            WasmField field = new WasmField(functionType.getReference().asStorage());
            field.setName(this.names.forVirtualMethod(wasmGCVirtualTableEntry.getMethod()));
            fields.add(field);
        }
    }

    @Override
    public WasmStructure getArrayVirtualTableStructure() {
        if (this.arrayVirtualTableStruct == null) {
            String wasmName = this.names.topLevel("VT<Array<*>>");
            this.arrayVirtualTableStruct = new WasmStructure(wasmName, fields -> {
                this.addVirtualTableBaseFields((List<WasmField>)fields);
                this.addVirtualTableFields((List<WasmField>)fields, this.virtualTables.lookup("java.lang.Object"));
                if (this.metadataRequirements.hasArrayLength()) {
                    this.arrayLengthOffset = fields.size();
                    WasmFunctionType arrayLengthType = this.getArrayLengthType();
                    fields.add(new WasmField(arrayLengthType.getReference().asStorage(), this.names.structureField("@arrayLength")));
                }
                if (this.metadataRequirements.hasArrayGet()) {
                    this.arrayGetOffset = fields.size();
                    WasmFunctionType arrayGetType = this.getArrayGetType();
                    fields.add(new WasmField(arrayGetType.getReference().asStorage(), this.names.structureField("@arrayGet")));
                }
                if (this.metadataRequirements.hasArraySet()) {
                    this.arraySetOffset = fields.size();
                    WasmFunctionType arraySetType = this.getArraySetType();
                    fields.add(new WasmField(arraySetType.getReference().asStorage(), this.names.structureField("@arraySet")));
                }
                if (this.metadataRequirements.hasArrayCopy()) {
                    this.arrayCopyOffset = fields.size();
                    WasmFunctionType arrayCopyType = this.getArrayCopyType();
                    fields.add(new WasmField(arrayCopyType.getReference().asStorage(), this.names.structureField("@arrayCopy")));
                }
            });
            this.arrayVirtualTableStruct.setSupertype(this.standardClasses.objectClass().getVirtualTableStructure());
            this.module.types.add(this.arrayVirtualTableStruct);
            this.nonInitializedStructures.add(this.arrayVirtualTableStruct);
        }
        return this.arrayVirtualTableStruct;
    }

    @Override
    public int getArrayLengthOffset() {
        this.initStructures();
        return this.arrayLengthOffset;
    }

    @Override
    public int getArrayGetOffset() {
        this.initStructures();
        return this.arrayGetOffset;
    }

    @Override
    public int getArraySetOffset() {
        this.initStructures();
        return this.arraySetOffset;
    }

    @Override
    public int getArrayCopyOffset() {
        this.initStructures();
        return this.arrayCopyOffset;
    }

    @Override
    public int getEnumConstantsFunctionOffset() {
        return this.enumConstantsFunctionOffset;
    }

    private void initArrayClass(WasmGCClassInfo classInfo, ValueType.Array type) {
        if (!(type.getItemType() instanceof ValueType.Primitive)) {
            return;
        }
        classInfo.initializer = target -> {
            WasmGCClassInfo itemTypeInfo = this.getClassInfo(type.getItemType());
            target.add(new WasmCall(this.getFillArrayClassFunction(), new WasmGetGlobal(classInfo.pointer), new WasmGetGlobal(itemTypeInfo.pointer)));
            if (!this.compactMode) {
                this.fillArrayVirtualTableMethods(classInfo.getValueType(), (List<WasmExpression>)target, classInfo.virtualTablePointer, classInfo.pointer, classInfo.structure);
            } else {
                this.assignVTToClass(classInfo, (List<WasmExpression>)target);
            }
            ClassMetadataRequirements.Info metadataReq = this.metadataRequirements.getInfo(type);
            if (metadataReq.cloneMethod()) {
                WasmFunction cloneFunction = this.generateArrayCloneMethod(classInfo.structure, type.getItemType());
                cloneFunction.setReferenced(true);
                target.add(this.setClassField(classInfo, this.cloneOffset, new WasmFunctionReference(cloneFunction)));
            }
            if (metadataReq.name() && type.getItemType() instanceof ValueType.Primitive) {
                WasmGCStringConstant name = this.strings.getStringConstant(type.toString());
                target.add(this.setClassField(classInfo, this.classNameOffset, new WasmGetGlobal(name.global)));
            }
        };
    }

    private WasmExpression fillPrimitiveClass(WasmGlobal global, String name, int kind) {
        WasmCall call = new WasmCall(this.getCreatePrimitiveClassFunction());
        call.getArguments().add(new WasmGetGlobal(global));
        if (this.metadataRequirements.hasName()) {
            call.getArguments().add(name != null ? new WasmGetGlobal(this.strings.getStringConstant((String)name).global) : new WasmNullConstant(this.standardClasses.stringClass().getType()));
        }
        call.getArguments().add(new WasmInt32Constant(kind));
        return call;
    }

    @Override
    public int getFieldIndex(FieldReference fieldRef) {
        WasmGCClassInfo classInfo = this.getClassInfo(fieldRef.getClassName());
        if (classInfo.isHeapStructure()) {
            throw new IllegalArgumentException("Given field belongs to heap structure");
        }
        classInfo.structure.init();
        return this.fieldIndexes.getOrDefault(fieldRef, -1);
    }

    @Override
    public int getHeapFieldOffset(FieldReference fieldRef) {
        WasmGCClassInfo classInfo = this.getClassInfo(fieldRef.getClassName());
        if (!classInfo.isHeapStructure()) {
            throw new IllegalArgumentException("Given field does not belong to heap structure");
        }
        if (classInfo.heapFieldOffsets == null) {
            this.fillHeapFieldOffsets(classInfo);
        }
        return classInfo.heapFieldOffsets.get(fieldRef.getFieldName());
    }

    @Override
    public int getHeapSize(String className) {
        WasmGCClassInfo classInfo = this.getClassInfo(className);
        if (!classInfo.isHeapStructure()) {
            throw new IllegalArgumentException("Given field does not belong to heap structure");
        }
        if (classInfo.heapFieldOffsets == null) {
            this.fillHeapFieldOffsets(classInfo);
        }
        return classInfo.heapSize;
    }

    @Override
    public int getHeapAlignment(String className) {
        WasmGCClassInfo classInfo = this.getClassInfo(className);
        if (!classInfo.isHeapStructure()) {
            throw new IllegalArgumentException("Given field does not belong to heap structure");
        }
        if (classInfo.heapFieldOffsets == null) {
            this.fillHeapFieldOffsets(classInfo);
        }
        return classInfo.heapAlignment;
    }

    @Override
    public WasmGCReflectionProvider reflection() {
        return this.reflectionGenerator;
    }

    private void fillHeapFieldOffsets(WasmGCClassInfo classInfo) {
        ObjectIntHashMap<String> offsets = new ObjectIntHashMap<String>();
        classInfo.heapFieldOffsets = offsets;
        String className = ((ValueType.Object)classInfo.getValueType()).getClassName();
        int offset = 0;
        int alignment = 1;
        if (!className.equals(Structure.class.getName())) {
            ClassReader cls = this.classSource.get(className);
            WasmGCClassInfo parentInfo = this.getClassInfo(cls.getParent());
            if (parentInfo.heapFieldOffsets == null) {
                this.fillHeapFieldOffsets(parentInfo);
            }
            offset = parentInfo.heapSize;
            for (FieldReader fieldReader : cls.getFields()) {
                if (fieldReader.hasModifier(ElementModifier.STATIC)) continue;
                int size = WasmClassGenerator.getTypeSize(fieldReader.getType());
                if (offset == 0) {
                    alignment = size;
                }
                offset = WasmClassGenerator.align(offset, size);
                offsets.put(fieldReader.getName(), offset);
                offset += size;
            }
        }
        classInfo.heapSize = offset;
        classInfo.heapAlignment = alignment;
    }

    @Override
    public WasmGlobal getStaticFieldLocation(FieldReference fieldRef) {
        return this.staticFieldLocations.computeIfAbsent(fieldRef, this::generateStaticFieldLocation);
    }

    private WasmGlobal generateStaticFieldLocation(FieldReference fieldRef) {
        FieldReader field;
        ValueType javaType = null;
        Object initValue = null;
        ClassReader cls = this.classSource.get(fieldRef.getClassName());
        if (cls != null && (field = cls.getField(fieldRef.getFieldName())) != null) {
            javaType = field.getType();
            initValue = field.getInitialValue();
        }
        if (javaType == null) {
            javaType = ValueType.object("java.lang.Object");
        }
        WasmType type = this.typeMapper.mapType(javaType);
        WasmExpression wasmInitialValue = initValue != null ? this.initialValue(initValue) : WasmExpression.defaultValueOfType(type);
        String wasmName = this.names.topLevel(this.names.suggestForStaticField(fieldRef));
        WasmGlobal global = new WasmGlobal(wasmName, type, wasmInitialValue);
        this.dynamicInitialValue(global, initValue);
        this.module.globals.add(global);
        return global;
    }

    private WasmExpression initialValue(Object value) {
        if (value instanceof Boolean) {
            return new WasmInt32Constant((Boolean)value != false ? 1 : 0);
        }
        if (value instanceof Byte) {
            return new WasmInt32Constant(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new WasmInt32Constant(((Short)value).shortValue());
        }
        if (value instanceof Character) {
            return new WasmInt32Constant(((Character)value).charValue());
        }
        if (value instanceof Integer) {
            return new WasmInt32Constant((Integer)value);
        }
        if (value instanceof Long) {
            return new WasmInt64Constant((Long)value);
        }
        if (value instanceof Float) {
            return new WasmFloat32Constant(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new WasmFloat64Constant((Double)value);
        }
        return new WasmNullConstant(this.standardClasses.stringClass().getType());
    }

    private void dynamicInitialValue(WasmGlobal global, Object value) {
        if (value instanceof String) {
            WasmGlobal constant = this.strings.getStringConstant((String)((String)value)).global;
            this.staticFieldInitializers.add(function -> function.getBody().add(new WasmSetGlobal(global, new WasmGetGlobal(constant))));
        } else if (value instanceof ValueType) {
            WasmGlobal constant = this.getClassInfo((ValueType)((ValueType)value)).pointer;
            this.staticFieldInitializers.add(function -> function.getBody().add(new WasmSetGlobal(global, new WasmGetGlobal(constant))));
        }
    }

    private void fillFields(WasmGCClassInfo classInfo, List<WasmField> fields, ValueType type) {
        this.addSystemFields(fields);
        if (type instanceof ValueType.Object) {
            this.fillClassFields(fields, ((ValueType.Object)type).getClassName());
        } else if (type instanceof ValueType.Array) {
            this.fillArrayFields(classInfo, ((ValueType.Array)type).getItemType());
        }
    }

    private void fillClassFields(List<WasmField> fields, String className) {
        ClassReader classReader = this.classSource.get(className);
        if (classReader == null || classReader.hasModifier(ElementModifier.INTERFACE)) {
            this.fillSimpleClassFields(fields, "java.lang.Object");
        } else {
            this.fillSimpleClassFields(fields, className);
        }
    }

    private void fillSimpleClassFields(List<WasmField> fields, String className) {
        Object field;
        ClassReader classReader = this.classSource.get(className);
        if (classReader.getParent() != null) {
            this.fillClassFields(fields, classReader.getParent());
        }
        if (className.equals("java.lang.ref.WeakReference")) {
            field = new WasmField(WasmType.Reference.EXTERN.asStorage(), "nativeRef");
            fields.add((WasmField)field);
        } else {
            for (FieldReader fieldReader : classReader.getFields()) {
                if (className.equals("java.lang.Object") && fieldReader.getName().equals("monitor") || className.equals("java.lang.Class") && fieldReader.getName().equals("platformClass") || fieldReader.hasModifier(ElementModifier.STATIC)) continue;
                this.fieldIndexes.putIfAbsent(fieldReader.getReference(), fields.size());
                WasmField wasmField = new WasmField(this.typeMapper.mapStorageType(fieldReader.getType()), this.names.forMemberField(fieldReader.getReference()));
                fields.add(wasmField);
            }
        }
        if (className.equals(StringInternPool.class.getName() + "$Entry")) {
            field = new WasmField(WasmType.Reference.EXTERN.asStorage(), "nativeRef");
            fields.add((WasmField)field);
        }
        if (className.equals("java.lang.Throwable")) {
            this.throwableNativeOffset = fields.size();
            field = new WasmField(WasmType.Reference.EXTERN.asStorage(), "nativeRef");
            fields.add((WasmField)field);
        }
        if (className.equals("java.lang.Class")) {
            ClassReader cls = this.classSource.get("java.lang.Class");
            this.classFlagsOffset = fields.size();
            fields.add(this.createClassField(WasmType.INT32.asStorage(), "flags"));
            this.classTagOffset = fields.size();
            fields.add(this.createClassField(WasmType.INT32.asStorage(), "id"));
            this.classVtOffset = fields.size();
            fields.add(this.createClassField(this.standardClasses.objectClass().getVirtualTableStructure().getReference().asStorage(), "classVt"));
            if (this.metadataRequirements.hasSuperclass()) {
                this.classParentOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.classClass().getType().asStorage(), "parent"));
            }
            this.classArrayItemOffset = fields.size();
            fields.add(this.createClassField(this.standardClasses.classClass().getType().asStorage(), "arrayItem"));
            this.classArrayOffset = fields.size();
            fields.add(this.createClassField(this.standardClasses.classClass().getType().asStorage(), "array"));
            if (this.metadataRequirements.hasIsAssignable()) {
                this.classSupertypeFunctionOffset = fields.size();
                fields.add(this.createClassField(this.supertypeGenerator.getFunctionType().getReference().asStorage(), "isSupertype"));
            }
            this.classNewArrayOffset = fields.size();
            fields.add(this.createClassField(this.newArrayGenerator.getNewArrayFunctionType().getReference().asStorage(), "createArrayInstance"));
            if (this.metadataRequirements.hasEnclosingClass()) {
                this.classEnclosingClassOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.classClass().getType().asStorage(), "enclosingClass"));
            }
            if (this.metadataRequirements.hasDeclaringClass()) {
                this.classDeclaringClassOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.classClass().getType().asStorage(), "declaringClass"));
            }
            if (this.metadataRequirements.hasName()) {
                this.classNameOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.stringClass().getType().asStorage(), "name"));
            }
            if (this.metadataRequirements.hasSimpleName()) {
                this.classSimpleNameOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.stringClass().getType().asStorage(), "simpleName"));
            }
            if (cls != null && cls.getMethod(new MethodDescriptor("getCanonicalName", String.class)) != null) {
                this.classCanonicalNameOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.stringClass().getType().asStorage(), "canonicalName"));
            }
            this.cloneOffset = fields.size();
            fields.add(this.createClassField(this.functionTypes.of(this.standardClasses.objectClass().getType(), this.standardClasses.objectClass().getType()).getReference().asStorage(), "clone"));
            if (this.hasLoadServices) {
                this.servicesOffset = fields.size();
                WasmFunctionType wasmFunctionType = this.functionTypes.of(this.getClassInfo(ValueType.parse(Object[].class)).getType(), new WasmType[0]);
                fields.add(this.createClassField(wasmFunctionType.getReference().asStorage(), "services"));
            }
            if (this.metadataRequirements.hasEnumConstants()) {
                this.enumConstantsFunctionOffset = fields.size();
                WasmType.CompositeReference compositeReference = this.getClassInfo(ValueType.arrayOf(ValueType.object("java.lang.Enum"))).getType();
                WasmFunctionType enumConstantsType = this.functionTypes.of(compositeReference, new WasmType[0]);
                fields.add(this.createClassField(enumConstantsType.getReference().asStorage(), "getEnumConstants"));
            }
            if (this.metadataRequirements.hasGetAnnotations()) {
                this.classAnnotationsOffset = fields.size();
                WasmArray wasmArray = this.getObjectArrayType();
                fields.add(this.createClassField(wasmArray.getReference().asStorage(), "annotations"));
            }
            if (this.metadataRequirements.hasGetInterfaces()) {
                this.classInterfacesOffset = fields.size();
                WasmArray wasmArray = this.getObjectArrayType();
                fields.add(this.createClassField(wasmArray.getReference().asStorage(), "interfaces"));
            }
            if (this.metadataRequirements.hasGetFields()) {
                this.classFieldsOffset = fields.size();
                WasmArray wasmArray = this.reflection().getReflectionFieldArrayType();
                fields.add(this.createClassField(wasmArray.getReference().asStorage(), "fields"));
            }
            if (this.metadataRequirements.hasGetMethods()) {
                this.classMethodsOffset = fields.size();
                WasmArray wasmArray = this.reflection().getReflectionMethodArrayType();
                fields.add(this.createClassField(wasmArray.getReference().asStorage(), "methods"));
            }
            if (this.metadataRequirements.hasNewInstance()) {
                this.classInstantiatorOffset = fields.size();
                WasmType.CompositeReference compositeReference = this.functionTypes.of(this.standardClasses.objectClass().getType(), new WasmType[0]).getReference();
                fields.add(this.createClassField(compositeReference.asStorage(), "instantiator"));
            }
            if (this.metadataRequirements.hasClassInit()) {
                this.classInitializerOffset = fields.size();
                WasmType.CompositeReference compositeReference = this.functionTypes.of(null, new WasmType[0]).getReference();
                fields.add(this.createClassField(compositeReference.asStorage(), "initializer"));
            }
            this.previousRegularClassOffset = fields.size();
            fields.add(this.createClassField(this.standardClasses.classClass().getType().asStorage(), "previous"));
            this.lastRegularClassGlobal = new WasmGlobal(this.names.topLevel("teavm.lastRegularClass"), this.standardClasses.classClass().getType(), new WasmNullConstant(this.standardClasses.classClass().getType()));
            this.module.globals.add(this.lastRegularClassGlobal);
        }
    }

    private WasmField createClassField(WasmStorageType type, String name) {
        return new WasmField(type, this.names.forMemberField(new FieldReference("java.lang.Class", name)));
    }

    private void fillArrayFields(WasmGCClassInfo classInfo, ValueType elementType) {
        WasmArray wasmArray;
        if (elementType instanceof ValueType.Primitive) {
            WasmStorageType wasmElementType;
            switch (((ValueType.Primitive)elementType).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    wasmElementType = WasmStorageType.INT8;
                    break;
                }
                case SHORT: 
                case CHARACTER: {
                    wasmElementType = WasmStorageType.INT16;
                    break;
                }
                case INTEGER: {
                    wasmElementType = WasmType.INT32.asStorage();
                    break;
                }
                case LONG: {
                    wasmElementType = WasmType.INT64.asStorage();
                    break;
                }
                case FLOAT: {
                    wasmElementType = WasmType.FLOAT32.asStorage();
                    break;
                }
                case DOUBLE: {
                    wasmElementType = WasmType.FLOAT64.asStorage();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            String wasmArrayName = this.names.topLevel(this.names.suggestForType(classInfo.getValueType()) + "$Data");
            wasmArray = new WasmArray(wasmArrayName, wasmElementType);
            this.module.types.add(wasmArray);
        } else {
            wasmArray = this.getObjectArrayType();
        }
        classInfo.structure.getFields().add(new WasmField(wasmArray.getNonNullReference().asStorage(), this.arrayDataFieldName()));
    }

    @Override
    public WasmArray getObjectArrayType() {
        WasmArray wasmArray = this.objectArrayType;
        if (wasmArray == null) {
            WasmStorageType.Regular wasmElementType = this.standardClasses.objectClass().getType().asStorage();
            String wasmArrayName = this.names.topLevel(this.names.suggestForType(ValueType.arrayOf(ValueType.object("java.lang.Object"))) + "$Data");
            wasmArray = new WasmArray(wasmArrayName, wasmElementType);
            this.module.types.add(wasmArray);
            this.objectArrayType = wasmArray;
        }
        return wasmArray;
    }

    private String arrayDataFieldName() {
        if (this.arrayDataFieldName == null) {
            this.arrayDataFieldName = this.names.structureField("@data");
        }
        return this.arrayDataFieldName;
    }

    private WasmFunction getCreatePrimitiveClassFunction() {
        if (this.createPrimitiveClassFunction == null) {
            this.createPrimitiveClassFunction = this.createCreatePrimitiveClassFunction();
        }
        return this.createPrimitiveClassFunction;
    }

    private WasmFunction createCreatePrimitiveClassFunction() {
        WasmLocal nameVar;
        ArrayList<WasmType> params = new ArrayList<WasmType>();
        params.add(this.standardClasses.classClass().getType());
        if (this.metadataRequirements.hasName()) {
            params.add(this.standardClasses.stringClass().getType());
        }
        params.add(WasmType.INT32);
        WasmFunctionType functionType = this.functionTypes.of(null, params.toArray(new WasmType[0]));
        WasmFunction function = new WasmFunction(functionType);
        function.setName(this.names.topLevel("teavm@fillPrimitiveClass"));
        this.module.functions.add(function);
        WasmLocal targetVar = new WasmLocal(this.standardClasses.classClass().getType(), "target");
        function.add(targetVar);
        if (this.metadataRequirements.hasName()) {
            nameVar = new WasmLocal(this.standardClasses.stringClass().getType(), "name");
            function.add(nameVar);
        } else {
            nameVar = null;
        }
        WasmLocal kindVar = new WasmLocal(WasmType.INT32, "kind");
        function.add(kindVar);
        this.standardClasses.classClass().getStructure().init();
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), 0, new WasmGetGlobal(this.standardClasses.classClass().virtualTablePointer)));
        WasmIntBinary flagsExpr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, new WasmGetLocal(kindVar), new WasmInt32Constant(21));
        flagsExpr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.OR, flagsExpr, new WasmInt32Constant(262160));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classFlagsOffset, flagsExpr));
        if (nameVar != null) {
            function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classNameOffset, new WasmGetLocal(nameVar)));
        }
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classTagOffset, new WasmInt32Constant(Integer.MAX_VALUE)));
        return function;
    }

    private WasmFunction getFillRegularClassFunction() {
        if (this.fillRegularClassFunction == null) {
            this.fillRegularClassFunction = this.createFillRegularClassFunction();
        }
        return this.fillRegularClassFunction;
    }

    private WasmFunction createFillRegularClassFunction() {
        WasmFunctionType functionType = this.functionTypes.of(null, this.standardClasses.classClass().getType(), WasmType.INT32, WasmType.INT32);
        WasmFunction function = new WasmFunction(functionType);
        this.module.functions.add(function);
        function.setName(this.names.topLevel("teavm@fillRegularClass"));
        WasmLocal targetVar = new WasmLocal(this.standardClasses.classClass().getType(), "target");
        WasmLocal idVar = new WasmLocal(this.standardClasses.classClass().getType(), "id");
        WasmLocal flagsVar = new WasmLocal(this.standardClasses.classClass().getType(), "flags");
        function.add(targetVar);
        function.add(idVar);
        function.add(flagsVar);
        this.standardClasses.classClass().getStructure().init();
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), 0, new WasmGetGlobal(this.standardClasses.classClass().virtualTablePointer)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classTagOffset, new WasmGetLocal(idVar)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classFlagsOffset, new WasmGetLocal(flagsVar)));
        WasmFunction newArrayFunction = this.newArrayGenerator.getNewObjectArrayFunction();
        newArrayFunction.setReferenced(true);
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classNewArrayOffset, new WasmFunctionReference(newArrayFunction)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.previousRegularClassOffset, new WasmGetGlobal(this.lastRegularClassGlobal)));
        function.getBody().add(new WasmSetGlobal(this.lastRegularClassGlobal, new WasmGetLocal(targetVar)));
        return function;
    }

    @Override
    public WasmFunction getGetArrayClassFunction() {
        if (this.getArrayClassFunction == null) {
            this.getArrayClassFunction = this.createGetArrayClassFunction();
        }
        return this.getArrayClassFunction;
    }

    private WasmFunction createGetArrayClassFunction() {
        WasmGCClassInfo classClass = this.standardClasses.classClass();
        WasmFunctionType functionType = this.functionTypes.of(classClass.getStructure().getNonNullReference(), classClass.getType());
        WasmFunction function = new WasmFunction(functionType);
        WasmGCClassInfo arrayType = this.getClassInfo(ValueType.arrayOf(ValueType.object("java.lang.Object")));
        this.module.functions.add(function);
        function.setName(this.names.topLevel("teavm@getArrayClass"));
        this.queue.add(() -> {
            WasmLocal itemTypeVar = new WasmLocal(classClass.getType(), "itemType");
            WasmLocal resultVar = new WasmLocal(classClass.getStructure().getNonNullReference(), "result");
            WasmLocal vtVar = new WasmLocal(this.getArrayVirtualTableStructure().getNonNullReference(), "vt");
            function.add(itemTypeVar);
            function.add(resultVar);
            function.add(vtVar);
            List<WasmExpression> body = function.getBody();
            WasmStructGet existing = new WasmStructGet(classClass.structure, new WasmGetLocal(itemTypeVar), this.classArrayOffset);
            WasmBlock block = new WasmBlock(false);
            block.getBody().add(new WasmReturn(new WasmNullBranch(WasmNullCondition.NULL, existing, block)));
            body.add(block);
            body.add(new WasmSetLocal(resultVar, new WasmStructNewDefault(classClass.structure)));
            body.add(new WasmStructSet(classClass.structure, new WasmGetLocal(itemTypeVar), this.classArrayOffset, new WasmGetLocal(resultVar)));
            body.add(new WasmCall(this.getFillArrayClassFunction(), new WasmGetLocal(resultVar), new WasmGetLocal(itemTypeVar)));
            WasmFunction supertypeFunction = this.supertypeGenerator.getIsArraySupertypeFunction();
            supertypeFunction.setReferenced(true);
            body.add(new WasmStructSet(classClass.structure, new WasmGetLocal(resultVar), this.classSupertypeFunctionOffset, new WasmFunctionReference(supertypeFunction)));
            WasmFunction cloneFunction = this.generateArrayCloneMethod(arrayType.structure, ValueType.object("java.lang.Object"));
            cloneFunction.setReferenced(true);
            body.add(new WasmStructSet(classClass.structure, new WasmGetLocal(resultVar), this.cloneOffset, new WasmFunctionReference(cloneFunction)));
            body.add(new WasmSetLocal(vtVar, new WasmStructNewDefault(this.getArrayVirtualTableStructure())));
            this.fillArrayVirtualTableMethods(body, vtVar, resultVar);
            body.add(new WasmGetLocal(resultVar));
        });
        return function;
    }

    private void fillArrayVirtualTableMethods(List<WasmExpression> target, WasmLocal vt, WasmLocal cls) {
        WasmStructure structure = this.getArrayVirtualTableStructure();
        structure.init();
        target.add(new WasmCall(this.systemFunctions.getFillObjectVirtualTableFunction(), new WasmGetLocal(vt), new WasmGetLocal(cls)));
        if (this.arrayLengthOffset >= 0) {
            WasmGCClassInfo arrayClass = this.getClassInfo(ValueType.arrayOf(ValueType.object("java.lang.Object")));
            WasmFunction lengthFunction = this.getArrayLengthFunction(arrayClass.structure);
            target.add(new WasmStructSet(structure, new WasmGetLocal(vt), this.arrayLengthOffset, new WasmFunctionReference(lengthFunction)));
        }
        if (this.arrayGetOffset >= 0) {
            WasmFunction getFunction = this.getArrayGetObjectFunction();
            target.add(new WasmStructSet(structure, new WasmGetLocal(vt), this.arrayGetOffset, new WasmFunctionReference(getFunction)));
        }
        if (this.arraySetOffset >= 0) {
            WasmFunction setFunction = this.getArraySetObjectFunction();
            target.add(new WasmStructSet(structure, new WasmGetLocal(vt), this.arraySetOffset, new WasmFunctionReference(setFunction)));
        }
        if (this.arrayCopyOffset >= 0) {
            WasmFunction copyFunction = this.getArrayCopyObjectFunction();
            target.add(new WasmStructSet(structure, new WasmGetLocal(vt), this.arrayCopyOffset, new WasmFunctionReference(copyFunction)));
        }
    }

    private WasmFunction getFillArrayClassFunction() {
        if (this.fillArrayClassFunction == null) {
            this.fillArrayClassFunction = this.createFillArrayClassFunction();
        }
        return this.fillArrayClassFunction;
    }

    private WasmFunction createFillArrayClassFunction() {
        WasmFunctionType functionType = this.functionTypes.of(null, this.standardClasses.classClass().getType(), this.standardClasses.classClass().getType());
        WasmFunction function = new WasmFunction(functionType);
        this.module.functions.add(function);
        function.setName(this.names.topLevel("teavm@fillArrayClass"));
        WasmLocal targetVar = new WasmLocal(this.standardClasses.classClass().getType(), "target");
        WasmLocal itemVar = new WasmLocal(this.standardClasses.classClass().getType(), "item");
        function.add(targetVar);
        function.add(itemVar);
        this.standardClasses.classClass().getStructure().init();
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), 0, new WasmGetGlobal(this.standardClasses.classClass().getVirtualTablePointer())));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classFlagsOffset, new WasmInt32Constant(17)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classArrayItemOffset, new WasmGetLocal(itemVar)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(itemVar), this.classArrayOffset, new WasmGetLocal(targetVar)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classTagOffset, new WasmInt32Constant(0)));
        if (this.classParentOffset >= 0) {
            function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classParentOffset, new WasmGetGlobal(this.standardClasses.objectClass().pointer)));
        }
        WasmFunction newArrayFunction = this.newArrayGenerator.getNewObjectArrayFunction();
        newArrayFunction.setReferenced(true);
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classNewArrayOffset, new WasmFunctionReference(newArrayFunction)));
        return function;
    }

    private WasmFunction createEnumConstantsFunction(WasmGCClassInfo classInfo, ClassReader cls) {
        WasmStructure enumArrayStruct = this.getClassInfo((ValueType)ValueType.parse(Enum[].class)).structure;
        WasmFunction function = new WasmFunction(this.functionTypes.of(enumArrayStruct.getReference(), new WasmType[0]));
        function.setName(this.names.topLevel(cls.getName() + "@constants"));
        this.module.functions.add(function);
        function.setReferenced(true);
        List fields = cls.getFields().stream().filter(field -> field.hasModifier(ElementModifier.ENUM)).filter(field -> field.hasModifier(ElementModifier.STATIC)).map(field -> new WasmGetGlobal(this.getStaticFieldLocation(field.getReference()))).collect(Collectors.toList());
        if (classInfo.getInitializerPointer() != null) {
            function.getBody().add(new WasmCallReference(new WasmGetGlobal(classInfo.getInitializerPointer()), this.functionTypes.of(null, new WasmType[0])));
        }
        WasmGCGenerationUtil util = new WasmGCGenerationUtil(this);
        function.getBody().add(util.allocateArrayWithElements(ValueType.parse(Enum.class), () -> fields));
        return function;
    }

    private WasmExpression setClassField(WasmGCClassInfo classInfo, int fieldIndex, WasmExpression value) {
        return new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetGlobal(classInfo.pointer), fieldIndex, value);
    }
}

