/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.HashMap;
import java.util.Map;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.binary.DataArray;
import org.teavm.backend.wasm.binary.DataPrimitives;
import org.teavm.backend.wasm.binary.DataStructure;
import org.teavm.backend.wasm.binary.DataValue;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.render.WasmBinaryStatsCollector;
import org.teavm.model.ValueType;

public class WasmStringPool {
    private WasmClassGenerator classGenerator;
    private BinaryWriter binaryWriter;
    private Map<String, Integer> stringMap = new HashMap<String, Integer>();
    private DataStructure arrayHeaderType = new DataStructure(0, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.INT);
    private DataStructure stringType = new DataStructure(0, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.INT);
    private WasmBinaryStatsCollector statsCollector;

    public WasmStringPool(WasmClassGenerator classGenerator, BinaryWriter binaryWriter, WasmBinaryStatsCollector statsCollector) {
        this.classGenerator = classGenerator;
        this.binaryWriter = binaryWriter;
        this.statsCollector = statsCollector;
    }

    public int getStringPointer(String value) {
        Integer pointer = this.stringMap.get(value);
        if (pointer == null) {
            pointer = this.generateStringPointer(value);
            this.stringMap.put(value, pointer);
        }
        return pointer;
    }

    private int generateStringPointer(String value) {
        int start = this.binaryWriter.getAddress();
        DataArray charactersType = new DataArray(DataPrimitives.SHORT, value.length());
        DataStructure wrapperType = new DataStructure(0, this.arrayHeaderType, charactersType);
        DataValue wrapper = wrapperType.createValue();
        DataValue header = wrapper.getValue(0);
        DataValue characters = wrapper.getValue(1);
        int classPointer = this.classGenerator.getClassPointer(ValueType.arrayOf(ValueType.CHARACTER));
        header.setInt(0, classPointer >>> 3 | Integer.MIN_VALUE);
        header.setInt(2, value.length());
        for (int i = 0; i < value.length(); ++i) {
            characters.setShort(i, (short)value.charAt(i));
        }
        DataValue stringObject = this.stringType.createValue();
        int stringPointer = this.binaryWriter.append(stringObject);
        classPointer = this.classGenerator.getClassPointer(ValueType.object(String.class.getName()));
        stringObject.setInt(0, classPointer >>> 3 | Integer.MIN_VALUE);
        stringObject.setAddress(2, this.binaryWriter.append(wrapper));
        int size = this.binaryWriter.getAddress() - start;
        this.statsCollector.addStringsSize(size);
        return stringPointer;
    }
}

