/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.function.Predicate;
import org.teavm.ast.RegularMethodNode;
import org.teavm.ast.VariableNode;
import org.teavm.ast.decompilation.Decompiler;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.WasmGenerationContext;
import org.teavm.backend.wasm.generate.WasmGenerationVisitor;
import org.teavm.backend.wasm.generate.WasmGeneratorUtil;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.interop.Export;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.util.VariableType;

public class WasmGenerator {
    private Decompiler decompiler;
    private ClassHolderSource classSource;
    private WasmGenerationContext context;
    private WasmClassGenerator classGenerator;
    private BinaryWriter binaryWriter;
    private Predicate<MethodReference> asyncMethods;

    public WasmGenerator(Decompiler decompiler, ClassHolderSource classSource, WasmGenerationContext context, WasmClassGenerator classGenerator, BinaryWriter binaryWriter, Predicate<MethodReference> asyncMethods) {
        this.decompiler = decompiler;
        this.classSource = classSource;
        this.context = context;
        this.classGenerator = classGenerator;
        this.binaryWriter = binaryWriter;
        this.asyncMethods = asyncMethods;
    }

    public WasmFunction generate(MethodReference methodReference, MethodHolder bodyMethod) {
        int firstVariable;
        ClassHolder cls = this.classSource.get(methodReference.getClassName());
        MethodHolder method = cls.getMethod(methodReference.getDescriptor());
        RegularMethodNode methodAst = this.decompiler.decompileRegular(bodyMethod);
        WasmFunction function = this.context.functions().forMethod(method);
        for (int i = firstVariable = method.hasModifier(ElementModifier.STATIC) ? 1 : 0; i < methodAst.getVariables().size(); ++i) {
            VariableNode variable = methodAst.getVariables().get(i);
            WasmType.Number type = variable.getType() != null ? WasmGeneratorUtil.mapType(variable.getType()) : WasmType.INT32;
            WasmLocal local = new WasmLocal(type, variable.getName());
            local.setJavaType(this.mapType(variable.getType()));
            function.add(local);
        }
        WasmGenerationVisitor visitor = new WasmGenerationVisitor(this.context, this.classGenerator, this.binaryWriter, function, methodReference, firstVariable, this.asyncMethods.test(methodReference));
        visitor.generate(methodAst.getBody(), function.getBody());
        AnnotationHolder exportAnnot = method.getAnnotations().get(Export.class.getName());
        if (exportAnnot != null) {
            function.setExportName(exportAnnot.getValue("name").getString());
        }
        return function;
    }

    private org.teavm.backend.wasm.debug.info.VariableType mapType(VariableType type) {
        switch (type) {
            case INT: {
                return org.teavm.backend.wasm.debug.info.VariableType.INT;
            }
            case LONG: {
                return org.teavm.backend.wasm.debug.info.VariableType.LONG;
            }
            case FLOAT: {
                return org.teavm.backend.wasm.debug.info.VariableType.FLOAT;
            }
            case DOUBLE: {
                return org.teavm.backend.wasm.debug.info.VariableType.DOUBLE;
            }
        }
        return org.teavm.backend.wasm.debug.info.VariableType.OBJECT;
    }

    public WasmFunction generateNative(MethodReader method) {
        WasmFunction function = this.context.functions().forMethod(method);
        WasmGenerationContext.ImportedMethod importedMethod = this.context.getImportedMethod(method.getReference());
        if (importedMethod != null) {
            function.setImportName(importedMethod.name);
            function.setImportModule(importedMethod.module);
        } else {
            function.setImportName("<unknown>");
        }
        return function;
    }
}

