/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.List;
import org.teavm.backend.wasm.generate.CachedExpression;
import org.teavm.backend.wasm.generate.TemporaryVariablePool;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.model.TextLocation;

public class ExpressionCache {
    private TemporaryVariablePool tmpVars;

    public ExpressionCache(TemporaryVariablePool tmpVars) {
        this.tmpVars = tmpVars;
    }

    public CachedExpression create(WasmExpression expr, WasmType type, TextLocation location, List<WasmExpression> body) {
        if (expr instanceof WasmGetLocal) {
            WasmGetLocal getLocalExpr = (WasmGetLocal)expr;
            return new LocalVarCachedExpression(getLocalExpr.getLocal());
        }
        if (expr instanceof WasmInt32Constant) {
            WasmInt32Constant constExpr = (WasmInt32Constant)expr;
            return new Int32CachedExpression(constExpr.getValue());
        }
        WasmLocal tmpVar = this.tmpVars.acquire(type);
        WasmSetLocal storeExpr = new WasmSetLocal(tmpVar, expr);
        storeExpr.setLocation(location);
        body.add(storeExpr);
        return new TmpVarCachedExpression(tmpVar);
    }

    private static class LocalVarCachedExpression
    extends CachedExpression {
        private final WasmLocal localVar;

        LocalVarCachedExpression(WasmLocal localVar) {
            this.localVar = localVar;
        }

        @Override
        public WasmExpression expr() {
            return new WasmGetLocal(this.localVar);
        }
    }

    private static class Int32CachedExpression
    extends CachedExpression {
        private final int value;

        Int32CachedExpression(int value) {
            this.value = value;
        }

        @Override
        public WasmExpression expr() {
            return new WasmInt32Constant(this.value);
        }
    }

    private class TmpVarCachedExpression
    extends CachedExpression {
        private final WasmLocal tmpVar;

        TmpVarCachedExpression(WasmLocal tmpVar) {
            this.tmpVar = tmpVar;
        }

        @Override
        public WasmExpression expr() {
            return new WasmGetLocal(this.tmpVar);
        }

        @Override
        public void release() {
            ExpressionCache.this.tmpVars.release(this.tmpVar);
        }
    }
}

