/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teavm.backend.wasm.debug.info.DebugInfo;
import org.teavm.backend.wasm.debug.info.FunctionControlFlow;
import org.teavm.backend.wasm.debug.info.FunctionControlFlowIterator;
import org.teavm.backend.wasm.debug.info.InstructionLocation;
import org.teavm.backend.wasm.debug.info.LineInfoCommand;
import org.teavm.backend.wasm.debug.info.LineInfoCommandExecutor;
import org.teavm.backend.wasm.debug.info.LineInfoSequence;
import org.teavm.backend.wasm.debug.info.Location;
import org.teavm.common.CollectionUtil;
import org.teavm.hppc.IntArrayDeque;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntSet;

public class StepLocationsFinder {
    public final DebugInfo debugInfo;
    private LineInfoSequence lines;
    private FunctionControlFlow graph;
    private List<Point> points;
    private IntArrayDeque queue = new IntArrayDeque();
    private String currentFileName;
    private int currentLine;
    private boolean enterMethod;
    private IntSet breakpointAddresses = new IntHashSet();
    private IntSet callAddresses = new IntHashSet();
    private IntSet visited = new IntHashSet();

    public StepLocationsFinder(DebugInfo debugInfo) {
        this.debugInfo = debugInfo;
    }

    public boolean step(String fileName, int line, int address, boolean enterMethod) {
        this.updatePoints(address -= this.debugInfo.offset());
        if (this.points == null) {
            return false;
        }
        int index = CollectionUtil.binarySearch(this.points, address, p -> p.address);
        if (index < 0) {
            index = -index - 2;
        }
        if (index < 0) {
            return false;
        }
        this.enterMethod = enterMethod;
        this.currentFileName = fileName;
        this.currentLine = line;
        this.queue.addLast(index);
        this.callAddresses.clear();
        this.breakpointAddresses.clear();
        while (!this.queue.isEmpty()) {
            this.processTask();
        }
        this.visited.clear();
        this.currentFileName = null;
        return true;
    }

    public int[] getBreakpointAddresses() {
        return this.breakpointAddresses.toArray();
    }

    public int[] getCallAddresses() {
        return this.callAddresses.toArray();
    }

    private void updatePoints(int address) {
        LineInfoSequence lines = this.debugInfo.lines().find(address);
        FunctionControlFlow graph = this.debugInfo.controlFlow().find(address);
        if (lines == null || graph == null) {
            this.lines = null;
            this.graph = null;
            this.points = null;
            return;
        }
        if (lines != this.lines || graph != this.graph) {
            this.lines = lines;
            this.graph = graph;
            this.points = null;
        }
        if (this.points == null) {
            this.points = this.createPoints();
        }
    }

    private List<Point> createPoints() {
        ArrayList<Point> list = new ArrayList<Point>();
        int indexInLines = 0;
        FunctionControlFlowIterator graphIter = this.graph.iterator(0);
        LineInfoCommandExecutor commandExecutor = new LineInfoCommandExecutor();
        while (indexInLines < this.lines.commands().size() && graphIter.hasNext()) {
            Point point;
            boolean nextInGraph;
            if (graphIter == null) {
                nextInGraph = false;
            } else if (indexInLines >= this.lines.commands().size()) {
                nextInGraph = true;
            } else {
                boolean bl = nextInGraph = this.lines.commands().get(indexInLines).address() >= graphIter.address();
            }
            if (nextInGraph) {
                Point point2 = new Point(graphIter.address());
                list.add(point2);
                point2.isCall = graphIter.isCall();
                point2.next = graphIter.targets();
                graphIter.next();
                continue;
            }
            LineInfoCommand cmd = this.lines.commands().get(indexInLines++);
            cmd.acceptVisitor(commandExecutor);
            InstructionLocation location = commandExecutor.createLocation();
            if (location == null || location.location() == null) continue;
            if (!list.isEmpty() && list.get((int)(list.size() - 1)).address == cmd.address()) {
                point = list.get(list.size() - 1);
            } else {
                point = new Point(cmd.address());
                list.add(point);
            }
            point.location = location.location();
        }
        for (Point point2 : list) {
            int[] next = point2.next;
            if (next == null) continue;
            int j = 0;
            for (int i = 0; i < next.length; ++i) {
                int foundIndex = CollectionUtil.binarySearch(list, next[i], p -> p.address);
                if (foundIndex < 0) {
                    foundIndex = -foundIndex - 1;
                }
                if (foundIndex >= list.size()) continue;
                next[j++] = foundIndex;
            }
            if (j == next.length) continue;
            if (j == 0) {
                point2.next = null;
                continue;
            }
            point2.next = Arrays.copyOf(next, j);
        }
        list.trimToSize();
        return list;
    }

    private void processTask() {
        int index = this.queue.removeFirst();
        if (!this.visited.add(index)) {
            return;
        }
        Point point = this.points.get(index);
        if (point.location != null && !this.isCurrent(point.location)) {
            this.breakpointAddresses.add(point.address + this.debugInfo.offset());
            return;
        }
        if (this.enterMethod && point.isCall) {
            this.breakpointAddresses.add(point.address + this.debugInfo.offset());
            this.callAddresses.add(point.address + this.debugInfo.offset());
        }
        if (point.next != null) {
            for (int nextIndex : point.next) {
                this.queue.addLast(nextIndex);
            }
        } else if (index < this.points.size() - 1) {
            this.queue.addLast(index + 1);
        }
    }

    private boolean isCurrent(Location loc) {
        return loc.line() == this.currentLine && loc.file().fullName().equals(this.currentFileName);
    }

    private static class Point {
        int address;
        int[] next;
        boolean isCall;
        Location location;

        Point(int address) {
            this.address = address;
        }
    }
}

