/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug;

import java.util.Objects;
import org.teavm.backend.wasm.debug.DebugPackages;
import org.teavm.backend.wasm.debug.DebugSectionBuilder;
import org.teavm.backend.wasm.debug.DebugStrings;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;

public class DebugPackagesBuilder
extends DebugSectionBuilder
implements DebugPackages {
    private DebugStrings strings;
    private ObjectIntMap<PackageInfo> packages = new ObjectIntHashMap<PackageInfo>();

    public DebugPackagesBuilder(DebugStrings strings) {
        super("teavm_pkg");
        this.strings = strings;
    }

    @Override
    public int packagePtr(int basePackage, String name) {
        PackageInfo key = new PackageInfo(basePackage, name);
        int result = this.packages.getOrDefault(key, -1);
        if (result < 0) {
            result = this.packages.size() + 1;
            this.packages.put(key, result);
            this.blob.writeLEB(basePackage);
            this.blob.writeLEB(this.strings.stringPtr(name));
        }
        return result;
    }

    private static class PackageInfo {
        private int parent;
        private String name;

        PackageInfo(int parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackageInfo that = (PackageInfo)o;
            return this.parent == that.parent && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.name);
        }
    }
}

