/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.binary;

import org.teavm.backend.wasm.binary.DataType;
import org.teavm.backend.wasm.binary.DataValue;

public final class DataPrimitives {
    public static final DataType BYTE = new DataType(){

        @Override
        public DataValue createValue() {
            return new ByteDataValue();
        }
    };
    public static final DataType SHORT = new DataType(){

        @Override
        public DataValue createValue() {
            return new ShortDataValue();
        }
    };
    public static final DataType INT = new DataType(){

        @Override
        public DataValue createValue() {
            return new IntDataValue();
        }
    };
    public static final DataType LONG = new DataType(){

        @Override
        public DataValue createValue() {
            return new LongDataValue();
        }
    };
    public static final DataType ADDRESS = new DataType(){

        @Override
        public DataValue createValue() {
            return new AddressDataValue();
        }
    };
    public static final DataType FLOAT = new DataType(){

        @Override
        public DataValue createValue() {
            return new FloatDataValue();
        }
    };
    public static final DataType DOUBLE = new DataType(){

        @Override
        public DataValue createValue() {
            return new DoubleDataValue();
        }
    };

    private DataPrimitives() {
    }

    static class DoubleDataValue
    extends DataValue {
        double value;

        DoubleDataValue() {
            super(DOUBLE);
        }

        @Override
        public double getDouble(int index) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            return this.value;
        }

        @Override
        public void setDouble(int index, double value) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            this.value = value;
        }
    }

    static class FloatDataValue
    extends DataValue {
        float value;

        FloatDataValue() {
            super(FLOAT);
        }

        @Override
        public float getFloat(int index) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            return this.value;
        }

        @Override
        public void setFloat(int index, float value) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            this.value = value;
        }
    }

    static class AddressDataValue
    extends DataValue {
        long value;

        AddressDataValue() {
            super(ADDRESS);
        }

        @Override
        public long getAddress(int index) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            return this.value;
        }

        @Override
        public void setAddress(int index, long value) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            this.value = value;
        }
    }

    static class LongDataValue
    extends DataValue {
        long value;

        LongDataValue() {
            super(LONG);
        }

        @Override
        public long getLong(int index) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            return this.value;
        }

        @Override
        public void setLong(int index, long value) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            this.value = value;
        }
    }

    static class IntDataValue
    extends DataValue {
        int value;

        IntDataValue() {
            super(INT);
        }

        @Override
        public int getInt(int index) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            return this.value;
        }

        @Override
        public void setInt(int index, int value) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            this.value = value;
        }
    }

    static class ShortDataValue
    extends DataValue {
        short value;

        ShortDataValue() {
            super(SHORT);
        }

        @Override
        public short getShort(int index) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            return this.value;
        }

        @Override
        public void setShort(int index, short value) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            this.value = value;
        }
    }

    static class ByteDataValue
    extends DataValue {
        byte value;

        ByteDataValue() {
            super(BYTE);
        }

        @Override
        public byte getByte(int index) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            return this.value;
        }

        @Override
        public void setByte(int index, byte value) {
            if (index != 0) {
                throw new IllegalArgumentException("Index should be 0 for primitive values");
            }
            this.value = value;
        }
    }
}

