/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm;

import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.runtime.WasmSupport;
import org.teavm.interop.Address;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Unmanaged;

@StaticInit
@Unmanaged
public final class WasmHeap {
    public static final int PAGE_SIZE = 65536;
    public static final int DEFAULT_STACK_SIZE = 262144;
    public static final int DEFAULT_REGION_SIZE = 1024;
    public static final int DEFAULT_BUFFER_SIZE = 512;
    public static int minHeapSize;
    public static int maxHeapSize;
    public static Address storageAddress;
    public static int storageSize;
    public static Address regionsAddress;
    public static int regionsCount;
    public static int regionsSize;
    public static Address cardTable;
    public static Address heapAddress;
    public static int heapSize;
    public static int regionSize;
    public static Address memoryLimit;
    public static Address stackAddress;
    public static Address stack;
    public static int stackSize;
    public static Address buffer;
    public static int bufferSize;

    private WasmHeap() {
    }

    public static int calculateStorageSize(int heapSize) {
        return heapSize / 16;
    }

    public static int calculateRegionsCount(int heapSize, int regionSize) {
        return heapSize / regionSize + 1;
    }

    public static int calculateRegionsSize(int regionsCount) {
        return regionsCount * 2;
    }

    public static native void growMemory(int var0);

    private static void initHeapTrace(int maxHeap) {
        WasmSupport.initHeapTrace(maxHeap);
    }

    public static void initHeap(Address start, int minHeap, int maxHeap, int stackSize, int bufferSize) {
        WasmHeap.initHeapTrace(maxHeap);
        buffer = WasmRuntime.align(start, 16);
        WasmHeap.bufferSize = bufferSize;
        stackAddress = stack = WasmRuntime.align(buffer.add(bufferSize), 16);
        heapAddress = WasmRuntime.align(stackAddress.add(stackSize), 16);
        memoryLimit = WasmRuntime.align(start, 65536);
        minHeapSize = minHeap;
        maxHeapSize = maxHeap;
        WasmHeap.stackSize = stackSize;
        WasmHeap.resizeHeap(minHeap);
    }

    public static void resizeHeap(int newHeapSize) {
        if (newHeapSize <= heapSize) {
            return;
        }
        int newStorageSize = WasmHeap.calculateStorageSize(newHeapSize);
        int newRegionsCount = WasmHeap.calculateRegionsCount(newHeapSize, regionSize);
        int newRegionsSize = WasmHeap.calculateRegionsSize(newRegionsCount);
        Address newRegionsAddress = WasmRuntime.align(heapAddress.add(newHeapSize), 16);
        Address newCardTable = WasmRuntime.align(newRegionsAddress.add(newRegionsSize), 16);
        Address newStorageAddress = WasmRuntime.align(newCardTable.add(newRegionsCount), 16);
        Address newMemoryLimit = WasmRuntime.align(newStorageAddress.add(newStorageSize), 65536);
        if (newMemoryLimit != memoryLimit) {
            WasmHeap.growMemory((int)(newMemoryLimit.toLong() - memoryLimit.toLong()) / 65536);
            memoryLimit = newMemoryLimit;
        }
        if (storageSize > 0) {
            Address.moveMemoryBlock(storageAddress, newStorageAddress, storageSize);
        }
        if (regionsSize > 0) {
            Address.moveMemoryBlock(cardTable, newCardTable, regionsCount);
            Address.moveMemoryBlock(regionsAddress, newRegionsAddress, regionsSize);
        }
        storageAddress = newStorageAddress;
        regionsAddress = newRegionsAddress;
        cardTable = newCardTable;
        storageSize = newStorageSize;
        regionsCount = newRegionsCount;
        regionsSize = newRegionsSize;
        heapSize = newHeapSize;
    }

    static {
        regionSize = 1024;
    }
}

