/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm;

import org.teavm.backend.wasm.generate.gc.WasmGCDeclarationsGenerator;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.runtime.StringInternPool;
import org.teavm.interop.Address;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.runtime.heap.Heap;

public class WasmGCModuleGenerator {
    private WasmGCDeclarationsGenerator declarationsGenerator;
    private WasmFunction initializer;

    public WasmGCModuleGenerator(WasmGCDeclarationsGenerator declarationsGenerator) {
        this.declarationsGenerator = declarationsGenerator;
    }

    public void generate() {
        this.declarationsGenerator.generate();
        this.createInitializer();
    }

    public void initBuffersHeap(int offset, int minSize, int maxSize) {
        WasmFunction target = this.declarationsGenerator.functions().forStaticMethod(new MethodReference(Heap.class, "init", Address.class, Integer.TYPE, Integer.TYPE, Void.TYPE));
        WasmCall call = new WasmCall(target, new WasmInt32Constant(offset), new WasmInt32Constant(minSize), new WasmInt32Constant(maxSize));
        this.initializer.getBody().add(call);
    }

    public WasmFunction generateReportGarbageCollectedStringFunction() {
        ValueType.Object entryType = ValueType.object(StringInternPool.class.getName() + "$Entry");
        return this.declarationsGenerator.functions().forStaticMethod(new MethodReference(StringInternPool.class.getName(), "remove", entryType, ValueType.VOID));
    }

    private void createInitializer() {
        WasmFunctionType functionType = this.declarationsGenerator.functionTypes.of(null, new WasmType[0]);
        this.initializer = new WasmFunction(functionType);
        this.initializer.setName("teavm@initializer");
        this.declarationsGenerator.module.functions.add(this.initializer);
        this.declarationsGenerator.module.setStartFunction(this.initializer);
        this.declarationsGenerator.contributeToInitializer(this.initializer);
    }
}

