/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling;

import java.util.Collection;
import java.util.Iterator;
import org.teavm.callgraph.CallGraph;
import org.teavm.callgraph.CallGraphNode;
import org.teavm.callgraph.CallSite;
import org.teavm.diagnostics.DefaultProblemTextConsumer;
import org.teavm.diagnostics.Problem;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.model.CallLocation;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.vm.TeaVM;

public final class TeaVMProblemRenderer {
    private TeaVMProblemRenderer() {
    }

    public static void describeProblems(TeaVM vm, TeaVMToolLog log) {
        TeaVMProblemRenderer.describeProblems(vm.getDependencyInfo().getCallGraph(), vm.getProblemProvider(), log);
    }

    public static void describeProblems(CallGraph cg, ProblemProvider problems, TeaVMToolLog log) {
        DefaultProblemTextConsumer consumer = new DefaultProblemTextConsumer();
        for (Problem problem : problems.getProblems()) {
            consumer.clear();
            problem.render(consumer);
            StringBuilder sb = new StringBuilder();
            sb.append(consumer.getText());
            TeaVMProblemRenderer.renderCallStack(cg, problem.getLocation(), sb);
            String problemText = sb.toString();
            switch (problem.getSeverity()) {
                case ERROR: {
                    log.error(problemText);
                    break;
                }
                case WARNING: {
                    log.warning(problemText);
                }
            }
        }
    }

    public static void renderCallStack(CallGraph cg, CallLocation location, StringBuilder sb) {
        if (location == null) {
            return;
        }
        sb.append("\n    at ");
        TeaVMProblemRenderer.renderCallLocation(location.getMethod(), location.getSourceLocation(), sb);
        if (location.getMethod() != null) {
            Iterator<? extends CallSite> callSites;
            CallGraphNode node = cg.getNode(location.getMethod());
            for (int i = 0; i < 100 && (callSites = node.getCallerCallSites().iterator()).hasNext(); ++i) {
                CallSite callSite = callSites.next();
                sb.append("\n    at ");
                CallGraphNode caller = TeaVMProblemRenderer.getCaller(callSite);
                TeaVMProblemRenderer.renderCallLocation(caller.getMethod(), TeaVMProblemRenderer.getLocation(callSite, caller), sb);
                node = caller;
            }
        }
    }

    private static CallGraphNode getCaller(CallSite callSite) {
        Collection<? extends CallGraphNode> callers = callSite.getCallers();
        if (callers.isEmpty()) {
            return null;
        }
        return callers.iterator().next();
    }

    private static TextLocation getLocation(CallSite callSite, CallGraphNode caller) {
        if (caller == null) {
            return null;
        }
        Collection<? extends TextLocation> locations = callSite.getLocations(caller);
        if (locations.isEmpty()) {
            return null;
        }
        return locations.iterator().next();
    }

    public static void renderCallLocation(MethodReference method, TextLocation location, StringBuilder sb) {
        if (method != null) {
            sb.append(method.getClassName() + "." + method.getName());
        } else {
            sb.append("unknown method");
        }
        if (location != null) {
            sb.append("(");
            String fileName = location.getFileName();
            if (fileName != null) {
                sb.append(fileName.substring(fileName.lastIndexOf(47) + 1));
                sb.append(':');
            }
            sb.append(location.getLine());
            sb.append(')');
        }
    }
}

