/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin.wasmgc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapper;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCTypeMapper;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStorageType;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.ValueType;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.wasmgc.FieldMarker;
import org.teavm.platform.plugin.wasmgc.ResourceMapEntry;
import org.teavm.platform.plugin.wasmgc.ResourceMarker;

public class ResourceCustomTypeMapper
implements WasmGCCustomTypeMapper {
    private WasmModule module;
    private WasmGCTypeMapper typeMapper;
    private ClassReaderSource classSource;
    private WasmGCNameProvider names;
    private Map<String, WasmStructure> structures = new HashMap<String, WasmStructure>();
    private WasmArray array;
    private WasmArray mapArray;

    public ResourceCustomTypeMapper(WasmModule module, WasmGCTypeMapper typeMapper, ClassReaderSource classSource, WasmGCNameProvider names) {
        this.module = module;
        this.typeMapper = typeMapper;
        this.classSource = classSource;
        this.names = names;
    }

    @Override
    public WasmType map(String className) {
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return null;
        }
        if (cls.getAnnotations().get(ResourceMarker.class.getName()) == null) {
            return null;
        }
        if (className.equals(Resource.class.getName())) {
            return WasmType.Reference.EQ;
        }
        if (className.equals(ResourceArray.class.getName())) {
            if (this.array == null) {
                this.array = new WasmArray(this.names.topLevel(this.names.suggestForClass(className)), WasmType.Reference.EQ.asStorage());
                this.array.setImmutable(true);
                this.module.types.add(this.array);
            }
            return this.array.getReference();
        }
        if (className.equals(ResourceMap.class.getName())) {
            if (this.mapArray == null) {
                this.mapArray = new WasmArray(this.names.topLevel(this.names.suggestForClass(className)), this.typeMapper.mapStorageType(ValueType.object(ResourceMapEntry.class.getName())));
                this.mapArray.setImmutable(true);
                this.module.types.add(this.mapArray);
            }
            return this.mapArray.getReference();
        }
        return this.getStructure(className).getReference();
    }

    private WasmStructure getStructure(String className) {
        WasmStructure struct = this.structures.get(className);
        if (struct == null) {
            String name = this.names.topLevel(this.names.suggestForClass(className));
            ClassReader cls = this.classSource.get(className);
            struct = new WasmStructure(name, fields -> this.addFieldsFromClass(cls, (List<WasmField>)fields));
            this.module.types.add(struct);
            this.structures.put(className, struct);
            if (!cls.getParent().equals(Resource.class.getName())) {
                struct.setSupertype(this.getStructure(cls.getParent()));
            }
        }
        return struct;
    }

    private void addFieldsFromClass(ClassReader cls, List<WasmField> fields) {
        ClassReader parentCls;
        if (!cls.getName().equals(Resource.class.getName()) && (parentCls = this.classSource.get(cls.getParent())) != null) {
            this.addFieldsFromClass(parentCls, fields);
        }
        for (MethodReader methodReader : cls.getMethods()) {
            AnnotationReader annot = methodReader.getAnnotations().get(FieldMarker.class.getName());
            if (annot == null) continue;
            String fieldName = annot.getValue("value").getString();
            WasmStorageType fieldType = this.typeMapper.mapStorageType(methodReader.getResultType());
            WasmField field = new WasmField(fieldType, this.names.structureField(fieldName));
            field.setImmutable(true);
            fields.add(field);
        }
    }
}

