/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.StringAmplifier;

public class StringAmplifierTransformer
implements ClassHolderTransformer {
    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        for (MethodHolder method : cls.getMethods()) {
            if (method.getProgram() == null) continue;
            this.transformProgram(context.getHierarchy(), method.getProgram());
        }
    }

    private void transformProgram(ClassHierarchy hierarchy, Program program) {
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                InvokeInstruction amplifyInstruction;
                Variable var;
                InvokeInstruction invoke;
                if (!(instruction instanceof InvokeInstruction) || (invoke = (InvokeInstruction)instruction).getReceiver() == null) continue;
                MethodReference method = invoke.getMethod();
                String owningClass = method.getClassName();
                if (!hierarchy.isSuperType(Resource.class.getName(), owningClass, false)) continue;
                if (method.getClassName().equals(ResourceMap.class.getName())) {
                    if (!method.getName().equals("keys")) continue;
                    var = program.createVariable();
                    amplifyInstruction = new InvokeInstruction();
                    amplifyInstruction.setMethod(new MethodReference(StringAmplifier.class, "amplifyArray", String[].class, String[].class));
                    amplifyInstruction.setType(InvocationType.SPECIAL);
                    amplifyInstruction.setArguments(var);
                    amplifyInstruction.setReceiver(invoke.getReceiver());
                    amplifyInstruction.setLocation(invoke.getLocation());
                    invoke.setReceiver(var);
                    invoke.insertNext(amplifyInstruction);
                    continue;
                }
                if (!method.getReturnType().isObject(String.class)) continue;
                var = program.createVariable();
                amplifyInstruction = new InvokeInstruction();
                amplifyInstruction.setMethod(new MethodReference(StringAmplifier.class, "amplify", String.class, String.class));
                amplifyInstruction.setType(InvocationType.SPECIAL);
                amplifyInstruction.setArguments(var);
                amplifyInstruction.setReceiver(invoke.getReceiver());
                amplifyInstruction.setLocation(invoke.getLocation());
                invoke.setReceiver(var);
                invoke.insertNext(amplifyInstruction);
            }
        }
    }
}

