/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmInt64Subtype;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.interop.Address;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.ResourceAccessorType;
import org.teavm.platform.plugin.ResourceMethodDescriptor;
import org.teavm.platform.plugin.ResourceTypeDescriptor;

public class ResourceReadIntrinsic
implements WasmIntrinsic {
    private static final MethodReference LOOKUP_METHOD = new MethodReference(WasmRuntime.class, "lookupResource", Address.class, String.class, Address.class);
    private static final MethodReference KEYS_METHOD = new MethodReference(WasmRuntime.class, "resourceMapKeys", Address.class, String[].class);
    private ClassReaderSource classSource;
    private Map<String, StructureDescriptor> typeDescriptorCache = new HashMap<String, StructureDescriptor>();

    public ResourceReadIntrinsic(ClassReaderSource classSource) {
        this.classSource = classSource;
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        return this.classSource.isSuperType(Resource.class.getTypeName(), methodReference.getClassName()).orElse(false);
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        if (invocation.getMethod().getClassName().equals(ResourceMap.class.getName())) {
            return this.applyForResourceMap(manager, invocation);
        }
        if (invocation.getMethod().getClassName().equals(ResourceArray.class.getName())) {
            return this.applyForResourceArray(manager, invocation);
        }
        StructureDescriptor typeDescriptor = this.getTypeDescriptor(manager.getClassHierarchy(), invocation.getMethod().getClassName());
        PropertyDescriptor property = typeDescriptor.layout.get(invocation.getMethod());
        WasmExpression base = manager.generate(invocation.getArguments().get(0));
        if (property.type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)property.type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    return new WasmLoadInt32(1, base, WasmInt32Subtype.INT8, property.offset);
                }
                case SHORT: {
                    return new WasmLoadInt32(2, base, WasmInt32Subtype.INT16, property.offset);
                }
                case CHARACTER: {
                    return new WasmLoadInt32(2, base, WasmInt32Subtype.UINT16, property.offset);
                }
                case INTEGER: {
                    return new WasmLoadInt32(4, base, WasmInt32Subtype.INT32, property.offset);
                }
                case LONG: {
                    return new WasmLoadInt64(8, base, WasmInt64Subtype.INT64, property.offset);
                }
                case FLOAT: {
                    return new WasmLoadFloat32(4, base, property.offset);
                }
                case DOUBLE: {
                    return new WasmLoadFloat64(8, base, property.offset);
                }
            }
        }
        return new WasmLoadInt32(4, base, WasmInt32Subtype.INT32, property.offset);
    }

    private WasmExpression applyForResourceArray(WasmIntrinsicManager manager, InvocationExpr invocation) {
        switch (invocation.getMethod().getName()) {
            case "get": {
                WasmExpression map = manager.generate(invocation.getArguments().get(0));
                WasmExpression index = manager.generate(invocation.getArguments().get(1));
                WasmIntBinary offset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, index, new WasmInt32Constant(2));
                WasmIntBinary address = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, map, offset);
                return new WasmLoadInt32(4, address, WasmInt32Subtype.INT32, 4);
            }
            case "size": {
                return new WasmLoadInt32(4, manager.generate(invocation.getArguments().get(0)), WasmInt32Subtype.INT32, 0);
            }
        }
        throw new AssertionError();
    }

    private WasmExpression applyForResourceMap(WasmIntrinsicManager manager, InvocationExpr invocation) {
        switch (invocation.getMethod().getName()) {
            case "keys": {
                WasmExpression map = manager.generate(invocation.getArguments().get(0));
                WasmCall call = new WasmCall(manager.getFunctions().forStaticMethod(KEYS_METHOD));
                call.getArguments().add(map);
                return call;
            }
            case "has": {
                WasmExpression map = manager.generate(invocation.getArguments().get(0));
                WasmExpression key = manager.generate(invocation.getArguments().get(1));
                WasmCall call = new WasmCall(manager.getFunctions().forStaticMethod(LOOKUP_METHOD));
                call.getArguments().add(map);
                call.getArguments().add(key);
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.NE, call, new WasmInt32Constant(0));
            }
            case "get": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32.asBlock());
                WasmExpression map = manager.generate(invocation.getArguments().get(0));
                WasmExpression key = manager.generate(invocation.getArguments().get(1));
                WasmCall call = new WasmCall(manager.getFunctions().forStaticMethod(LOOKUP_METHOD));
                call.getArguments().add(map);
                call.getArguments().add(key);
                WasmLocal entryVar = manager.getTemporary(WasmType.INT32);
                block.getBody().add(new WasmSetLocal(entryVar, call));
                WasmBranch ifNull = new WasmBranch(new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, new WasmGetLocal(entryVar), new WasmInt32Constant(0)), block);
                ifNull.setResult(new WasmInt32Constant(0));
                block.getBody().add(new WasmDrop(ifNull));
                block.getBody().add(new WasmLoadInt32(4, new WasmGetLocal(entryVar), WasmInt32Subtype.INT32, 4));
                return block;
            }
        }
        throw new AssertionError();
    }

    private StructureDescriptor getTypeDescriptor(ClassHierarchy hierarchy, String className) {
        return this.typeDescriptorCache.computeIfAbsent(className, n -> {
            ClassReader cls = this.classSource.get(className);
            StructureDescriptor structureDescriptor = new StructureDescriptor();
            structureDescriptor.typeDescriptor = new ResourceTypeDescriptor(hierarchy, cls);
            this.calculateLayout(structureDescriptor.typeDescriptor, structureDescriptor.layout);
            return structureDescriptor;
        });
    }

    private void calculateLayout(ResourceTypeDescriptor typeDescriptor, Map<MethodReference, PropertyDescriptor> layout) {
        HashMap<String, Integer> propertyIndexes = new HashMap<String, Integer>();
        ArrayList<String> propertyNames = new ArrayList<String>(typeDescriptor.getPropertyTypes().keySet());
        for (int i = 0; i < propertyNames.size(); ++i) {
            propertyIndexes.put((String)propertyNames.get(i), i);
        }
        MethodReader[] methods = new MethodReader[typeDescriptor.getPropertyTypes().size()];
        for (MethodReader method : typeDescriptor.getMethods().keySet()) {
            ResourceMethodDescriptor methodDescriptor = typeDescriptor.getMethods().get(method);
            if (methodDescriptor.getType() == ResourceAccessorType.SETTER) continue;
            String propertyName = methodDescriptor.getPropertyName();
            int index = (Integer)propertyIndexes.get(propertyName);
            methods[index] = method;
        }
        int currentOffset = 0;
        for (MethodReader method : methods) {
            ValueType propertyType = method.getResultType();
            int size = WasmClassGenerator.getTypeSize(propertyType);
            currentOffset = BinaryWriter.align(currentOffset, size);
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor();
            propertyDescriptor.offset = currentOffset;
            propertyDescriptor.type = propertyType;
            layout.put(method.getReference(), propertyDescriptor);
            currentOffset += size;
        }
    }

    static class StructureDescriptor {
        ResourceTypeDescriptor typeDescriptor;
        Map<MethodReference, PropertyDescriptor> layout = new HashMap<MethodReference, PropertyDescriptor>();

        StructureDescriptor() {
        }
    }

    static class PropertyDescriptor {
        int offset;
        ValueType type;

        PropertyDescriptor() {
        }
    }
}

