/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing;

import java.util.Date;
import java.util.function.Function;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ReferenceCache;
import org.teavm.parsing.ClassDateProvider;
import org.teavm.parsing.ClasspathResourceProvider;
import org.teavm.parsing.RenamingResourceMapper;
import org.teavm.parsing.resource.MapperClassHolderSource;
import org.teavm.parsing.resource.ResourceClassHolderMapper;
import org.teavm.parsing.resource.ResourceProvider;

public class ClasspathClassHolderSource
implements ClassHolderSource,
ClassDateProvider {
    private MapperClassHolderSource innerClassSource;
    private RenamingResourceMapper classPathMapper;

    public ClasspathClassHolderSource(ResourceProvider resourceProvider, ReferenceCache referenceCache) {
        ResourceClassHolderMapper rawMapper = new ResourceClassHolderMapper(resourceProvider, referenceCache);
        this.classPathMapper = new RenamingResourceMapper(resourceProvider, referenceCache, (Function<String, ClassHolder>)rawMapper);
        this.innerClassSource = new MapperClassHolderSource(this.classPathMapper);
    }

    public ClasspathClassHolderSource(ReferenceCache referenceCache) {
        this(new ClasspathResourceProvider(ClasspathClassHolderSource.class.getClassLoader()), referenceCache);
    }

    @Override
    public ClassHolder get(String name) {
        return this.innerClassSource.get(name);
    }

    @Override
    public Date getModificationDate(String className) {
        return this.classPathMapper.getModificationDate(className);
    }
}

