/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import org.teavm.common.GraphSplittingBackend;
import org.teavm.hppc.IntIntHashMap;
import org.teavm.model.BasicBlock;
import org.teavm.model.Program;
import org.teavm.model.util.BasicBlockMapper;
import org.teavm.model.util.ProgramUtils;

public class ProgramNodeSplittingBackend
implements GraphSplittingBackend {
    private Program program;

    public ProgramNodeSplittingBackend(Program program) {
        this.program = program;
    }

    @Override
    public int[] split(int[] remaining, int[] toCopy) {
        int[] copies = new int[toCopy.length];
        IntIntHashMap map = new IntIntHashMap();
        for (int i = 0; i < toCopy.length; ++i) {
            int node = toCopy[i];
            BasicBlock block2 = this.program.basicBlockAt(node);
            BasicBlock blockCopy = this.program.createBasicBlock();
            ProgramUtils.copyBasicBlock(block2, blockCopy);
            copies[i] = blockCopy.getIndex();
            map.put(toCopy[i], copies[i] + 1);
        }
        BasicBlockMapper copyBlockMapper = new BasicBlockMapper(block -> {
            int mappedIndex = map.get(block);
            return mappedIndex == 0 ? block : mappedIndex - 1;
        });
        for (int copy : copies) {
            copyBlockMapper.transform(this.program.basicBlockAt(copy));
        }
        for (int domainNode : remaining) {
            copyBlockMapper.transform(this.program.basicBlockAt(domainNode));
        }
        return copies;
    }
}

