/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReader;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.util.ProgramUtils;

public final class ModelUtils {
    private ModelUtils() {
    }

    public static ClassHolder copyClass(ClassReader original, ClassHolder target) {
        return ModelUtils.copyClass(original, target, true);
    }

    public static ClassHolder copyClass(ClassReader original, ClassHolder target, boolean withPrograms) {
        target.setLevel(original.getLevel());
        target.getModifiers().addAll(original.readModifiers());
        target.setParent(original.getParent());
        target.getInterfaces().addAll(original.getInterfaces());
        for (MethodReader methodReader : original.getMethods()) {
            target.addMethod(ModelUtils.copyMethod(methodReader, withPrograms));
        }
        for (FieldReader fieldReader : original.getFields()) {
            target.addField(ModelUtils.copyField(fieldReader));
        }
        target.setOwnerName(original.getOwnerName());
        target.setDeclaringClassName(original.getDeclaringClassName());
        target.setSimpleName(original.getSimpleName());
        target.getInnerClasses().addAll(original.getInnerClasses());
        ModelUtils.copyAnnotations(original.getAnnotations(), target.getAnnotations());
        if (original.getGenericParameters() != null) {
            target.setGenericParameters(original.getGenericParameters());
        }
        return target;
    }

    public static ClassHolder copyClass(ClassReader original) {
        return ModelUtils.copyClass(original, true);
    }

    public static ClassHolder copyClass(ClassReader original, boolean withPrograms) {
        return ModelUtils.copyClass(original, new ClassHolder(original.getName()), withPrograms);
    }

    public static MethodHolder copyMethod(MethodReader method) {
        return ModelUtils.copyMethod(method, true);
    }

    public static MethodHolder copyMethod(MethodReader method, boolean withProgram) {
        MethodHolder copy = new MethodHolder(method.getDescriptor());
        copy.setLevel(method.getLevel());
        copy.getModifiers().addAll(method.readModifiers());
        copy.setTypeParameters(method.getTypeParameters());
        copy.setGenericSignature(method.getGenericResultType(), method.getGenericParameterTypes());
        if (method.getProgram() != null && withProgram) {
            copy.setProgram(ProgramUtils.copy(method.getProgram()));
        }
        ModelUtils.copyAnnotations(method.getAnnotations(), copy.getAnnotations());
        if (method.getAnnotationDefault() != null) {
            copy.setAnnotationDefault(ModelUtils.copyAnnotationValue(method.getAnnotationDefault()));
        }
        for (int i = 0; i < method.parameterCount(); ++i) {
            ModelUtils.copyAnnotations(method.parameterAnnotation(i), copy.parameterAnnotation(i));
        }
        return copy;
    }

    public static FieldHolder copyField(FieldReader field) {
        FieldHolder copy = new FieldHolder(field.getName());
        copy.setLevel(field.getLevel());
        copy.getModifiers().addAll(field.readModifiers());
        copy.setType(field.getType());
        copy.setGenericType(field.getGenericType());
        copy.setInitialValue(field.getInitialValue());
        ModelUtils.copyAnnotations(field.getAnnotations(), copy.getAnnotations());
        return copy;
    }

    public static void copyAnnotations(AnnotationContainerReader src, AnnotationContainer dst) {
        for (AnnotationReader annotationReader : src.all()) {
            dst.add(ModelUtils.copyAnnotation(annotationReader));
        }
    }

    private static AnnotationHolder copyAnnotation(AnnotationReader annot) {
        AnnotationHolder copy = new AnnotationHolder(annot.getType());
        for (String fieldName : annot.getAvailableFields()) {
            copy.getValues().put(fieldName, ModelUtils.copyAnnotationValue(annot.getValue(fieldName)));
        }
        return copy;
    }

    private static AnnotationValue copyAnnotationValue(AnnotationValue value) {
        switch (value.getType()) {
            case 9: {
                ArrayList<AnnotationValue> listCopy = new ArrayList<AnnotationValue>();
                for (AnnotationValue item : value.getList()) {
                    listCopy.add(ModelUtils.copyAnnotationValue(item));
                }
                return new AnnotationValue(listCopy);
            }
            case 11: {
                return new AnnotationValue(ModelUtils.copyAnnotation(value.getAnnotation()));
            }
        }
        return value;
    }
}

