/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.FieldReference;
import org.teavm.model.IncomingReader;
import org.teavm.model.InstructionIterator;
import org.teavm.model.InterpretException;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodReference;
import org.teavm.model.PhiReader;
import org.teavm.model.ProgramReader;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.TextLocation;
import org.teavm.model.TryCatchBlockReader;
import org.teavm.model.ValueType;
import org.teavm.model.VariableReader;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.BinaryBranchingCondition;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.CastIntegerDirection;
import org.teavm.model.instructions.InstructionReader;
import org.teavm.model.instructions.IntegerSubtype;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.instructions.SwitchTableEntryReader;

public class Interpreter {
    private ClassLoader classLoader;
    private BasicBlockReader currentBlock;
    private List<List<IncomingReader>> outgoings;
    private Object[] variables;
    private Object result;
    private State state;
    private InstructionReader reader = new InstructionReader(){

        @Override
        public void location(TextLocation location) {
        }

        @Override
        public void nop() {
        }

        @Override
        public void classConstant(VariableReader receiver, ValueType cst) {
            Interpreter.this.variables[receiver.getIndex()] = this.asJvmClass(cst);
        }

        @Override
        public void nullConstant(VariableReader receiver) {
            Interpreter.this.variables[receiver.getIndex()] = null;
        }

        @Override
        public void integerConstant(VariableReader receiver, int cst) {
            Interpreter.this.variables[receiver.getIndex()] = cst;
        }

        @Override
        public void longConstant(VariableReader receiver, long cst) {
            Interpreter.this.variables[receiver.getIndex()] = cst;
        }

        @Override
        public void floatConstant(VariableReader receiver, float cst) {
            Interpreter.this.variables[receiver.getIndex()] = Float.valueOf(cst);
        }

        @Override
        public void doubleConstant(VariableReader receiver, double cst) {
            Interpreter.this.variables[receiver.getIndex()] = cst;
        }

        @Override
        public void stringConstant(VariableReader receiver, String cst) {
            Interpreter.this.variables[receiver.getIndex()] = cst;
        }

        @Override
        public void binary(BinaryOperation op, VariableReader receiver, VariableReader first, VariableReader second, NumericOperandType type) {
            switch (type) {
                case INT: {
                    int result;
                    int a = (Integer)Interpreter.this.variables[first.getIndex()];
                    int b = (Integer)Interpreter.this.variables[second.getIndex()];
                    switch (op) {
                        case ADD: {
                            result = a + b;
                            break;
                        }
                        case SUBTRACT: {
                            result = a - b;
                            break;
                        }
                        case MULTIPLY: {
                            result = a * b;
                            break;
                        }
                        case DIVIDE: {
                            result = a * b;
                            break;
                        }
                        case MODULO: {
                            result = a % b;
                            break;
                        }
                        case COMPARE_LESS: 
                        case COMPARE_GREATER: {
                            result = Integer.compare(a, b);
                            break;
                        }
                        case AND: {
                            result = a & b;
                            break;
                        }
                        case OR: {
                            result = a | b;
                            break;
                        }
                        case XOR: {
                            result = a ^ b;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown operation: " + String.valueOf((Object)op));
                        }
                    }
                    Interpreter.this.variables[receiver.getIndex()] = result;
                    break;
                }
                case LONG: {
                    long result;
                    long a = (Long)Interpreter.this.variables[first.getIndex()];
                    long b = (Long)Interpreter.this.variables[second.getIndex()];
                    switch (op) {
                        case ADD: {
                            result = a + b;
                            break;
                        }
                        case SUBTRACT: {
                            result = a - b;
                            break;
                        }
                        case MULTIPLY: {
                            result = a * b;
                            break;
                        }
                        case DIVIDE: {
                            result = a * b;
                            break;
                        }
                        case MODULO: {
                            result = a % b;
                            break;
                        }
                        case COMPARE_LESS: 
                        case COMPARE_GREATER: {
                            result = Long.compare(a, b);
                            break;
                        }
                        case AND: {
                            result = a & b;
                            break;
                        }
                        case OR: {
                            result = a | b;
                            break;
                        }
                        case XOR: {
                            result = a ^ b;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown operation: " + String.valueOf((Object)op));
                        }
                    }
                    Interpreter.this.variables[receiver.getIndex()] = result;
                    break;
                }
                case FLOAT: {
                    float result;
                    float a = ((Float)Interpreter.this.variables[first.getIndex()]).floatValue();
                    float b = ((Float)Interpreter.this.variables[second.getIndex()]).floatValue();
                    switch (op) {
                        case ADD: {
                            result = a + b;
                            break;
                        }
                        case SUBTRACT: {
                            result = a - b;
                            break;
                        }
                        case MULTIPLY: {
                            result = a * b;
                            break;
                        }
                        case DIVIDE: {
                            result = a * b;
                            break;
                        }
                        case MODULO: {
                            result = a % b;
                            break;
                        }
                        case COMPARE_LESS: 
                        case COMPARE_GREATER: {
                            result = Float.compare(a, b);
                            break;
                        }
                        case AND: 
                        case OR: 
                        case XOR: {
                            throw new IllegalArgumentException("Unsupported operation " + String.valueOf((Object)op) + " for operands of type" + String.valueOf((Object)type));
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown operation: " + String.valueOf((Object)op));
                        }
                    }
                    Interpreter.this.variables[receiver.getIndex()] = Float.valueOf(result);
                    break;
                }
                case DOUBLE: {
                    double result;
                    double a = (Double)Interpreter.this.variables[first.getIndex()];
                    double b = (Double)Interpreter.this.variables[second.getIndex()];
                    switch (op) {
                        case ADD: {
                            result = a + b;
                            break;
                        }
                        case SUBTRACT: {
                            result = a - b;
                            break;
                        }
                        case MULTIPLY: {
                            result = a * b;
                            break;
                        }
                        case DIVIDE: {
                            result = a * b;
                            break;
                        }
                        case MODULO: {
                            result = a % b;
                            break;
                        }
                        case COMPARE_LESS: 
                        case COMPARE_GREATER: {
                            result = Double.compare(a, b);
                            break;
                        }
                        case AND: 
                        case OR: 
                        case XOR: {
                            throw new IllegalArgumentException("Unsupported operation " + String.valueOf((Object)op) + " for operands of type" + String.valueOf((Object)type));
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown operation: " + String.valueOf((Object)op));
                        }
                    }
                    Interpreter.this.variables[receiver.getIndex()] = result;
                    break;
                }
            }
        }

        @Override
        public void negate(VariableReader receiver, VariableReader operand, NumericOperandType type) {
            Number result;
            Object a = Interpreter.this.variables[operand.getIndex()];
            switch (type) {
                case INT: {
                    result = -((Integer)a).intValue();
                    break;
                }
                case LONG: {
                    result = -((Long)a).longValue();
                    break;
                }
                case FLOAT: {
                    result = Float.valueOf(-((Float)a).floatValue());
                    break;
                }
                case DOUBLE: {
                    result = -((Double)a).doubleValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + String.valueOf((Object)type));
                }
            }
            Interpreter.this.variables[receiver.getIndex()] = result;
        }

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            Interpreter.this.variables[receiver.getIndex()] = Interpreter.this.variables[assignee.getIndex()];
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, ValueType targetType, boolean cast) {
            Interpreter.this.variables[receiver.getIndex()] = this.asJvmClass(targetType).cast(Interpreter.this.variables[value.getIndex()]);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, NumericOperandType sourceType, NumericOperandType targetType) {
            Number result;
            block0 : switch (sourceType) {
                case INT: {
                    int a = (Integer)Interpreter.this.variables[value.getIndex()];
                    switch (targetType) {
                        case INT: {
                            result = a;
                            break block0;
                        }
                        case LONG: {
                            result = a;
                            break block0;
                        }
                        case FLOAT: {
                            result = Float.valueOf(a);
                            break block0;
                        }
                        case DOUBLE: {
                            result = a;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Can't cast " + String.valueOf((Object)sourceType) + " to " + String.valueOf((Object)targetType));
                }
                case LONG: {
                    long a = (Long)Interpreter.this.variables[value.getIndex()];
                    switch (targetType) {
                        case INT: {
                            result = (int)a;
                            break block0;
                        }
                        case LONG: {
                            result = a;
                            break block0;
                        }
                        case FLOAT: {
                            result = Float.valueOf(a);
                            break block0;
                        }
                        case DOUBLE: {
                            result = a;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Can't cast " + String.valueOf((Object)sourceType) + " to " + String.valueOf((Object)targetType));
                }
                case FLOAT: {
                    float a = ((Float)Interpreter.this.variables[value.getIndex()]).floatValue();
                    switch (targetType) {
                        case INT: {
                            result = (int)a;
                            break block0;
                        }
                        case LONG: {
                            result = (long)a;
                            break block0;
                        }
                        case FLOAT: {
                            result = Float.valueOf(a);
                            break block0;
                        }
                        case DOUBLE: {
                            result = a;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Can't cast " + String.valueOf((Object)sourceType) + " to " + String.valueOf((Object)targetType));
                }
                case DOUBLE: {
                    double a = (Double)Interpreter.this.variables[value.getIndex()];
                    switch (targetType) {
                        case INT: {
                            result = (int)a;
                            break block0;
                        }
                        case LONG: {
                            result = (long)a;
                            break block0;
                        }
                        case FLOAT: {
                            result = Float.valueOf((float)a);
                            break block0;
                        }
                        case DOUBLE: {
                            result = a;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Can't cast " + String.valueOf((Object)sourceType) + " to " + String.valueOf((Object)targetType));
                }
                default: {
                    throw new IllegalArgumentException("Can't cast " + String.valueOf((Object)sourceType) + " to " + String.valueOf((Object)targetType));
                }
            }
            Interpreter.this.variables[receiver.getIndex()] = result;
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, IntegerSubtype type, CastIntegerDirection direction) {
            switch (direction) {
                case FROM_INTEGER: {
                    Comparable<Byte> result;
                    int a = (Integer)Interpreter.this.variables[value.getIndex()];
                    switch (type) {
                        case BYTE: {
                            result = (byte)a;
                            break;
                        }
                        case SHORT: {
                            result = (short)a;
                            break;
                        }
                        case CHAR: {
                            result = Character.valueOf((char)a);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown type: " + String.valueOf((Object)type));
                        }
                    }
                    Interpreter.this.variables[receiver.getIndex()] = result;
                    break;
                }
                case TO_INTEGER: {
                    short result;
                    Object a = Interpreter.this.variables[value.getIndex()];
                    switch (type) {
                        case BYTE: {
                            result = ((Byte)a).byteValue();
                            break;
                        }
                        case SHORT: {
                            result = (Short)a;
                            break;
                        }
                        case CHAR: {
                            result = (short)((Character)a).charValue();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown type: " + String.valueOf((Object)type));
                        }
                    }
                    Interpreter.this.variables[receiver.getIndex()] = (int)result;
                    break;
                }
            }
        }

        @Override
        public void jumpIf(BranchingCondition cond, VariableReader operand, BasicBlockReader consequent, BasicBlockReader alternative) {
            boolean c;
            Object a = Interpreter.this.variables[operand.getIndex()];
            switch (cond) {
                case EQUAL: {
                    c = (Integer)a == 0;
                    break;
                }
                case NOT_EQUAL: {
                    c = (Integer)a != 0;
                    break;
                }
                case LESS: {
                    c = (Integer)a < 0;
                    break;
                }
                case LESS_OR_EQUAL: {
                    c = (Integer)a <= 0;
                    break;
                }
                case GREATER: {
                    c = (Integer)a > 0;
                    break;
                }
                case GREATER_OR_EQUAL: {
                    c = (Integer)a >= 0;
                    break;
                }
                case NULL: {
                    c = a == null;
                    break;
                }
                case NOT_NULL: {
                    c = a != null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown condition: " + String.valueOf((Object)cond));
                }
            }
            this.jump(c ? consequent : alternative);
        }

        @Override
        public void jumpIf(BinaryBranchingCondition cond, VariableReader first, VariableReader second, BasicBlockReader consequent, BasicBlockReader alternative) {
            boolean c;
            Object a = Interpreter.this.variables[first.getIndex()];
            Object b = Interpreter.this.variables[second.getIndex()];
            switch (cond) {
                case EQUAL: {
                    c = ((Integer)a).intValue() == ((Integer)b).intValue();
                    break;
                }
                case NOT_EQUAL: {
                    c = ((Integer)a).intValue() != ((Integer)b).intValue();
                    break;
                }
                case REFERENCE_EQUAL: {
                    c = a == b;
                    break;
                }
                case REFERENCE_NOT_EQUAL: {
                    c = a != b;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown condition: " + String.valueOf((Object)cond));
                }
            }
            this.jump(c ? consequent : alternative);
        }

        @Override
        public void jump(BasicBlockReader target) {
            Object[] newVariables = (Object[])Interpreter.this.variables.clone();
            for (IncomingReader outgoing : Interpreter.this.outgoings.get(Interpreter.this.currentBlock.getIndex())) {
                if (outgoing.getPhi().getBasicBlock() != target) continue;
                newVariables[outgoing.getPhi().getReceiver().getIndex()] = Interpreter.this.variables[outgoing.getValue().getIndex()];
            }
            Interpreter.this.variables = newVariables;
            Interpreter.this.currentBlock = target;
        }

        @Override
        public void choose(VariableReader condition, List<? extends SwitchTableEntryReader> table, BasicBlockReader defaultTarget) {
            int value = (Integer)Interpreter.this.variables[condition.getIndex()];
            for (SwitchTableEntryReader switchTableEntryReader : table) {
                if (value != switchTableEntryReader.getCondition()) continue;
                this.jump(switchTableEntryReader.getTarget());
                return;
            }
            this.jump(defaultTarget);
        }

        @Override
        public void exit(VariableReader valueToReturn) {
            Interpreter.this.state = State.EXITED;
            Interpreter.this.result = Interpreter.this.variables[valueToReturn.getIndex()];
        }

        @Override
        public void raise(VariableReader exception) {
            Throwable e = (Throwable)Interpreter.this.variables[exception.getIndex()];
            if (!Interpreter.this.pickExceptionHandler(e)) {
                Interpreter.this.state = State.EXITED;
                Interpreter.this.result = e;
            }
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, VariableReader size) {
            Class<?> itemJvmType = this.asJvmClass(itemType);
            int sizeValue = (Integer)Interpreter.this.variables[size.getIndex()];
            Interpreter.this.variables[receiver.getIndex()] = Array.newInstance(itemJvmType, sizeValue);
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, List<? extends VariableReader> dimensions) {
            Class<?> itemJvmType = this.asJvmClass(itemType);
            for (int i = 1; i < dimensions.size(); ++i) {
                itemJvmType = Array.newInstance(itemJvmType, 0).getClass();
            }
            Interpreter.this.variables[receiver.getIndex()] = this.createArray(itemJvmType, dimensions, 0);
        }

        private Object createArray(Class<?> itemType, List<? extends VariableReader> dimensions, int dimensionIndex) {
            int dimensionValue = (Integer)Interpreter.this.variables[dimensions.get(dimensionIndex).getIndex()];
            Object result = Array.newInstance(itemType, dimensionValue);
            if (dimensionIndex < dimensions.size() - 1) {
                for (int i = 0; i < dimensionValue; ++i) {
                    Array.set(result, i, this.createArray(itemType.getComponentType(), dimensions, dimensionIndex + 1));
                }
            }
            return result;
        }

        @Override
        public void create(VariableReader receiver, String type) {
            try {
                Class<?> cls = Class.forName(type, false, Interpreter.this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found: " + type);
            }
            Interpreter.this.variables[receiver.getIndex()] = null;
        }

        @Override
        public void getField(VariableReader receiver, VariableReader instance, FieldReference field, ValueType fieldType) {
            Object result;
            Field jvmField = this.getJvmField(field);
            Object jvmInstance = instance != null ? Interpreter.this.variables[instance.getIndex()] : null;
            try {
                result = jvmField.get(jvmInstance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Can't get field value: " + String.valueOf(field));
            }
            Interpreter.this.variables[receiver.getIndex()] = result;
        }

        @Override
        public void putField(VariableReader instance, FieldReference field, VariableReader value, ValueType fieldType) {
            Field jvmField = this.getJvmField(field);
            Object jvmInstance = instance != null ? Interpreter.this.variables[instance.getIndex()] : null;
            try {
                jvmField.set(jvmInstance, Interpreter.this.variables[value.getIndex()]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Can't get field value: " + String.valueOf(field));
            }
        }

        private Field getJvmField(FieldReference field) {
            Field jvmField;
            Class<?> cls;
            try {
                cls = Class.forName(field.getClassName(), false, Interpreter.this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found: " + field.getClassName());
            }
            try {
                jvmField = cls.getDeclaredField(field.getFieldName());
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Field not found: " + String.valueOf(field));
            }
            jvmField.setAccessible(true);
            return jvmField;
        }

        @Override
        public void arrayLength(VariableReader receiver, VariableReader array) {
            int value = Array.getLength(Interpreter.this.variables[array.getIndex()]);
            Interpreter.this.variables[receiver.getIndex()] = value;
        }

        @Override
        public void cloneArray(VariableReader receiver, VariableReader array) {
            Object jvmArray = Interpreter.this.variables[array.getIndex()];
            int length = Array.getLength(jvmArray);
            Object copy = Array.newInstance(jvmArray.getClass().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(copy, i, Array.get(array, i));
            }
            Interpreter.this.variables[receiver.getIndex()] = copy;
        }

        @Override
        public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
            Interpreter.this.variables[receiver.getIndex()] = Interpreter.this.variables[array.getIndex()];
        }

        @Override
        public void getElement(VariableReader receiver, VariableReader array, VariableReader index, ArrayElementType type) {
            Object jvmArray = Interpreter.this.variables[array.getIndex()];
            int indexValue = (Integer)Interpreter.this.variables[index.getIndex()];
            Interpreter.this.variables[receiver.getIndex()] = Array.get(jvmArray, indexValue);
        }

        @Override
        public void putElement(VariableReader array, VariableReader index, VariableReader value, ArrayElementType type) {
            Object jvmArray = Interpreter.this.variables[array.getIndex()];
            int indexValue = (Integer)Interpreter.this.variables[index.getIndex()];
            Array.set(jvmArray, indexValue, Interpreter.this.variables[value.getIndex()]);
        }

        @Override
        public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
            Object result;
            Method jvmMethod = this.asJvmMethod(method);
            Object[] jvmArgs = new Object[arguments.size()];
            for (int i = 0; i < jvmArgs.length; ++i) {
                jvmArgs[i] = Interpreter.this.variables[arguments.get(i).getIndex()];
            }
            Object jvmInstance = instance != null ? Interpreter.this.variables[instance.getIndex()] : null;
            try {
                result = jvmMethod.invoke(jvmInstance, jvmArgs);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error calling method " + String.valueOf(method), e);
            }
            if (receiver != null) {
                Interpreter.this.variables[receiver.getIndex()] = result;
            }
        }

        private Method asJvmMethod(MethodReference method) {
            Class<?> cls;
            try {
                cls = Class.forName(method.getClassName(), false, Interpreter.this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Can't find class " + method.getClassName());
            }
            Object[] jvmParameters = new Class[method.parameterCount()];
            for (int i = 0; i < method.parameterCount(); ++i) {
                jvmParameters[i] = this.asJvmClass(method.parameterType(i));
            }
            Class<?> jvmReturnType = this.asJvmClass(method.getReturnType());
            for (Method jvmMethod : cls.getDeclaredMethods()) {
                if (!Arrays.equals(jvmMethod.getParameterTypes(), jvmParameters) || !jvmReturnType.equals(jvmMethod.getReturnType())) continue;
                return jvmMethod;
            }
            throw new RuntimeException("Method not found: " + String.valueOf(method));
        }

        @Override
        public void invokeDynamic(VariableReader receiver, VariableReader instance, MethodDescriptor method, List<? extends VariableReader> arguments, MethodHandle bootstrapMethod, List<RuntimeConstant> bootstrapArguments) {
            throw new RuntimeException("InvokeDynamic is not supported");
        }

        @Override
        public void isInstance(VariableReader receiver, VariableReader value, ValueType type) {
            Object jvmValue = Interpreter.this.variables[value.getIndex()];
            Class<?> jvmType = this.asJvmClass(type);
            Interpreter.this.variables[receiver.getIndex()] = jvmType.isInstance(jvmValue);
        }

        @Override
        public void initClass(String className) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found: " + className);
            }
        }

        @Override
        public void nullCheck(VariableReader receiver, VariableReader value) {
            Object jvmValue = Interpreter.this.variables[value.getIndex()];
            if (jvmValue == null) {
                throw new NullPointerException();
            }
            Interpreter.this.variables[receiver.getIndex()] = jvmValue;
        }

        @Override
        public void monitorEnter(VariableReader objectRef) {
        }

        @Override
        public void monitorExit(VariableReader objectRef) {
        }

        @Override
        public void boundCheck(VariableReader receiver, VariableReader index, VariableReader array, boolean lower) {
            Interpreter.this.variables[receiver.getIndex()] = Interpreter.this.variables[index.getIndex()];
        }

        private Class<?> asJvmClass(ValueType type) {
            if (type instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: {
                        return Boolean.TYPE;
                    }
                    case BYTE: {
                        return Byte.TYPE;
                    }
                    case SHORT: {
                        return Short.TYPE;
                    }
                    case CHARACTER: {
                        return Character.TYPE;
                    }
                    case INTEGER: {
                        return Integer.TYPE;
                    }
                    case LONG: {
                        return Long.TYPE;
                    }
                    case FLOAT: {
                        return Float.TYPE;
                    }
                    case DOUBLE: {
                        return Double.TYPE;
                    }
                }
            } else {
                if (type instanceof ValueType.Void) {
                    return Void.TYPE;
                }
                if (type instanceof ValueType.Array) {
                    Class<?> itemJvmClass = this.asJvmClass(((ValueType.Array)type).getItemType());
                    return Array.newInstance(itemJvmClass, 0).getClass();
                }
                if (type instanceof ValueType.Object) {
                    try {
                        Class.forName(((ValueType.Object)type).getClassName(), false, Interpreter.this.classLoader);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Class not found: " + String.valueOf(type));
                    }
                }
            }
            throw new IllegalArgumentException("Unknown type: " + String.valueOf(type));
        }
    };

    public Interpreter(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object interpret(ProgramReader program, Object[] parameters) throws InterpretException {
        int i;
        this.variables = new Object[program.variableCount()];
        System.arraycopy(parameters, 0, this.variables, 0, parameters.length);
        this.currentBlock = program.basicBlockAt(0);
        this.state = State.EXECUTING;
        this.outgoings = new ArrayList<List<IncomingReader>>();
        for (i = 0; i < program.basicBlockCount(); ++i) {
            this.outgoings.add(new ArrayList());
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlockReader block = program.basicBlockAt(i);
            for (PhiReader phiReader : block.readPhis()) {
                for (IncomingReader incomingReader : phiReader.readIncomings()) {
                    this.outgoings.get(incomingReader.getSource().getIndex()).add(incomingReader);
                }
            }
        }
        try {
            while (true) {
                block16: {
                    InstructionIterator iterator = this.currentBlock.iterateInstructions();
                    try {
                        while (iterator.hasNext()) {
                            iterator.next();
                            iterator.read(this.reader);
                        }
                    }
                    catch (RuntimeException e) {
                        if (this.pickExceptionHandler(e)) break block16;
                        throw new InterpretException(this.currentBlock, (Throwable)e);
                    }
                }
                switch (this.state.ordinal()) {
                    case 1: {
                        Object e = this.result;
                        return e;
                    }
                    case 2: {
                        Throwable ex = (Throwable)this.result;
                        throw new InterpretException(this.currentBlock, ex);
                    }
                }
            }
        }
        finally {
            this.currentBlock = null;
            this.variables = null;
            this.outgoings = null;
            this.result = null;
        }
    }

    private boolean pickExceptionHandler(Throwable e) {
        for (TryCatchBlockReader tryCatchBlockReader : this.currentBlock.readTryCatchBlocks()) {
            Class<?> exceptionType;
            try {
                exceptionType = tryCatchBlockReader.getExceptionType() != null ? Class.forName(tryCatchBlockReader.getExceptionType(), false, this.classLoader) : null;
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Can't find exception class " + tryCatchBlockReader.getExceptionType());
            }
            if (exceptionType != null && !exceptionType.isInstance(e)) continue;
            this.currentBlock = tryCatchBlockReader.getProtectedBlock();
            return true;
        }
        return false;
    }

    private static enum State {
        EXECUTING,
        EXITED,
        THROWN;

    }
}

