/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.backend.wasm.gc.TeaVMWasmGCHost;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSClassObjectToExpose;
import org.teavm.jso.impl.JSMethods;
import org.teavm.jso.impl.wasmgc.WasmGCJSBodyRenderer;
import org.teavm.jso.impl.wasmgc.WasmGCJSDependencies;
import org.teavm.jso.impl.wasmgc.WasmGCJSFunctions;
import org.teavm.jso.impl.wasmgc.WasmGCJSIntrinsic;
import org.teavm.jso.impl.wasmgc.WasmGCJSRuntime;
import org.teavm.jso.impl.wasmgc.WasmGCJSRuntimeIntrinsic;
import org.teavm.jso.impl.wasmgc.WasmGCJSTypeMapper;
import org.teavm.jso.impl.wasmgc.WasmGCJSWrapperIntrinsic;
import org.teavm.jso.impl.wasmgc.WasmGCJSWrapperTransformer;
import org.teavm.jso.impl.wasmgc.WasmGCJsoCommonGenerator;
import org.teavm.jso.impl.wasmgc.WasmGCJsoContext;
import org.teavm.jso.impl.wasmgc.WasmGCMarshallMethodGeneratorFactory;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.vm.spi.TeaVMHost;

public final class WasmGCJso {
    private WasmGCJso() {
    }

    public static void install(TeaVMHost host, TeaVMWasmGCHost wasmGCHost, JSBodyRepository jsBodyRepository) {
        host.add(new WasmGCJSDependencies());
        host.add(new WasmGCJSWrapperTransformer());
        WasmGCJSFunctions jsFunctions = new WasmGCJSFunctions();
        WasmGCJsoCommonGenerator commonGen = new WasmGCJsoCommonGenerator(jsFunctions);
        wasmGCHost.addCustomTypeMapperFactory(new WasmGCJSTypeMapper());
        wasmGCHost.addIntrinsicFactory(new WasmGCJSBodyRenderer(jsBodyRepository, jsFunctions, commonGen));
        wasmGCHost.addGeneratorFactory(new WasmGCMarshallMethodGeneratorFactory(commonGen));
        wasmGCHost.addClassConsumer((context, className) -> {
            ClassReader cls = context.classes().get(className);
            if (cls != null && cls.getAnnotations().get(JSClassObjectToExpose.class.getName()) != null) {
                commonGen.getDefinedClass(WasmGCJsoContext.wrap(context), className);
            }
        });
        WasmGCJSIntrinsic jsIntrinsic = new WasmGCJSIntrinsic(commonGen, jsFunctions);
        wasmGCHost.addIntrinsic(JSMethods.WRAP_STRING, jsIntrinsic);
        wasmGCHost.addIntrinsic(new MethodReference("org.teavm.jso.impl.JS", "unwrapString", JSMethods.JS_OBJECT, JSMethods.STRING), jsIntrinsic);
        wasmGCHost.addIntrinsic(JSMethods.GLOBAL, jsIntrinsic);
        wasmGCHost.addIntrinsic(JSMethods.THROW_CCE_IF_FALSE, jsIntrinsic);
        wasmGCHost.addIntrinsic(new MethodReference("org.teavm.jso.impl.JS", "isNull", JSMethods.JS_OBJECT, ValueType.BOOLEAN), jsIntrinsic);
        wasmGCHost.addIntrinsic(new MethodReference("org.teavm.jso.impl.JS", "jsArrayItem", JSMethods.OBJECT, ValueType.INTEGER, JSMethods.OBJECT), jsIntrinsic);
        wasmGCHost.addIntrinsic(JSMethods.GET, jsIntrinsic);
        wasmGCHost.addIntrinsic(JSMethods.GET_PURE, jsIntrinsic);
        wasmGCHost.addIntrinsic(JSMethods.IMPORT_MODULE, jsIntrinsic);
        WasmGCJSWrapperIntrinsic wrapperIntrinsic = new WasmGCJSWrapperIntrinsic();
        wasmGCHost.addIntrinsic(JSMethods.WRAP, wrapperIntrinsic);
        wasmGCHost.addIntrinsic(new MethodReference("org.teavm.jso.impl.JSWrapper", "isJava", JSMethods.JS_OBJECT, ValueType.BOOLEAN), wrapperIntrinsic);
        WasmGCJSRuntimeIntrinsic runtimeInstrinsic = new WasmGCJSRuntimeIntrinsic(commonGen);
        wasmGCHost.addIntrinsic(new MethodReference("org.teavm.jso.impl.wasmgc.WasmGCJSRuntime", "wrapObject", JSMethods.OBJECT, JSMethods.JS_OBJECT), runtimeInstrinsic);
        wasmGCHost.addIntrinsic(new MethodReference(WasmGCJSRuntime.CharArrayData.class, "of", String.class, WasmGCJSRuntime.CharArrayData.class), runtimeInstrinsic);
        wasmGCHost.addIntrinsic(new MethodReference(WasmGCJSRuntime.CharArrayData.class, "asString", String.class), runtimeInstrinsic);
        wasmGCHost.addIntrinsic(new MethodReference(WasmGCJSRuntime.CharArrayData.class, "create", Integer.TYPE, WasmGCJSRuntime.CharArrayData.class), runtimeInstrinsic);
        wasmGCHost.addIntrinsic(new MethodReference(WasmGCJSRuntime.CharArrayData.class, "put", Integer.TYPE, Character.TYPE, Void.TYPE), runtimeInstrinsic);
        String nonNullExternal = "org.teavm.jso.impl.wasmgc.WasmGCJSRuntime$NonNullExternal";
        wasmGCHost.addIntrinsic(new MethodReference(nonNullExternal, "toNullable", JSMethods.JS_OBJECT), runtimeInstrinsic);
    }
}

