/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.jso.impl.JSMethods;
import org.teavm.model.AccessLevel;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;

class WasmGCJSWrapperTransformer
implements ClassHolderTransformer {
    WasmGCJSWrapperTransformer() {
    }

    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (cls.getName().equals("org.teavm.jso.impl.JSWrapper")) {
            this.transformMarshallMethod(cls.getMethod(new MethodDescriptor("marshallJavaToJs", JSMethods.OBJECT, JSMethods.JS_OBJECT)), context);
            this.transformDirectJavaToJs(cls.getMethod(new MethodDescriptor("directJavaToJs", JSMethods.OBJECT, JSMethods.JS_OBJECT)), context);
            this.transformDirectJavaToJs(cls.getMethod(new MethodDescriptor("dependencyJavaToJs", JSMethods.OBJECT, JSMethods.JS_OBJECT)), context);
            this.transformDirectJsToJava(cls.getMethod(new MethodDescriptor("dependencyJsToJava", JSMethods.JS_OBJECT, JSMethods.OBJECT)), context);
            this.transformWrapMethod(cls.getMethod(new MethodDescriptor("wrap", JSMethods.JS_OBJECT, JSMethods.OBJECT)));
            this.transformIsJava(cls.getMethod(new MethodDescriptor("isJava", JSMethods.OBJECT, ValueType.BOOLEAN)), context);
            this.addCreateWrapperMethod(cls, context);
        }
    }

    private void transformMarshallMethod(MethodHolder method, ClassHolderTransformerContext context) {
        method.getModifiers().remove((Object)ElementModifier.NATIVE);
        ProgramEmitter pe = ProgramEmitter.create(method, context.getHierarchy());
        ValueEmitter obj = pe.var(1, Object.class);
        pe.when(obj.instanceOf(ValueType.object(JSMethods.JS_MARSHALLABLE)).isFalse()).thenDo(() -> pe.invoke("org.teavm.jso.impl.wasmgc.WasmGCJSRuntime", "wrapObject", JSMethods.JS_OBJECT, obj).returnValue());
        obj.cast(ValueType.object(JSMethods.JS_MARSHALLABLE)).invokeVirtual("marshallToJs", JSMethods.JS_OBJECT, new ValueEmitter[0]).returnValue();
    }

    private void transformDirectJavaToJs(MethodHolder method, ClassHolderTransformerContext context) {
        method.getModifiers().remove((Object)ElementModifier.NATIVE);
        ProgramEmitter pe = ProgramEmitter.create(method, context.getHierarchy());
        ValueEmitter obj = pe.var(1, JSMethods.OBJECT);
        pe.invoke("org.teavm.jso.impl.JSWrapper", "marshallJavaToJs", JSMethods.JS_OBJECT, obj).returnValue();
    }

    private void transformDirectJsToJava(MethodHolder method, ClassHolderTransformerContext context) {
        method.getModifiers().remove((Object)ElementModifier.NATIVE);
        ProgramEmitter pe = ProgramEmitter.create(method, context.getHierarchy());
        ValueEmitter obj = pe.var(1, JSMethods.JS_OBJECT);
        pe.invoke("org.teavm.jso.impl.JSWrapper", "unmarshallJavaFromJs", JSMethods.OBJECT, obj).returnValue();
    }

    private void transformWrapMethod(MethodHolder method) {
        method.getModifiers().add(ElementModifier.NATIVE);
        method.setProgram(null);
    }

    private void addCreateWrapperMethod(ClassHolder cls, ClassHolderTransformerContext context) {
        MethodHolder method = new MethodHolder(new MethodDescriptor("createWrapper", JSMethods.JS_OBJECT, JSMethods.OBJECT));
        method.getModifiers().add(ElementModifier.STATIC);
        method.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create(method, context.getHierarchy());
        pe.construct("org.teavm.jso.impl.JSWrapper", pe.var(1, JSMethods.JS_OBJECT)).returnValue();
        cls.addMethod(method);
    }

    private void transformIsJava(MethodHolder method, ClassHolderTransformerContext context) {
        method.getModifiers().remove((Object)ElementModifier.NATIVE);
        ProgramEmitter pe = ProgramEmitter.create(method, context.getHierarchy());
        pe.constant(1).returnValue();
    }
}

