/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationUtil;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.jso.impl.wasmgc.WasmGCJsoCommonGenerator;
import org.teavm.jso.impl.wasmgc.WasmGCJsoContext;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

class WasmGCJSRuntimeIntrinsic
implements WasmGCIntrinsic {
    private WasmGCJsoCommonGenerator commonGen;

    WasmGCJSRuntimeIntrinsic(WasmGCJsoCommonGenerator commonGen) {
        this.commonGen = commonGen;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "wrapObject": {
                WasmGCJsoContext jsoContext = WasmGCJsoContext.wrap(context);
                WasmGlobal wrapperClass = this.commonGen.getDefaultWrapperClass(jsoContext);
                WasmFunction wrapperFunction = this.commonGen.javaObjectToJSFunction(jsoContext);
                return new WasmCall(wrapperFunction, context.generate(invocation.getArguments().get(0)), new WasmGetGlobal(wrapperClass));
            }
            case "of": {
                WasmGCClassInfo stringCls = context.classInfoProvider().getClassInfo("java.lang.String");
                int fieldIndex = context.classInfoProvider().getFieldIndex(new FieldReference("java.lang.String", "characters"));
                WasmExpression arg = context.generate(invocation.getArguments().get(0));
                WasmStructGet stringField = new WasmStructGet(stringCls.getStructure(), arg, fieldIndex);
                WasmGCClassInfo arrayCls = context.classInfoProvider().getClassInfo(ValueType.arrayOf(ValueType.CHARACTER));
                return new WasmStructGet(arrayCls.getStructure(), stringField, 2);
            }
            case "asString": {
                WasmGCGenerationUtil genUtil = new WasmGCGenerationUtil(context.classInfoProvider());
                WasmGCClassInfo arrayCls = context.classInfoProvider().getClassInfo(ValueType.arrayOf(ValueType.CHARACTER));
                WasmField field = arrayCls.getStructure().getFields().get(2);
                WasmExpression array = genUtil.allocateArray(ValueType.CHARACTER, arrayType -> new WasmCast(context.generate(invocation.getArguments().get(0)), (WasmType.Reference)field.getType().asUnpackedType()));
                WasmFunction fn = context.functions().forStaticMethod(new MethodReference(String.class, "fromArray", char[].class, String.class));
                return new WasmCall(fn, array);
            }
            case "create": {
                WasmGCClassInfo arrayCls = context.classInfoProvider().getClassInfo(ValueType.arrayOf(ValueType.CHARACTER));
                WasmField field = arrayCls.getStructure().getFields().get(2);
                WasmType.CompositeReference type = (WasmType.CompositeReference)field.getType().asUnpackedType();
                WasmArray array = (WasmArray)type.composite;
                return new WasmArrayNewDefault(array, context.generate(invocation.getArguments().get(0)));
            }
            case "toNullable": {
                return context.generate(invocation.getArguments().get(0));
            }
            case "put": {
                WasmGCClassInfo arrayCls = context.classInfoProvider().getClassInfo(ValueType.arrayOf(ValueType.CHARACTER));
                WasmField field = arrayCls.getStructure().getFields().get(2);
                WasmType.CompositeReference type = (WasmType.CompositeReference)field.getType().asUnpackedType();
                WasmArray array = (WasmArray)type.composite;
                return new WasmArraySet(array, context.generate(invocation.getArguments().get(0)), context.generate(invocation.getArguments().get(1)), context.generate(invocation.getArguments().get(2)));
            }
        }
        throw new IllegalArgumentException();
    }
}

