/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.HashSet;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSMethods;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.rhino.javascript.ast.AstNode;
import org.teavm.rhino.javascript.ast.FunctionCall;
import org.teavm.rhino.javascript.ast.InfixExpression;
import org.teavm.rhino.javascript.ast.Name;
import org.teavm.rhino.javascript.ast.NodeVisitor;
import org.teavm.rhino.javascript.ast.PropertyGet;
import org.teavm.rhino.javascript.ast.StringLiteral;

class JavaInvocationProcessor
implements NodeVisitor {
    private ClassReaderSource classSource;
    private JSTypeHelper typeHelper;
    private JSBodyRepository repository;
    private Diagnostics diagnostics;
    private CallLocation location;
    private int idGenerator;

    public JavaInvocationProcessor(JSTypeHelper typeHelper, JSBodyRepository repository, ClassReaderSource classSource, Diagnostics diagnostics) {
        this.typeHelper = typeHelper;
        this.repository = repository;
        this.classSource = classSource;
        this.diagnostics = diagnostics;
    }

    public void process(CallLocation location, AstNode root) {
        this.location = location;
        root.visit(this);
    }

    @Override
    public boolean visit(AstNode node) {
        if (node instanceof FunctionCall) {
            return this.visit((FunctionCall)node);
        }
        return true;
    }

    private boolean visit(FunctionCall call) {
        if (!(call.getTarget() instanceof PropertyGet)) {
            return true;
        }
        PropertyGet propertyGet = (PropertyGet)call.getTarget();
        MethodReference methodRef = this.getJavaMethodSelector(propertyGet.getTarget());
        if (methodRef == null || !propertyGet.getProperty().getIdentifier().equals("invoke")) {
            return true;
        }
        for (AstNode arg : call.getArguments()) {
            arg.visit(this);
        }
        MethodReader method = this.classSource.resolve(methodRef);
        if (method == null) {
            this.diagnostics.error(this.location, "Java method not found: {{m0}}", methodRef);
            return false;
        }
        int requiredParams = methodRef.parameterCount();
        if (!method.hasModifier(ElementModifier.STATIC)) {
            ++requiredParams;
        }
        if (call.getArguments().size() != requiredParams) {
            this.diagnostics.error(this.location, "Invalid number of arguments for method {{m0}}. Expected: " + requiredParams + ", encountered: " + call.getArguments().size(), methodRef);
        }
        MethodReference caller = this.createCallbackMethod(method);
        MethodReference delegate = this.repository.methodMap.get(this.location.getMethod());
        this.repository.callbackCallees.put(caller, methodRef);
        this.repository.callbackMethods.computeIfAbsent(delegate, key -> new HashSet()).add(caller);
        this.validateSignature(method);
        StringLiteral newTarget = new StringLiteral();
        newTarget.setValue("$$JSO$$_" + String.valueOf(caller));
        propertyGet.setTarget(newTarget);
        return false;
    }

    private void validateSignature(MethodReader method) {
        if (!method.hasModifier(ElementModifier.STATIC) && !this.typeHelper.isJavaScriptClass(method.getOwnerName())) {
            this.diagnostics.error(this.location, "Can't call method {{m0}} of non-JS class", method.getReference());
        }
    }

    private MethodReference createCallbackMethod(MethodReader method) {
        int paramCount = method.parameterCount();
        if (!method.hasModifier(ElementModifier.STATIC)) {
            ++paramCount;
        }
        ValueType[] signature = new ValueType[paramCount + 1];
        for (int i = 0; i < paramCount; ++i) {
            signature[i] = JSMethods.JS_OBJECT;
        }
        signature[paramCount] = method.getResultType() == ValueType.VOID ? ValueType.VOID : JSMethods.JS_OBJECT;
        return new MethodReference(this.location.getMethod().getClassName(), method.getName() + "$jsocb$_" + this.idGenerator++, signature);
    }

    private MethodReference getJavaMethodSelector(AstNode node) {
        if (!(node instanceof FunctionCall)) {
            return null;
        }
        FunctionCall call = (FunctionCall)node;
        if (!this.isJavaMethodRepository(call.getTarget())) {
            return null;
        }
        if (call.getArguments().size() != 1) {
            this.diagnostics.error(this.location, "javaMethods.get method should take exactly one argument", new Object[0]);
            return null;
        }
        StringBuilder nameBuilder = new StringBuilder();
        if (!this.extractMethodName(call.getArguments().get(0), nameBuilder)) {
            this.diagnostics.error(this.location, "javaMethods.get method should take string constant", new Object[0]);
            return null;
        }
        MethodReference method = MethodReference.parseIfPossible(nameBuilder.toString());
        if (method == null) {
            this.diagnostics.error(this.location, "Wrong method reference: " + String.valueOf(nameBuilder), new Object[0]);
        }
        return method;
    }

    private boolean extractMethodName(AstNode node, StringBuilder sb) {
        if (node.getType() == 21) {
            InfixExpression infix = (InfixExpression)node;
            return this.extractMethodName(infix.getLeft(), sb) && this.extractMethodName(infix.getRight(), sb);
        }
        if (node.getType() == 41) {
            sb.append(((StringLiteral)node).getValue());
            return true;
        }
        return false;
    }

    private boolean isJavaMethodRepository(AstNode node) {
        if (!(node instanceof PropertyGet)) {
            return false;
        }
        PropertyGet propertyGet = (PropertyGet)node;
        if (!(propertyGet.getLeft() instanceof Name)) {
            return false;
        }
        if (!((Name)propertyGet.getTarget()).getIdentifier().equals("javaMethods")) {
            return false;
        }
        return propertyGet.getProperty().getIdentifier().equals("get");
    }
}

