/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.Arrays;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.jso.JSIndexer;
import org.teavm.jso.JSMethod;
import org.teavm.jso.JSProperty;
import org.teavm.jso.impl.JSAnnotationCache;
import org.teavm.jso.impl.JSImportDescriptor;
import org.teavm.jso.impl.JSImportKind;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReader;

class JSImportAnnotationCache
extends JSAnnotationCache<JSImportDescriptor> {
    JSImportAnnotationCache(ClassReaderSource classes, Diagnostics diagnostics) {
        super(classes, diagnostics);
    }

    @Override
    protected JSImportDescriptor take(MethodReader method, CallLocation location) {
        AnnotationReader propertyAnnot = method.getAnnotations().get(JSProperty.class.getName());
        AnnotationReader indexerAnnot = method.getAnnotations().get(JSIndexer.class.getName());
        AnnotationReader methodAnnot = method.getAnnotations().get(JSMethod.class.getName());
        boolean found = false;
        for (AnnotationReader annot : Arrays.asList(propertyAnnot, indexerAnnot, methodAnnot)) {
            if (annot == null) continue;
            if (!found) {
                found = true;
                continue;
            }
            this.diagnostics.error(location, "@JSProperty, @JSIndexer and @JSMethod are mutually exclusive and can't appear simultaneously on {{m}}", method.getReference());
            return null;
        }
        if (propertyAnnot != null) {
            return new JSImportDescriptor(JSImportKind.PROPERTY, this.extractValue(propertyAnnot));
        }
        if (indexerAnnot != null) {
            return new JSImportDescriptor(JSImportKind.INDEXER, null);
        }
        if (methodAnnot != null) {
            return new JSImportDescriptor(JSImportKind.METHOD, this.extractValue(methodAnnot));
        }
        return null;
    }

    private String extractValue(AnnotationReader annotation) {
        AnnotationValue value = annotation.getValue("value");
        return value != null ? value.getString() : null;
    }
}

