/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.classlib.PlatformDetector;
import org.teavm.dependency.PluggableDependency;
import org.teavm.interop.Address;
import org.teavm.interop.Import;
import org.teavm.interop.NoSideEffects;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSObject;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.core.JSArrayReader;
import org.teavm.jso.core.JSBigInt;
import org.teavm.jso.core.JSBoolean;
import org.teavm.jso.core.JSNumber;
import org.teavm.jso.core.JSString;
import org.teavm.jso.impl.JSNativeGenerator;
import org.teavm.jso.impl.JSNativeInjector;
import org.teavm.jso.impl.WasmBufferUtil;
import org.teavm.jso.typedarrays.BigInt64Array;
import org.teavm.jso.typedarrays.Float32Array;
import org.teavm.jso.typedarrays.Float64Array;
import org.teavm.jso.typedarrays.Int16Array;
import org.teavm.jso.typedarrays.Int32Array;
import org.teavm.jso.typedarrays.Int8Array;
import org.teavm.jso.typedarrays.Uint16Array;

public final class JS {
    private JS() {
    }

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    public static native JSObject arrayData(Object var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="concatArray", module="teavmJso")
    public static native JSObject concatArray(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @PluggableDependency(value=JSNativeInjector.class)
    public static native byte[] dataToByteArray(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @PluggableDependency(value=JSNativeInjector.class)
    public static native char[] dataToCharArray(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @PluggableDependency(value=JSNativeInjector.class)
    public static native short[] dataToShortArray(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @PluggableDependency(value=JSNativeInjector.class)
    public static native int[] dataToIntArray(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @PluggableDependency(value=JSNativeInjector.class)
    public static native long[] dataToLongArray(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @PluggableDependency(value=JSNativeInjector.class)
    public static native float[] dataToFloatArray(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @PluggableDependency(value=JSNativeInjector.class)
    public static native double[] dataToDoubleArray(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject[] dataToArray(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="wrapByte", module="teavmJso")
    public static native JSObject wrap(byte var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="wrapShort", module="teavmJso")
    public static native JSObject wrap(short var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="wrapInt", module="teavmJso")
    public static native JSObject wrap(int var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="wrapLong", module="teavmJso")
    public static native JSObject wrap(long var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="wrapChar", module="teavmJso")
    public static native JSObject wrap(char var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="wrapFloat", module="teavmJso")
    public static native JSObject wrap(float var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="wrapDouble", module="teavmJso")
    public static native JSObject wrap(double var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="wrapBoolean", module="teavmJso")
    public static native JSObject wrap(boolean var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    public static native JSObject wrap(String var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="unwrapByte", module="teavmJso")
    public static native byte unwrapByte(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="unwrapChar", module="teavmJso")
    public static native char unwrapCharacter(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="unwrapShort", module="teavmJso")
    public static native short unwrapShort(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="unwrapInt", module="teavmJso")
    public static native int unwrapInt(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="unwrapLong", module="teavmJso")
    public static native long unwrapLong(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="unwrapFloat", module="teavmJso")
    public static native float unwrapFloat(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="unwrapDouble", module="teavmJso")
    public static native double unwrapDouble(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="unwrapBoolean", module="teavmJso")
    public static native boolean unwrapBoolean(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @PluggableDependency(value=JSNativeInjector.class)
    public static native String unwrapString(JSObject var0);

    public static <T extends JSObject> JSObject wrap(T[] array) {
        if (array == null) {
            return null;
        }
        JSArray<T> result = new JSArray<T>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    public static <T> JSObject wrap(T[] array) {
        if (array == null) {
            return null;
        }
        JSArray<T> result = new JSArray<T>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    public static <T extends JSObject> WrapFunction<T[], JSObject> arrayWrapper() {
        return (WrapFunction<JSObject[], JSObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Lorg/teavm/jso/JSObject;, wrap(org.teavm.jso.JSObject[] ), ([Lorg/teavm/jso/JSObject;)Lorg/teavm/jso/JSObject;)();
    }

    public static <T extends JSObject, S> JSObject map(S[] array, WrapFunction<S, T> f) {
        if (array == null) {
            return null;
        }
        JSArray<T> result = new JSArray<T>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, f.apply(array[i]));
        }
        return result;
    }

    public static <T extends JSObject, S> WrapFunction<S[], JSObject> arrayMapper(WrapFunction<S, T> f) {
        return array -> JS.map(array, f);
    }

    public static JSObject wrap(boolean[] array) {
        if (array == null) {
            return null;
        }
        JSArray<JSBoolean> result = new JSArray<JSBoolean>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JSBoolean.valueOf(array[i]));
        }
        return result;
    }

    public static WrapFunction<boolean[], JSObject> booleanArrayWrapper() {
        return JS::wrap;
    }

    public static JSObject wrap(byte[] array) {
        if (array == null) {
            return null;
        }
        Int8Array result = new Int8Array(array.length);
        if (PlatformDetector.isWebAssemblyGC()) {
            for (int i = 0; i < array.length; i += 4096) {
                int upper = Math.min(array.length, i + 4096);
                int sz = upper - i;
                Address ptr = WasmBufferUtil.buffer;
                for (int j = 0; j < sz; ++j) {
                    ptr.putByte(array[i + j]);
                    ptr = ptr.add(1);
                }
                Int8Array dest = new Int8Array(result.getBuffer(), result.getByteOffset() + i, sz);
                Int8Array src = new Int8Array(WasmBufferUtil.getLinearMemory(), WasmBufferUtil.buffer.toInt(), sz);
                dest.set(src);
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                result.set(i, array[i]);
            }
        }
        return result;
    }

    public static WrapFunction<byte[], JSObject> byteArrayWrapper() {
        return JS::wrap;
    }

    public static JSObject wrap(short[] array) {
        if (array == null) {
            return null;
        }
        Int16Array result = new Int16Array(array.length);
        if (PlatformDetector.isWebAssemblyGC()) {
            int count = 2048;
            for (int i = 0; i < array.length; i += count) {
                int upper = Math.min(array.length, i + count);
                int sz = upper - i;
                Address ptr = WasmBufferUtil.buffer;
                for (int j = 0; j < sz; ++j) {
                    ptr.putShort(array[i + j]);
                    ptr = ptr.add(2);
                }
                Int16Array dest = new Int16Array(result.getBuffer(), result.getByteOffset() + i * 2, sz);
                Int16Array src = new Int16Array(WasmBufferUtil.getLinearMemory(), WasmBufferUtil.buffer.toInt(), sz);
                dest.set(src);
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                result.set(i, array[i]);
            }
        }
        return result;
    }

    public static WrapFunction<short[], JSObject> shortArrayWrapper() {
        return JS::wrap;
    }

    public static JSObject wrap(char[] array) {
        if (array == null) {
            return null;
        }
        Uint16Array result = new Uint16Array(array.length);
        if (PlatformDetector.isWebAssemblyGC()) {
            int count = 2048;
            for (int i = 0; i < array.length; i += count) {
                int upper = Math.min(array.length, i + count);
                int sz = upper - i;
                Address ptr = WasmBufferUtil.buffer;
                for (int j = 0; j < sz; ++j) {
                    ptr.putChar(array[i + j]);
                    ptr = ptr.add(2);
                }
                Uint16Array dest = new Uint16Array(result.getBuffer(), result.getByteOffset() + i * 2, sz);
                Uint16Array src = new Uint16Array(WasmBufferUtil.getLinearMemory(), WasmBufferUtil.buffer.toInt(), sz);
                dest.set(src);
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                result.set(i, (int)array[i]);
            }
        }
        return result;
    }

    public static WrapFunction<char[], JSObject> charArrayWrapper() {
        return JS::wrap;
    }

    public static JSObject wrap(int[] array) {
        if (array == null) {
            return null;
        }
        Int32Array result = new Int32Array(array.length);
        if (PlatformDetector.isWebAssemblyGC()) {
            int count = 1024;
            for (int i = 0; i < array.length; i += count) {
                int upper = Math.min(array.length, i + count);
                int sz = upper - i;
                Address ptr = WasmBufferUtil.buffer;
                for (int j = 0; j < sz; ++j) {
                    ptr.putInt(array[i + j]);
                    ptr = ptr.add(4);
                }
                Int32Array dest = new Int32Array(result.getBuffer(), result.getByteOffset() + i * 4, sz);
                Int32Array src = new Int32Array(WasmBufferUtil.getLinearMemory(), WasmBufferUtil.buffer.toInt(), sz);
                dest.set(src);
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                result.set(i, array[i]);
            }
        }
        return result;
    }

    public static WrapFunction<int[], JSObject> intArrayWrapper() {
        return JS::wrap;
    }

    public static JSObject wrap(long[] array) {
        if (array == null) {
            return null;
        }
        BigInt64Array result = new BigInt64Array(array.length);
        if (PlatformDetector.isWebAssemblyGC()) {
            int count = 512;
            for (int i = 0; i < array.length; i += count) {
                int upper = Math.min(array.length, i + count);
                int sz = upper - i;
                Address ptr = WasmBufferUtil.buffer;
                for (int j = 0; j < sz; ++j) {
                    ptr.putLong(array[i + j]);
                    ptr = ptr.add(8);
                }
                BigInt64Array dest = new BigInt64Array(result.getBuffer(), result.getByteOffset() + i * 8, sz);
                BigInt64Array src = new BigInt64Array(WasmBufferUtil.getLinearMemory(), WasmBufferUtil.buffer.toInt(), sz);
                dest.set(src);
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                result.set(i, array[i]);
            }
        }
        return result;
    }

    public static WrapFunction<long[], JSObject> longArrayWrapper() {
        return JS::wrap;
    }

    @NoSideEffects
    public static JSObject wrap(String[] array) {
        if (array == null) {
            return null;
        }
        JSArray<JSString> result = new JSArray<JSString>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JSString.valueOf(array[i]));
        }
        return result;
    }

    public static WrapFunction<String[], JSObject> stringArrayWrapper() {
        return JS::wrap;
    }

    public static JSObject wrap(float[] array) {
        if (array == null) {
            return null;
        }
        Float32Array result = new Float32Array(array.length);
        if (PlatformDetector.isWebAssemblyGC()) {
            int count = 1024;
            for (int i = 0; i < array.length; i += count) {
                int upper = Math.min(array.length, i + count);
                int sz = upper - i;
                Address ptr = WasmBufferUtil.buffer;
                for (int j = 0; j < sz; ++j) {
                    ptr.putFloat(array[i + j]);
                    ptr = ptr.add(4);
                }
                Float32Array dest = new Float32Array(result.getBuffer(), result.getByteOffset() + i * 4, sz);
                Float32Array src = new Float32Array(WasmBufferUtil.getLinearMemory(), WasmBufferUtil.buffer.toInt(), sz);
                dest.set(src);
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                result.set(i, array[i]);
            }
        }
        return result;
    }

    public static WrapFunction<float[], JSObject> floatArrayWrapper() {
        return JS::wrap;
    }

    public static JSObject wrap(double[] array) {
        if (array == null) {
            return null;
        }
        Float64Array result = new Float64Array(array.length);
        if (PlatformDetector.isWebAssemblyGC()) {
            int count = 512;
            for (int i = 0; i < array.length; i += count) {
                int upper = Math.min(array.length, i + count);
                int sz = upper - i;
                Address ptr = WasmBufferUtil.buffer;
                for (int j = 0; j < sz; ++j) {
                    ptr.putDouble(array[i + j]);
                    ptr = ptr.add(8);
                }
                Float64Array dest = new Float64Array(result.getBuffer(), result.getByteOffset() + i * 8, sz);
                Float64Array src = new Float64Array(WasmBufferUtil.getLinearMemory(), WasmBufferUtil.buffer.toInt(), sz);
                dest.set(src);
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                result.set(i, array[i]);
            }
        }
        return result;
    }

    public static WrapFunction<double[], JSObject> doubleArrayWrapper() {
        return JS::wrap;
    }

    public static <T extends JSObject> T[] unwrapArray(Class<T> type, JSArrayReader<T> array) {
        if (array == null) {
            return null;
        }
        JSObject[] result = (JSObject[])Array.newInstance(type, array.getLength());
        for (int i = 0; i < result.length; ++i) {
            result[i] = (JSObject)array.get(i);
        }
        return result;
    }

    public static <T extends JSObject> UnwrapFunction<JSArrayReader<T>, T[]> arrayUnwrapper(Class<T> type) {
        return array -> JS.unwrapArray((Class)type, (JSArrayReader)array);
    }

    public static <S extends JSObject, T> T[] unmapArray(Class<T> type, JSArrayReader<S> array, UnwrapFunction<S, T> f) {
        if (array == null) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(type, array.getLength());
        for (int i = 0; i < result.length; ++i) {
            result[i] = f.apply((JSObject)array.get(i));
        }
        return result;
    }

    public static <T, S extends JSObject> UnwrapFunction<JSArray<S>, T[]> arrayUnmapper(Class<T> type, UnwrapFunction<S, T> f) {
        return array -> JS.unmapArray(type, array, f);
    }

    public static boolean[] unwrapBooleanArray(JSArrayReader<JSBoolean> array) {
        if (array == null) {
            return null;
        }
        boolean[] result = new boolean[array.getLength()];
        if (PlatformDetector.isWebAssemblyGC() && array instanceof Int8Array) {
            Int8Array typedArray = (Int8Array)((Object)array);
            for (int i = 0; i < result.length; i += 4096) {
                int upper = Math.min(i + 4096, result.length);
                int sz = upper - i;
                Int8Array part = new Int8Array(typedArray.getBuffer(), typedArray.getByteOffset() + i, sz);
                Address ptr = WasmBufferUtil.buffer;
                new Int8Array(WasmBufferUtil.getLinearMemory(), ptr.toInt(), upper - i).set(part);
                for (int j = 0; j < sz; ++j) {
                    result[i + j] = ptr.getByte() != 0;
                    ptr = ptr.add(1);
                }
            }
            return result;
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).booleanValue();
        }
        return result;
    }

    public static UnwrapFunction<JSArrayReader<JSBoolean>, boolean[]> booleanArrayUnwrapper() {
        return JS::unwrapBooleanArray;
    }

    public static byte[] unwrapByteArray(JSArrayReader<JSNumber> array) {
        if (array == null) {
            return null;
        }
        byte[] result = new byte[array.getLength()];
        if (PlatformDetector.isWebAssemblyGC() && array instanceof Int8Array) {
            Int8Array typedArray = (Int8Array)((Object)array);
            for (int i = 0; i < result.length; i += 4096) {
                int upper = Math.min(i + 4096, result.length);
                int sz = upper - i;
                Int8Array part = new Int8Array(typedArray.getBuffer(), typedArray.getByteOffset() + i, sz);
                Address ptr = WasmBufferUtil.buffer;
                new Int8Array(WasmBufferUtil.getLinearMemory(), ptr.toInt(), upper - i).set(part);
                for (int j = 0; j < sz; ++j) {
                    result[i + j] = ptr.getByte();
                    ptr = ptr.add(1);
                }
            }
            return result;
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).byteValue();
        }
        return result;
    }

    public static UnwrapFunction<JSArrayReader<JSNumber>, byte[]> byteArrayUnwrapper() {
        return JS::unwrapByteArray;
    }

    public static short[] unwrapShortArray(JSArrayReader<JSNumber> array) {
        if (array == null) {
            return null;
        }
        short[] result = new short[array.getLength()];
        if (PlatformDetector.isWebAssemblyGC() && array instanceof Int16Array) {
            Int16Array typedArray = (Int16Array)((Object)array);
            int elemCount = 2048;
            for (int i = 0; i < result.length; i += elemCount) {
                int upper = Math.min(i + elemCount, result.length);
                int sz = upper - i;
                Int16Array part = new Int16Array(typedArray.getBuffer(), typedArray.getByteOffset() + i * 2, sz);
                Address ptr = WasmBufferUtil.buffer;
                new Int16Array(WasmBufferUtil.getLinearMemory(), ptr.toInt(), upper - i).set(part);
                for (int j = 0; j < sz; ++j) {
                    result[i + j] = ptr.getShort();
                    ptr = ptr.add(2);
                }
            }
            return result;
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).shortValue();
        }
        return result;
    }

    public static UnwrapFunction<JSArrayReader<JSNumber>, short[]> shortArrayUnwrapper() {
        return JS::unwrapShortArray;
    }

    public static int[] unwrapIntArray(JSArrayReader<JSNumber> array) {
        if (array == null) {
            return null;
        }
        int[] result = new int[array.getLength()];
        if (PlatformDetector.isWebAssemblyGC() && array instanceof Int32Array) {
            Int32Array typedArray = (Int32Array)((Object)array);
            int elemCount = 1024;
            for (int i = 0; i < result.length; i += elemCount) {
                int upper = Math.min(i + elemCount, result.length);
                int sz = upper - i;
                Int32Array part = new Int32Array(typedArray.getBuffer(), typedArray.getByteOffset() + i * 4, sz);
                Address ptr = WasmBufferUtil.buffer;
                new Int32Array(WasmBufferUtil.getLinearMemory(), ptr.toInt(), upper - i).set(part);
                for (int j = 0; j < sz; ++j) {
                    result[i + j] = ptr.getInt();
                    ptr = ptr.add(4);
                }
            }
            return result;
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).intValue();
        }
        return result;
    }

    public static UnwrapFunction<JSArrayReader<JSNumber>, int[]> intArrayUnwrapper() {
        return JS::unwrapIntArray;
    }

    public static long[] unwrapLongArray(JSArrayReader<JSBigInt> array) {
        if (array == null) {
            return null;
        }
        long[] result = new long[array.getLength()];
        if (PlatformDetector.isWebAssemblyGC() && array instanceof BigInt64Array) {
            BigInt64Array typedArray = (BigInt64Array)((Object)array);
            int elemCount = 512;
            for (int i = 0; i < result.length; i += elemCount) {
                int upper = Math.min(i + elemCount, result.length);
                int sz = upper - i;
                BigInt64Array part = new BigInt64Array(typedArray.getBuffer(), typedArray.getByteOffset() + i * 8, sz);
                Address ptr = WasmBufferUtil.buffer;
                new BigInt64Array(WasmBufferUtil.getLinearMemory(), ptr.toInt(), upper - i).set(part);
                for (int j = 0; j < sz; ++j) {
                    result[i + j] = ptr.getLong();
                    ptr = ptr.add(8);
                }
            }
            return result;
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).longValue();
        }
        return result;
    }

    public static UnwrapFunction<JSArrayReader<JSBigInt>, long[]> longArrayUnwrapper() {
        return JS::unwrapLongArray;
    }

    public static char[] unwrapCharArray(JSArrayReader<JSNumber> array) {
        if (array == null) {
            return null;
        }
        char[] result = new char[array.getLength()];
        if (PlatformDetector.isWebAssemblyGC() && array instanceof Uint16Array) {
            Uint16Array typedArray = (Uint16Array)((Object)array);
            int elemCount = 2048;
            for (int i = 0; i < result.length; i += elemCount) {
                int upper = Math.min(i + elemCount, result.length);
                int sz = upper - i;
                Uint16Array part = new Uint16Array(typedArray.getBuffer(), typedArray.getByteOffset() + i * 2, sz);
                Address ptr = WasmBufferUtil.buffer;
                new Uint16Array(WasmBufferUtil.getLinearMemory(), ptr.toInt(), upper - i).set(part);
                for (int j = 0; j < sz; ++j) {
                    result[i + j] = ptr.getChar();
                    ptr = ptr.add(2);
                }
            }
            return result;
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).charValue();
        }
        return result;
    }

    public static UnwrapFunction<JSArrayReader<JSNumber>, char[]> charArrayUnwrapper() {
        return JS::unwrapCharArray;
    }

    public static float[] unwrapFloatArray(JSArrayReader<JSNumber> array) {
        if (array == null) {
            return null;
        }
        float[] result = new float[array.getLength()];
        if (PlatformDetector.isWebAssemblyGC() && array instanceof Float32Array) {
            Float32Array typedArray = (Float32Array)((Object)array);
            int elemCount = 1024;
            for (int i = 0; i < result.length; i += elemCount) {
                int upper = Math.min(i + elemCount, result.length);
                int sz = upper - i;
                Float32Array part = new Float32Array(typedArray.getBuffer(), typedArray.getByteOffset() + i * 4, sz);
                Address ptr = WasmBufferUtil.buffer;
                new Float32Array(WasmBufferUtil.getLinearMemory(), ptr.toInt(), upper - i).set(part);
                for (int j = 0; j < sz; ++j) {
                    result[i + j] = ptr.getFloat();
                    ptr = ptr.add(4);
                }
            }
            return result;
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).floatValue();
        }
        return result;
    }

    public static UnwrapFunction<JSArrayReader<JSNumber>, float[]> floatArrayUnwrapper() {
        return JS::unwrapFloatArray;
    }

    public static double[] unwrapDoubleArray(JSArrayReader<JSNumber> array) {
        if (array == null) {
            return null;
        }
        double[] result = new double[array.getLength()];
        if (PlatformDetector.isWebAssemblyGC() && array instanceof Float64Array) {
            Float64Array typedArray = (Float64Array)((Object)array);
            int elemCount = 512;
            for (int i = 0; i < result.length; i += elemCount) {
                int upper = Math.min(i + elemCount, result.length);
                int sz = upper - i;
                Float64Array part = new Float64Array(typedArray.getBuffer(), typedArray.getByteOffset() + i * 8, sz);
                Address ptr = WasmBufferUtil.buffer;
                new Float64Array(WasmBufferUtil.getLinearMemory(), ptr.toInt(), upper - i).set(part);
                for (int j = 0; j < sz; ++j) {
                    result[i + j] = ptr.getDouble();
                    ptr = ptr.add(8);
                }
            }
            return result;
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).doubleValue();
        }
        return result;
    }

    public static UnwrapFunction<JSArrayReader<JSNumber>, double[]> doubleArrayUnwrapper() {
        return JS::unwrapDoubleArray;
    }

    public static String[] unwrapStringArray(JSArrayReader<JSString> array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.getLength()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).stringValue();
        }
        return result;
    }

    public static UnwrapFunction<JSArrayReader<JSString>, String[]> stringArrayUnwrapper() {
        return JS::unwrapStringArray;
    }

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod0", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod1", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod2", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod3", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod4", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod5", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod6", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod7", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod8", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod9", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod10", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod11", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11, JSObject var12);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod12", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11, JSObject var12, JSObject var13);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="callMethod13", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11, JSObject var12, JSObject var13, JSObject var14);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="apply", module="teavmJso")
    public static native JSObject apply(JSObject var0, JSObject var1, JSArray<JSObject> var2);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf1", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf2", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf3", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1, JSObject var2);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf4", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1, JSObject var2, JSObject var3);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf5", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf6", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf7", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf8", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="arrayOf9", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf10", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf11", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf12", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="arrayOf13", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject arrayOf(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11, JSObject var12);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct0", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct1", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct2", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct3", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2, JSObject var3);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct4", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct5", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct6", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct7", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct8", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct9", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct10", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct11", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct12", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11, JSObject var12);

    @InjectedBy(value=JSNativeInjector.class)
    @Import(name="construct13", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject construct(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11, JSObject var12, JSObject var13);

    @InjectedBy(value=JSNativeInjector.class)
    @JSBody(params={"instance", "index"}, script="return instance[index];")
    public static native JSObject get(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @JSBody(params={"instance", "index"}, script="return instance[index];")
    @NoSideEffects
    public static native JSObject getPure(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @JSBody(params={"instance", "index", "obj"}, script="instance[index] = obj;")
    @Import(name="setProperty", module="teavmJso")
    public static native void set(JSObject var0, JSObject var1, JSObject var2);

    @InjectedBy(value=JSNativeInjector.class)
    @JSBody(params={"instance", "index", "obj"}, script="instance[index] = obj;")
    @NoSideEffects
    @Import(name="setPropertyPure", module="teavmJso")
    public static native void setPure(JSObject var0, JSObject var1, JSObject var2);

    @GeneratedBy(value=JSNativeGenerator.class)
    @Import(name="asFunction", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject function(JSObject var0, JSObject var1);

    @GeneratedBy(value=JSNativeGenerator.class)
    @Import(name="functionAsObject", module="teavmJso")
    @PluggableDependency(value=JSNativeInjector.class)
    public static native JSObject functionAsObject(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    public static native JSObject global(String var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    public static native JSObject importModule(String var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="instanceOf", module="teavmJso")
    public static native boolean instanceOf(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="instanceOfOrNull", module="teavmJso")
    public static native boolean instanceOfOrNull(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="isPrimitive", module="teavmJso")
    public static native boolean isPrimitive(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    public static native JSObject throwCCEIfFalse(boolean var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    public static native JSObject argumentsBeginningAt(int var0);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    @Import(name="sameRef", module="teavmJso")
    public static native boolean sameRef(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeInjector.class)
    @NoSideEffects
    public static native boolean isNull(JSObject var0);

    @NoSideEffects
    public static native Object jsArrayItem(Object var0, int var1);

    public static interface WrapFunction<S, T extends JSObject> {
        public T apply(S var1);
    }

    public static interface UnwrapFunction<S extends JSObject, T> {
        public T apply(S var1);
    }
}

