/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.teavm.jso.impl.JSConstructorToExpose;
import org.teavm.jso.impl.JSGetterToExpose;
import org.teavm.jso.impl.JSInstanceExpose;
import org.teavm.jso.impl.JSMethodToExpose;
import org.teavm.jso.impl.JSSetterToExpose;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

public class AliasCollector {
    private AliasCollector() {
    }

    public static boolean isStaticMember(MethodReader method) {
        return !AliasCollector.isInstanceMember(method);
    }

    public static boolean isInstanceMember(MethodReader method) {
        return method.getAnnotations().get(JSInstanceExpose.class.getName()) != null;
    }

    public static Members collectMembers(ClassReader classReader, Predicate<MethodReader> filter) {
        HashMap<String, MethodReference> methods = new HashMap<String, MethodReference>();
        HashMap<String, PropertyInfo> properties = new HashMap<String, PropertyInfo>();
        MethodReference constructor = null;
        for (MethodReader methodReader : classReader.getMethods()) {
            Alias methodAlias;
            if (!filter.test(methodReader) || (methodAlias = AliasCollector.getPublicAlias(methodReader)) == null) continue;
            switch (methodAlias.kind.ordinal()) {
                case 0: {
                    methods.put(methodAlias.name, methodReader.getReference());
                    break;
                }
                case 1: {
                    PropertyInfo propInfo = properties.computeIfAbsent(methodAlias.name, k -> new PropertyInfo());
                    propInfo.getter = methodReader.getReference();
                    break;
                }
                case 2: {
                    PropertyInfo propInfo = properties.computeIfAbsent(methodAlias.name, k -> new PropertyInfo());
                    propInfo.setter = methodReader.getReference();
                    break;
                }
                case 3: {
                    constructor = methodReader.getReference();
                }
            }
        }
        return new Members(methods, properties, constructor);
    }

    public static Alias getPublicAlias(MethodReader method) {
        AnnotationReader annot = method.getAnnotations().get(JSMethodToExpose.class.getName());
        if (annot != null) {
            return new Alias(annot.getValue("name").getString(), AliasKind.METHOD);
        }
        annot = method.getAnnotations().get(JSGetterToExpose.class.getName());
        if (annot != null) {
            return new Alias(annot.getValue("name").getString(), AliasKind.GETTER);
        }
        annot = method.getAnnotations().get(JSSetterToExpose.class.getName());
        if (annot != null) {
            return new Alias(annot.getValue("name").getString(), AliasKind.SETTER);
        }
        annot = method.getAnnotations().get(JSConstructorToExpose.class.getName());
        if (annot != null) {
            return new Alias(null, AliasKind.CONSTRUCTOR);
        }
        return null;
    }

    public static class Alias {
        public final String name;
        public final AliasKind kind;

        Alias(String name, AliasKind kind) {
            this.name = name;
            this.kind = kind;
        }
    }

    public static enum AliasKind {
        METHOD,
        GETTER,
        SETTER,
        CONSTRUCTOR;

    }

    public static class PropertyInfo {
        public MethodReference getter;
        public MethodReference setter;
    }

    public static class Members {
        public final Map<String, MethodReference> methods;
        public final Map<String, PropertyInfo> properties;
        public final MethodReference constructor;

        Members(Map<String, MethodReference> methods, Map<String, PropertyInfo> properties, MethodReference constructor) {
            this.methods = methods;
            this.properties = properties;
            this.constructor = constructor;
        }
    }
}

