/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.core;

import org.teavm.interop.Async;
import org.teavm.interop.AsyncCallback;
import org.teavm.jso.JSExceptions;
import org.teavm.jso.core.JSError;
import org.teavm.jso.core.JSPromise;

class JSPromiseHelper {
    private JSPromiseHelper() {
    }

    @Async
    static native <T> T await(JSPromise<T> var0);

    static <T> void await(JSPromise<T> promise, AsyncCallback<T> callback) {
        promise.then(result -> {
            callback.complete(result);
            return null;
        }, err -> {
            if (err instanceof Throwable) {
                callback.error((Throwable)err);
            } else if (err instanceof JSError) {
                Throwable javaException = JSExceptions.getJavaException((JSError)err);
                if (javaException != null) {
                    callback.error(javaException);
                } else {
                    callback.error(new RuntimeException());
                }
            } else {
                callback.error(new RuntimeException());
            }
            return null;
        });
    }
}

