/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;
import org.teavm.hppc.AbstractIterator;
import org.teavm.hppc.AbstractObjectCollection;
import org.teavm.hppc.AbstractShortCollection;
import org.teavm.hppc.ObjectCollection;
import org.teavm.hppc.ObjectContainer;
import org.teavm.hppc.ObjectLookupContainer;
import org.teavm.hppc.ObjectShortAssociativeContainer;
import org.teavm.hppc.ObjectShortHashMap;
import org.teavm.hppc.ObjectShortMap;
import org.teavm.hppc.ShortContainer;
import org.teavm.hppc.comparators.ObjectShortComparator;
import org.teavm.hppc.cursors.ObjectCursor;
import org.teavm.hppc.cursors.ObjectShortCursor;
import org.teavm.hppc.cursors.ShortCursor;
import org.teavm.hppc.predicates.ObjectPredicate;
import org.teavm.hppc.predicates.ObjectShortPredicate;
import org.teavm.hppc.predicates.ShortPredicate;
import org.teavm.hppc.procedures.ObjectProcedure;
import org.teavm.hppc.procedures.ObjectShortProcedure;
import org.teavm.hppc.procedures.ShortProcedure;
import org.teavm.hppc.sorting.QuickSort;

public class SortedIterationObjectShortHashMap<KType>
implements ObjectShortMap<KType> {
    public final ObjectShortHashMap<KType> delegate;
    public final int[] iterationOrder;

    public SortedIterationObjectShortHashMap(ObjectShortHashMap<KType> delegate, Comparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationObjectShortHashMap(ObjectShortHashMap<KType> delegate, ObjectShortComparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        Object[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != null) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, Comparator<KType> comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            Object[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ObjectShortComparator<KType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final KType[] keys;
            final short[] values;
            {
                this.keys = SortedIterationObjectShortHashMap.this.delegate.keys;
                this.values = SortedIterationObjectShortHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ObjectShortCursor<KType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(KType key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> container) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectShortPredicate<? super KType> predicate) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public <T extends ObjectShortProcedure<? super KType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        short[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply((Object)keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectShortPredicate<? super KType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        short[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply((Object)keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ObjectCollection<KType> keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ShortContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public short get(KType key) {
        return this.delegate.get(key);
    }

    @Override
    public short getOrDefault(KType key, short defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public short put(KType key, short value) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public int putAll(ObjectShortAssociativeContainer<? extends KType> container) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ObjectShortCursor<? extends KType>> iterable) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public short putOrAdd(KType key, short putValue, short incrementValue) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public short addTo(KType key, short additionValue) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public short remove(KType key) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public int indexOf(KType key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public short indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public short indexReplace(int index, short newValue) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, KType key, short value) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public short indexRemove(int index) {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationObjectShortHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectShortCursor<KType>> {
        private final ObjectShortCursor<KType> cursor = new ObjectShortCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ObjectShortCursor<KType> fetch() {
            if (this.index < SortedIterationObjectShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectShortHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationObjectShortHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationObjectShortHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectShortCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final SortedIterationObjectShortHashMap<KType> owner;

        private KeysContainer() {
            this.owner = SortedIterationObjectShortHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectShortHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            throw SortedIterationObjectShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(KType e) {
            throw SortedIterationObjectShortHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final SortedIterationObjectShortHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationObjectShortHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(short value) {
            for (ObjectShortCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationObjectShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationObjectShortHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectShortHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectShortHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationObjectShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectShortHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectShortHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.index < SortedIterationObjectShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectShortHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectShortHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

