/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;
import org.teavm.hppc.AbstractIntCollection;
import org.teavm.hppc.AbstractIterator;
import org.teavm.hppc.AbstractObjectCollection;
import org.teavm.hppc.IntContainer;
import org.teavm.hppc.ObjectCollection;
import org.teavm.hppc.ObjectContainer;
import org.teavm.hppc.ObjectIntAssociativeContainer;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.hppc.ObjectLookupContainer;
import org.teavm.hppc.comparators.ObjectIntComparator;
import org.teavm.hppc.cursors.IntCursor;
import org.teavm.hppc.cursors.ObjectCursor;
import org.teavm.hppc.cursors.ObjectIntCursor;
import org.teavm.hppc.predicates.IntPredicate;
import org.teavm.hppc.predicates.ObjectIntPredicate;
import org.teavm.hppc.predicates.ObjectPredicate;
import org.teavm.hppc.procedures.IntProcedure;
import org.teavm.hppc.procedures.ObjectIntProcedure;
import org.teavm.hppc.procedures.ObjectProcedure;
import org.teavm.hppc.sorting.QuickSort;

public class SortedIterationObjectIntHashMap<KType>
implements ObjectIntMap<KType> {
    public final ObjectIntHashMap<KType> delegate;
    public final int[] iterationOrder;

    public SortedIterationObjectIntHashMap(ObjectIntHashMap<KType> delegate, Comparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationObjectIntHashMap(ObjectIntHashMap<KType> delegate, ObjectIntComparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        Object[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != null) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, Comparator<KType> comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            Object[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ObjectIntComparator<KType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final KType[] keys;
            final int[] values;
            {
                this.keys = SortedIterationObjectIntHashMap.this.delegate.keys;
                this.values = SortedIterationObjectIntHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ObjectIntCursor<KType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(KType key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> container) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectIntPredicate<? super KType> predicate) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public <T extends ObjectIntProcedure<? super KType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply((Object)keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectIntPredicate<? super KType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply((Object)keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ObjectCollection<KType> keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public IntContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public int get(KType key) {
        return this.delegate.get(key);
    }

    @Override
    public int getOrDefault(KType key, int defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public int put(KType key, int value) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(ObjectIntAssociativeContainer<? extends KType> container) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ObjectIntCursor<? extends KType>> iterable) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int putOrAdd(KType key, int putValue, int incrementValue) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int addTo(KType key, int additionValue) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int remove(KType key) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int indexOf(KType key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public int indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public int indexReplace(int index, int newValue) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, KType key, int value) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int indexRemove(int index) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectIntCursor<KType>> {
        private final ObjectIntCursor<KType> cursor = new ObjectIntCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ObjectIntCursor<KType> fetch() {
            if (this.index < SortedIterationObjectIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectIntHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationObjectIntHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationObjectIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectIntCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final SortedIterationObjectIntHashMap<KType> owner;

        private KeysContainer() {
            this.owner = SortedIterationObjectIntHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(KType e) {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final SortedIterationObjectIntHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationObjectIntHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(int value) {
            for (ObjectIntCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationObjectIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.index < SortedIterationObjectIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectIntHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

