/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.doubleimpl;

import java.util.PrimitiveIterator;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.doubleimpl.TSimpleDoubleStreamImpl;

public class TFlatMappingDoubleStreamImpl
extends TSimpleDoubleStreamImpl {
    private TSimpleDoubleStreamImpl sourceStream;
    private boolean currentSet;
    private TDoubleStream current;
    private PrimitiveIterator.OfDouble iterator;
    private DoubleFunction<? extends TDoubleStream> mapper;
    private boolean done;

    public TFlatMappingDoubleStreamImpl(TSimpleDoubleStreamImpl sourceStream, DoubleFunction<? extends TDoubleStream> mapper) {
        this.sourceStream = sourceStream;
        this.mapper = mapper;
    }

    @Override
    public boolean next(DoublePredicate consumer) {
        if (this.current == null) {
            if (this.done) {
                return false;
            }
            this.currentSet = false;
            while (!this.currentSet) {
                boolean hasMore = this.sourceStream.next(e -> {
                    this.current = this.mapper.apply(e);
                    this.currentSet = true;
                    return false;
                });
                if (hasMore) continue;
                this.done = true;
                break;
            }
            if (this.current == null) {
                return false;
            }
        }
        if (this.current instanceof TSimpleDoubleStreamImpl) {
            TSimpleDoubleStreamImpl castCurrent = (TSimpleDoubleStreamImpl)this.current;
            if (castCurrent.next(consumer)) {
                return true;
            }
            this.current = null;
        } else {
            this.iterator = this.current.iterator();
            while (this.iterator.hasNext()) {
                double e2 = this.iterator.next();
                if (consumer.test(e2)) continue;
                return true;
            }
            this.iterator = null;
            this.current = null;
        }
        return true;
    }

    @Override
    public void close() {
        this.current = null;
        this.iterator = null;
        this.sourceStream.close();
    }
}

