/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Date;
import java.util.Objects;
import org.teavm.classlib.java.lang.TIllegalStateException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.THashSet;
import org.teavm.classlib.java.util.TSet;
import org.teavm.classlib.java.util.TTimerTask;
import org.teavm.jso.browser.TimerHandler;
import org.teavm.jso.browser.Window;

public class TTimer
extends TObject {
    TSet<TTimerTask> tasks = new THashSet<TTimerTask>();
    private volatile boolean cancelled;
    private String threadName;
    private boolean daemon;

    public TTimer() {
    }

    public TTimer(String name) {
        Objects.requireNonNull(name);
        this.threadName = name;
    }

    public TTimer(boolean daemon) {
        this.daemon = daemon;
    }

    public TTimer(String name, boolean daemon) {
        Objects.requireNonNull(name);
        this.threadName = name;
        this.daemon = daemon;
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        for (TTimerTask task : this.tasks.toArray(new TTimerTask[0])) {
            task.cancel();
        }
    }

    public void schedule(TTimerTask task, Date time) {
        long delay = Math.max(0L, time.getTime() - System.currentTimeMillis());
        this.schedule(task, delay);
    }

    public void schedule(TTimerTask task, long delay) {
        if (this.cancelled || task.timer != null || task.nativeTimerId >= 0) {
            throw new TIllegalStateException();
        }
        task.timer = this;
        task.nativeTimerId = Window.setTimeout(() -> this.runThread(new Thread(() -> {
            if (this.cancelled || task.timer == null) {
                return;
            }
            TTimerTask.performOnce(task);
        })), (int)delay);
    }

    public void schedule(TTimerTask task, Date time, long period) {
        long delay = Math.max(0L, time.getTime() - System.currentTimeMillis());
        this.schedule(task, delay, period);
    }

    public void schedule(final TTimerTask task, long delay, final long period) {
        if (this.cancelled || task.timer != null || task.nativeTimerId >= 0) {
            throw new TIllegalStateException();
        }
        task.timer = this;
        TimerHandler handler = new TimerHandler(){

            @Override
            public void onTimer() {
                TTimer.this.runThread(new Thread(() -> {
                    if (TTimer.this.cancelled || task2.timer == null) {
                        return;
                    }
                    task2.nativeTimerId = Window.setTimeout((TimerHandler)this, (int)period);
                    TTimerTask.performOnce(task);
                    if (!TTimer.this.cancelled) {
                        task2.timer = TTimer.this;
                    }
                }));
            }
        };
        task.nativeTimerId = Window.setTimeout(handler, (int)delay);
    }

    public void scheduleAtFixedRate(TTimerTask task, Date time, long period) {
        long delay = Math.max(0L, time.getTime() - System.currentTimeMillis());
        this.scheduleAtFixedRate(task, delay, period);
    }

    public void scheduleAtFixedRate(final TTimerTask task, long delay, final long period) {
        if (this.cancelled || task.timer != null || task.nativeTimerId >= 0) {
            throw new TIllegalStateException();
        }
        final long[] nextStartTime = new long[]{System.currentTimeMillis() + delay};
        task.timer = this;
        TimerHandler handler = new TimerHandler(){

            @Override
            public void onTimer() {
                TTimer.this.runThread(new Thread(() -> {
                    if (TTimer.this.cancelled || task2.timer == null) {
                        return;
                    }
                    long nextDelay = nextStartTime[0] - System.currentTimeMillis();
                    if (nextDelay < 0L) {
                        nextDelay = 0L;
                    }
                    task2.nativeTimerId = Window.setTimeout((TimerHandler)this, (int)nextDelay);
                    nextStartTime2[0] = nextStartTime[0] + period;
                    TTimerTask.performOnce(task);
                    if (!TTimer.this.cancelled) {
                        task2.timer = TTimer.this;
                    }
                }));
            }
        };
        task.nativeTimerId = Window.setTimeout(handler, (int)delay);
        nextStartTime[0] = nextStartTime[0] + period;
    }

    private void runThread(Thread thread) {
        if (this.threadName != null) {
            thread.setName(this.threadName);
            thread.setDaemon(this.daemon);
        }
        thread.start();
    }
}

