/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TClassLoader;
import org.teavm.classlib.java.lang.TIterable;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TUnsupportedOperationException;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.platform.PlatformClass;

public final class TServiceLoader<S>
extends TObject
implements TIterable<S> {
    private Object[] services;

    private TServiceLoader(Object[] services) {
        this.services = services;
    }

    @Override
    public TIterator<S> iterator() {
        return new TIterator<S>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < TServiceLoader.this.services.length;
            }

            @Override
            public S next() {
                if (this.index == TServiceLoader.this.services.length) {
                    throw new TNoSuchElementException();
                }
                return TServiceLoader.this.services[this.index++];
            }

            @Override
            public void remove() {
                throw new TUnsupportedOperationException();
            }
        };
    }

    public static <S> TServiceLoader<S> load(TClass<S> service) {
        return new TServiceLoader<S>(PlatformDetector.isWebAssemblyGC() ? TServiceLoader.doLoadServices(service) : TServiceLoader.doLoadServices(service.getPlatformClass()));
    }

    public static <S> TServiceLoader<S> load(TClass<S> service, TClassLoader loader) {
        return TServiceLoader.load(service);
    }

    public static <S> TServiceLoader<S> loadInstalled(TClass<S> service) {
        return TServiceLoader.load(service);
    }

    private static Object[] doLoadServices(PlatformClass cls) {
        Object[] result = TServiceLoader.loadServices(cls);
        if (result == null) {
            result = new Object[]{};
        }
        return result;
    }

    private static native Object[] loadServices(PlatformClass var0);

    private static Object[] doLoadServices(TClass<?> cls) {
        Object[] result = TServiceLoader.loadServices(cls);
        if (result == null) {
            result = new Object[]{};
        }
        return result;
    }

    private static native Object[] loadServices(TClass<?> var0);

    public void reload() {
    }
}

