/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.nio.TBuffer;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TLongBufferNative;
import org.teavm.classlib.java.nio.TLongBufferOverArray;
import org.teavm.classlib.java.nio.TLongBufferOverTypedArray;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.BigInt64Array;

public abstract class TLongBuffer
extends TBuffer
implements Comparable<TLongBuffer> {
    TLongBuffer(int position, int limit) {
        this.position = position;
        this.limit = limit;
    }

    public static TLongBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        if (PlatformDetector.isJavaScript()) {
            long[] array = new long[capacity];
            return new TLongBufferOverTypedArray(0, capacity, false, BigInt64Array.fromJavaArray(array), array);
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            long[] array = new long[capacity];
            return new TLongBufferNative(null, array, 0, capacity, false, array, Address.ofData(array), capacity, false);
        }
        return new TLongBufferOverArray(capacity);
    }

    public static TLongBuffer wrap(long[] array, int offset, int length) {
        if (PlatformDetector.isJavaScript()) {
            TLongBufferOverTypedArray result = new TLongBufferOverTypedArray(0, array.length, false, BigInt64Array.fromJavaArray(array), array);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            TLongBufferNative result = new TLongBufferNative(null, array, 0, array.length, false, array, Address.ofData(array), array.length, false);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        return new TLongBufferOverArray(0, array.length, array, offset, offset + length, false);
    }

    public static TLongBuffer wrap(long[] array) {
        return TLongBuffer.wrap(array, 0, array.length);
    }

    public abstract TLongBuffer slice();

    public abstract TLongBuffer duplicate();

    public abstract TLongBuffer asReadOnlyBuffer();

    public abstract long get();

    public abstract TLongBuffer put(long var1);

    public abstract long get(int var1);

    public abstract TLongBuffer put(int var1, long var2);

    abstract long getElement(int var1);

    abstract void putElement(int var1, long var2);

    public TLongBuffer get(long[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.remaining()) {
            throw new TBufferUnderflowException();
        }
        this.getImpl(this.position, dst, offset, length);
        this.position += length;
        return this;
    }

    public TLongBuffer get(int index, long[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.getImpl(index, dst, offset, length);
        return this;
    }

    public TLongBuffer get(int index, long[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    abstract void getImpl(int var1, long[] var2, int var3, int var4);

    public TLongBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TLongBuffer put(int index, TLongBuffer src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index > this.limit() || offset < 0 || offset + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    public TLongBuffer put(int index, long[] src) {
        return this.put(index, src, 0, src.length);
    }

    abstract void putImpl(int var1, TLongBuffer var2, int var3, int var4);

    public TLongBuffer put(TLongBuffer src) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        int elementsToTransfer = src.remaining();
        if (this.remaining() < elementsToTransfer) {
            throw new TBufferOverflowException();
        }
        this.putImpl(this.position, src, src.position, elementsToTransfer);
        this.position += elementsToTransfer;
        src.position += elementsToTransfer;
        return this;
    }

    public TLongBuffer put(long[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(this.position, src, offset, length);
        this.position += length;
        return this;
    }

    public TLongBuffer put(int index, long[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    public final TLongBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    abstract void putImpl(int var1, long[] var2, int var3, int var4);

    @Override
    public final boolean hasArray() {
        return this.isArrayPresent();
    }

    public final long[] array() {
        return this.getArray();
    }

    @Override
    public final int arrayOffset() {
        return this.getArrayOffset();
    }

    abstract boolean isArrayPresent();

    abstract long[] getArray();

    abstract int getArrayOffset();

    public abstract TLongBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return "[LongBuffer position=" + this.position + ", limit=" + this.limit + ", capacity=" + this.capacity() + ", mark " + (String)(this.mark >= 0 ? " at " + this.mark : " is not set") + "]";
    }

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position;
        for (int i = this.position; i < this.limit; ++i) {
            long elem = this.getElement(pos++);
            hashCode = 31 * hashCode + (int)elem + (int)(elem >>> 32);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TLongBuffer)) {
            return false;
        }
        TLongBuffer other = (TLongBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            if (this.getElement(a++) == other.getElement(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TLongBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Long.compare(this.getElement(a++), other.getElement(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    public abstract TByteOrder order();

    @Override
    public final TLongBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final TLongBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final TLongBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final TLongBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final TLongBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public TLongBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public TLongBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }
}

