/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteBufferImpl;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TCharBufferOverByteBuffer;

class TCharBufferOverByteBufferBigEndian
extends TCharBufferOverByteBuffer {
    TCharBufferOverByteBufferBigEndian(int start, int capacity, TByteBufferImpl byteBuffer, int position, int limit, boolean readOnly) {
        super(start, capacity, byteBuffer, position, limit, readOnly);
    }

    @Override
    char getChar(int index) {
        int value = (this.byteBuffer.array[this.start + index * 2] & 0xFF) << 8 | this.byteBuffer.array[this.start + index * 2 + 1] & 0xFF;
        return (char)value;
    }

    @Override
    void putChar(int index, char value) {
        this.byteBuffer.array[this.start + index * 2] = (byte)(value >> 8);
        this.byteBuffer.array[this.start + index * 2 + 1] = (byte)value;
    }

    @Override
    TCharBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TCharBufferOverByteBufferBigEndian(this.start + start * 2, capacity, this.byteBuffer, position, limit, readOnly);
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.LITTLE_ENDIAN;
    }
}

