/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.net.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.classlib.java.net.THttpURLConnection;
import org.teavm.classlib.java.net.TURL;
import org.teavm.interop.Async;
import org.teavm.interop.AsyncCallback;
import org.teavm.jso.ajax.XMLHttpRequest;
import org.teavm.jso.typedarrays.ArrayBuffer;
import org.teavm.jso.typedarrays.Int8Array;

public class TXHRURLConnection
extends THttpURLConnection {
    private XMLHttpRequest xhr;
    private ByteArrayOutputStream outputStream;
    private ByteArrayInputStream inputStream;
    private ByteArrayInputStream errorStream;
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private String[] responseHeaderKeys;
    private String[] responseHeaderValues;
    private Map<String, List<String>> headerFields = new HashMap<String, List<String>>();
    private boolean requestPerformed;

    public TXHRURLConnection(TURL url) {
        super(url);
    }

    @Override
    public void disconnect() {
        this.connected = false;
        this.xhr = null;
        this.responseHeaders = null;
        this.responseHeaderKeys = null;
        this.responseHeaderValues = null;
        this.inputStream = null;
        this.outputStream = null;
        this.errorStream = null;
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.xhr = new XMLHttpRequest();
        this.xhr.open(this.method, this.url.toString());
        for (Map.Entry<String, List<String>> entry : this.getRequestProperties().entrySet()) {
            for (String value : entry.getValue()) {
                this.xhr.setRequestHeader(entry.getKey(), value);
            }
        }
        this.xhr.setResponseType("arraybuffer");
        this.connected = true;
    }

    private void performRequestIfNecessary() {
        if (!this.requestPerformed) {
            this.requestPerformed = true;
            this.performRequest();
        }
    }

    @Async
    private native Boolean performRequest();

    private void performRequest(AsyncCallback<Boolean> callback) {
        this.xhr.setOnReadyStateChange(() -> {
            if (this.xhr.getReadyState() != 4) {
                return;
            }
            this.responseCode = this.xhr.getStatus();
            this.responseMessage = this.xhr.getStatusText();
            if (this.responseCode == 0) {
                this.responseCode = -1;
            }
            Int8Array array = new Int8Array((ArrayBuffer)this.xhr.getResponse());
            byte[] bytes = new byte[array.getLength()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = array.get(i);
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            this.parseHeaders(this.xhr.getAllResponseHeaders());
            int responseGroup = this.responseCode / 100;
            if (responseGroup == 4 || responseGroup == 5) {
                this.errorStream = stream;
                this.inputStream = null;
            } else {
                this.inputStream = stream;
                this.errorStream = null;
            }
            callback.complete(Boolean.TRUE);
        });
        if (this.outputStream != null) {
            byte[] bytes = this.outputStream.toByteArray();
            Int8Array array = new Int8Array(bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                array.set(i, bytes[i]);
            }
            this.xhr.send(array.getBuffer());
        } else {
            this.xhr.send();
        }
    }

    private void parseHeaders(String headers) {
        int index = 0;
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        this.responseHeaders = new HashMap<String, String>();
        this.headerFields = new HashMap<String, List<String>>();
        while (index < headers.length()) {
            int colon;
            int next = headers.indexOf("\r\n", index);
            if (next < 0) {
                next = headers.length();
            }
            if ((colon = headers.indexOf(58, index)) < 0) {
                colon = headers.length();
            }
            String key = colon < next ? headers.substring(index, colon) : headers.substring(index, next);
            String value = colon < next ? headers.substring(colon + 1, next).trim() : "";
            key = key.trim();
            keys.add(key);
            values.add(value);
            List<String> headerFieldValues = this.headerFields.get(key);
            if (headerFieldValues == null) {
                headerFieldValues = new ArrayList<String>();
                this.headerFields.put(key, headerFieldValues);
            }
            headerFieldValues.add(value);
            key = key.toLowerCase();
            this.responseHeaders.put(key, value);
            index = next + 2;
        }
        this.responseHeaderKeys = keys.toArray(new String[keys.size()]);
        this.responseHeaderValues = values.toArray(new String[values.size()]);
    }

    @Override
    public String getHeaderFieldKey(int posn) {
        this.performRequestIfNecessary();
        if (this.responseHeaderKeys == null || posn >= this.responseHeaderKeys.length) {
            return null;
        }
        return this.responseHeaderKeys[posn];
    }

    @Override
    public String getHeaderField(int pos) {
        this.performRequestIfNecessary();
        if (this.responseHeaderValues == null || pos >= this.responseHeaderValues.length) {
            return null;
        }
        return this.responseHeaderValues[pos];
    }

    @Override
    public String getHeaderField(String key) {
        this.performRequestIfNecessary();
        return this.responseHeaders != null ? this.responseHeaders.get(key.toLowerCase()) : null;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        this.performRequestIfNecessary();
        int responseGroup = this.responseCode / 100;
        if (responseGroup == 4 || responseGroup == 5) {
            this.inputStream = new ByteArrayInputStream(new byte[0]);
            throw new IOException("HTTP status: " + this.responseCode + " " + this.responseMessage);
        }
        return this.inputStream;
    }

    @Override
    public int getResponseCode() throws IOException {
        this.connect();
        this.performRequestIfNecessary();
        return super.getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        this.connect();
        this.performRequestIfNecessary();
        return super.getResponseMessage();
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream();
        }
        return this.outputStream;
    }
}

