/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.net;

import java.io.IOException;
import java.util.Objects;
import org.teavm.classlib.java.net.TURL;
import org.teavm.classlib.java.net.TURLConnection;

public abstract class TURLStreamHandler {
    protected abstract TURLConnection openConnection(TURL var1) throws IOException;

    protected void parseURL(TURL u, String str, int start, int end) {
        int last;
        if (end < start || end < 0) {
            if (end <= -2147483647 && (start >= str.length() || start < 0) || str.startsWith("//", start) && str.indexOf(47, start + 2) == -1) {
                throw new StringIndexOutOfBoundsException(end);
            }
            return;
        }
        String parseString = str.substring(start, end);
        end -= start;
        int fileIdx = 0;
        String host = u.getHost();
        int port = u.getPort();
        String ref = u.getRef();
        Object file = u.getPath();
        String query = u.getQuery();
        String authority = u.getAuthority();
        String userInfo = u.getUserInfo();
        int refIdx = parseString.indexOf(35, 0);
        if (parseString.startsWith("//") && !parseString.startsWith("////")) {
            int hostIdx = 2;
            port = -1;
            fileIdx = parseString.indexOf(47, hostIdx);
            int questionMarkIndex = parseString.indexOf(63, hostIdx);
            if (questionMarkIndex != -1 && (fileIdx == -1 || fileIdx > questionMarkIndex)) {
                fileIdx = questionMarkIndex;
            }
            if (fileIdx == -1) {
                fileIdx = end;
                file = "";
            }
            int hostEnd = fileIdx;
            if (refIdx != -1 && refIdx < fileIdx) {
                hostEnd = refIdx;
            }
            int userIdx = parseString.lastIndexOf(64, hostEnd);
            authority = parseString.substring(hostIdx, hostEnd);
            if (userIdx > -1) {
                userInfo = parseString.substring(hostIdx, userIdx);
                hostIdx = userIdx + 1;
            }
            int portIdx = parseString.indexOf(58, userIdx == -1 ? hostIdx : userIdx);
            int endOfIPv6Addr = parseString.indexOf(93);
            if (endOfIPv6Addr != -1) {
                try {
                    char c;
                    portIdx = parseString.length() > endOfIPv6Addr + 1 ? ((c = parseString.charAt(endOfIPv6Addr + 1)) == ':' ? endOfIPv6Addr + 1 : -1) : -1;
                }
                catch (Exception c) {
                    // empty catch block
                }
            }
            if (portIdx == -1 || portIdx > fileIdx) {
                host = parseString.substring(hostIdx, hostEnd);
            } else {
                host = parseString.substring(hostIdx, portIdx);
                String portString = parseString.substring(portIdx + 1, hostEnd);
                if (!portString.isEmpty()) {
                    port = Integer.parseInt(portString);
                }
            }
        }
        if (refIdx > -1) {
            ref = parseString.substring(refIdx + 1, end);
        }
        int fileEnd = refIdx == -1 ? end : refIdx;
        int queryIdx = parseString.lastIndexOf(63, fileEnd);
        boolean canonicalize = false;
        if (queryIdx > -1) {
            query = parseString.substring(queryIdx + 1, fileEnd);
            if (queryIdx == 0 && file != null) {
                if (((String)file).equals("")) {
                    file = "/";
                } else if (((String)file).startsWith("/")) {
                    canonicalize = true;
                }
                last = ((String)file).lastIndexOf(47) + 1;
                file = ((String)file).substring(0, last);
            }
            fileEnd = queryIdx;
        } else if (refIdx != 0) {
            query = null;
        }
        if (fileIdx > -1) {
            if (fileIdx < end && parseString.charAt(fileIdx) == '/') {
                file = parseString.substring(fileIdx, fileEnd);
            } else if (fileEnd > fileIdx) {
                if (file == null) {
                    file = "";
                } else if (((String)file).equals("")) {
                    file = "/";
                } else if (((String)file).startsWith("/")) {
                    canonicalize = true;
                }
                last = ((String)file).lastIndexOf(47) + 1;
                file = last == 0 ? parseString.substring(fileIdx, fileEnd) : ((String)file).substring(0, last) + parseString.substring(fileIdx, fileEnd);
            }
        }
        if (file == null) {
            file = "";
        }
        if (host == null) {
            host = "";
        }
        if (canonicalize) {
            file = TURLStreamHandler.canonicalizePath((String)file);
        }
        this.setURL(u, u.getProtocol(), host, port, authority, userInfo, (String)file, query, ref);
    }

    private static String canonicalizePath(String path) {
        int dirIndex;
        while ((dirIndex = ((String)path).indexOf("/./")) >= 0) {
            path = ((String)path).substring(0, dirIndex + 1) + ((String)path).substring(dirIndex + 3);
        }
        if (((String)path).endsWith("/.")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        while ((dirIndex = ((String)path).indexOf("/../")) >= 0) {
            if (dirIndex != 0) {
                path = ((String)path).substring(0, ((String)path).lastIndexOf(47, dirIndex - 1)) + ((String)path).substring(dirIndex + 3);
                continue;
            }
            path = ((String)path).substring(3);
        }
        if (((String)path).endsWith("/..") && ((String)path).length() > 3) {
            path = ((String)path).substring(0, ((String)path).lastIndexOf(47, ((String)path).length() - 4) + 1);
        }
        return path;
    }

    @Deprecated
    protected void setURL(TURL u, String protocol, String host, int port, String file, String ref) {
        u.set(protocol, host, port, file, ref);
    }

    protected void setURL(TURL u, String protocol, String host, int port, String authority, String userInfo, String file, String query, String ref) {
        u.set(protocol, host, port, authority, userInfo, file, query, ref);
    }

    protected String toExternalForm(TURL url) {
        StringBuilder answer = new StringBuilder();
        answer.append(url.getProtocol());
        answer.append(':');
        String authority = url.getAuthority();
        if (authority != null && authority.length() > 0) {
            answer.append("//");
            answer.append(url.getAuthority());
        }
        String file = url.getFile();
        String ref = url.getRef();
        if (file != null) {
            answer.append(file);
        }
        if (ref != null) {
            answer.append('#');
            answer.append(ref);
        }
        return answer.toString();
    }

    protected boolean equals(TURL url1, TURL url2) {
        if (!this.sameFile(url1, url2)) {
            return false;
        }
        return Objects.equals(url1.getRef(), url2.getRef()) && Objects.equals(url1.getQuery(), url2.getQuery());
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected int hashCode(TURL url) {
        return this.toExternalForm(url).hashCode();
    }

    protected boolean hostsEqual(TURL url1, TURL url2) {
        String host1 = TURLStreamHandler.getHost(url1);
        String host2 = TURLStreamHandler.getHost(url2);
        if (host1 == null && host2 == null) {
            return true;
        }
        return host1 != null && host1.equalsIgnoreCase(host2);
    }

    protected boolean sameFile(TURL url1, TURL url2) {
        int p2;
        if (!Objects.equals(url1.getProtocol(), url2.getProtocol()) || !Objects.equals(url1.getFile(), url2.getFile())) {
            return false;
        }
        if (!this.hostsEqual(url1, url2)) {
            return false;
        }
        int p1 = url1.getPort();
        if (p1 == -1) {
            p1 = this.getDefaultPort();
        }
        if ((p2 = url2.getPort()) == -1) {
            p2 = this.getDefaultPort();
        }
        return p1 == p2;
    }

    private static String getHost(TURL url) {
        String host = url.getHost();
        if ("file".equals(url.getProtocol()) && "".equals(host)) {
            host = "localhost";
        }
        return host;
    }
}

