/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.lang.annotation.Annotation;
import org.teavm.classlib.impl.reflection.Flags;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.annotation.TAnnotation;
import org.teavm.classlib.java.lang.reflect.TAccessibleObject;
import org.teavm.classlib.java.lang.reflect.TGenericDeclaration;
import org.teavm.classlib.java.lang.reflect.TMember;
import org.teavm.classlib.java.lang.reflect.TType;
import org.teavm.classlib.java.lang.reflect.TTypeVariable;
import org.teavm.classlib.java.lang.reflect.TTypeVariableImpl;
import org.teavm.classlib.java.lang.reflect.TTypeVariableStub;

public abstract class TExecutable
extends TAccessibleObject
implements TMember,
TGenericDeclaration {
    TClass<?> declaringClass;
    int flags;
    int accessLevel;
    TClass<?>[] parameterTypes;
    Object[] genericParameterTypes;
    TType[] resolvedGenericParameterTypes;
    Object[] declaredAnnotations;
    TTypeVariableImpl[] typeParameters;

    TExecutable(TClass<?> declaringClass, int flags, int accessLevel, TClass<?>[] parameterTypes, Object[] genericParameterTypes, Annotation[] declaredAnnotations, TTypeVariableImpl[] typeParameters) {
        this.declaringClass = declaringClass;
        this.flags = flags;
        this.accessLevel = accessLevel;
        this.parameterTypes = parameterTypes;
        this.genericParameterTypes = genericParameterTypes;
        this.declaredAnnotations = declaredAnnotations;
        this.typeParameters = typeParameters;
        if (typeParameters != null) {
            for (TTypeVariableImpl param : typeParameters) {
                param.declaration = this;
            }
        }
    }

    @Override
    public TClass<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public int getModifiers() {
        return Flags.getModifiers(this.flags, this.accessLevel);
    }

    public TClass<?>[] getParameterTypes() {
        return (TClass[])this.parameterTypes.clone();
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    public TType[] getGenericParameterTypes() {
        block4: {
            if (this.resolvedGenericParameterTypes != null) break block4;
            this.resolvedGenericParameterTypes = new TType[this.parameterTypes.length];
            if (this.genericParameterTypes == null) {
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    this.resolvedGenericParameterTypes[i] = this.parameterTypes[i];
                }
            } else {
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    TType type = (TType)this.genericParameterTypes[i];
                    this.resolvedGenericParameterTypes[i] = type != null ? TTypeVariableStub.resolve(type, this) : this.parameterTypes[i];
                }
            }
        }
        return (TType[])this.resolvedGenericParameterTypes.clone();
    }

    @Override
    public boolean isSynthetic() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isVarArgs() {
        return (this.flags & 0x2000) != 0;
    }

    @Override
    public TAnnotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations != null ? (TAnnotation[])this.declaredAnnotations.clone() : new TAnnotation[]{};
    }

    @Override
    public TTypeVariable<?>[] getTypeParameters() {
        return this.typeParameters != null ? (TTypeVariable[])this.typeParameters.clone() : new TTypeVariable[]{};
    }
}

