/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.util.Objects;
import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.classlib.impl.IntegerUtil;
import org.teavm.classlib.java.lang.LongNativeGenerator;
import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TNumber;
import org.teavm.classlib.java.lang.TNumberFormatException;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.classlib.java.lang.TSystem;
import org.teavm.interop.NoSideEffects;

public class TLong
extends TNumber
implements TComparable<TLong> {
    public static final long MIN_VALUE = Long.MIN_VALUE;
    public static final long MAX_VALUE = Long.MAX_VALUE;
    public static final Class<Long> TYPE = Long.TYPE;
    public static final int SIZE = 64;
    public static final int BYTES = 8;
    private final long value;

    public TLong(long value) {
        this.value = value;
    }

    public TLong(String value) throws TNumberFormatException {
        this(TLong.parseLong(value));
    }

    public static TLong valueOf(long value) {
        return new TLong(value);
    }

    public static long parseLong(String s, int radix) throws TNumberFormatException {
        if (s == null) {
            throw new TNumberFormatException("String is null");
        }
        return TLong.parseLongImpl(s, 0, s.length(), radix);
    }

    public static long parseLong(CharSequence s, int beginIndex, int endIndex, int radix) throws TNumberFormatException {
        return TLong.parseLongImpl(Objects.requireNonNull(s), beginIndex, endIndex, radix);
    }

    private static long parseLongImpl(CharSequence s, int beginIndex, int endIndex, int radix) throws TNumberFormatException {
        if (radix < 2 || radix > 36) {
            throw new TNumberFormatException("Illegal radix: " + radix);
        }
        if (beginIndex == endIndex) {
            throw new TNumberFormatException("String is empty");
        }
        boolean negative = false;
        int index = beginIndex;
        switch (s.charAt(index)) {
            case '-': {
                negative = true;
                ++index;
                break;
            }
            case '+': {
                ++index;
            }
        }
        long value = 0L;
        long maxValue = 1L + Long.MAX_VALUE / (long)radix;
        if (index == endIndex) {
            throw new TNumberFormatException();
        }
        while (index < endIndex) {
            int digit;
            if ((digit = TLong.decodeDigit(s.charAt(index++))) < 0) {
                throw new TNumberFormatException("String contains invalid digits: " + String.valueOf(s.subSequence(beginIndex, endIndex)));
            }
            if (digit >= radix) {
                throw new TNumberFormatException("String contains digits out of radix " + radix + ": " + String.valueOf(s.subSequence(beginIndex, endIndex)));
            }
            if (value > maxValue) {
                throw new TNumberFormatException("The value is too big for long type");
            }
            if ((value = (long)radix * value + (long)digit) >= 0L) continue;
            if (index == endIndex && value == Long.MIN_VALUE && negative) {
                return Long.MIN_VALUE;
            }
            throw new TNumberFormatException("The value is too big for long type: " + String.valueOf(s.subSequence(beginIndex, endIndex)));
        }
        return negative ? -value : value;
    }

    public static long parseLong(String s) throws TNumberFormatException {
        return TLong.parseLong(s, 10);
    }

    public static TLong valueOf(String s, int radix) throws TNumberFormatException {
        return TLong.valueOf(TLong.parseLong(s, radix));
    }

    public static TLong valueOf(String s) throws TNumberFormatException {
        return TLong.valueOf(TLong.parseLong(s));
    }

    public static TLong decode(TString nm) throws TNumberFormatException {
        if (nm.isEmpty()) {
            throw new TNumberFormatException("Can't parse empty string");
        }
        int index = 0;
        boolean negaive = false;
        if (nm.charAt(index) == '+') {
            ++index;
        } else if (nm.charAt(index) == '-') {
            ++index;
            negaive = true;
        }
        if (index >= nm.length()) {
            throw new TNumberFormatException("The string does not represent a number");
        }
        int radix = 10;
        if (nm.charAt(index) == '#') {
            radix = 16;
            ++index;
        } else if (nm.charAt(index) == '0') {
            if (++index == nm.length()) {
                return TLong.valueOf(0L);
            }
            if (nm.charAt(index) == 'x' || nm.charAt(index) == 'X') {
                radix = 16;
                ++index;
            } else {
                radix = 8;
            }
        }
        if (index >= nm.length()) {
            throw new TNumberFormatException("The string does not represent a number");
        }
        long value = 0L;
        long maxValue = 1L + Long.MAX_VALUE / (long)radix;
        while (index < nm.length()) {
            int digit;
            if ((digit = TLong.decodeDigit(nm.charAt(index++))) < 0 || digit >= radix) {
                throw new TNumberFormatException("The string does not represent a number");
            }
            if (value > maxValue) {
                throw new TNumberFormatException("The value is too big for long type");
            }
            if ((value = value * (long)radix + (long)digit) >= 0L) continue;
            if (negaive && value == Long.MIN_VALUE && index == nm.length()) {
                return TLong.valueOf(Long.MIN_VALUE);
            }
            throw new TNumberFormatException("The string represents a too big number");
        }
        return TLong.valueOf(negaive ? -value : value);
    }

    private static int decodeDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 10;
        }
        return -1;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static String toString(long i, int radix) {
        return new TStringBuilder().insert(0, i, radix).toString();
    }

    public static String toUnsignedString(long value, int radix) {
        radix = Math.min(36, Math.max(radix, 2));
        int sz = 0;
        long v = value;
        while (v != 0L) {
            v = Long.divideUnsigned(v, radix);
            ++sz;
        }
        sz = Math.max(sz, 1);
        char[] chars = new char[sz];
        while (sz > 0) {
            chars[--sz] = TCharacter.forDigit((int)Long.remainderUnsigned(value, radix), radix);
            value = Long.divideUnsigned(value, radix);
        }
        return (String)((Object)TString.fromArray(chars));
    }

    public static String toUnsignedString(long value) {
        int sz = 0;
        long v = value;
        while (v != 0L) {
            v = Long.divideUnsigned(v, 10L);
            ++sz;
        }
        sz = Math.max(sz, 1);
        char[] chars = new char[sz];
        while (sz > 0) {
            chars[--sz] = TCharacter.forDigit((int)Long.remainderUnsigned(value, 10L), 10);
            value = Long.divideUnsigned(value, 10L);
        }
        return (String)((Object)TString.fromArray(chars));
    }

    public static String toHexString(long i) {
        return IntegerUtil.toUnsignedLogRadixString(i, 4);
    }

    public static String toOctalString(long i) {
        return IntegerUtil.toUnsignedLogRadixString(i, 3);
    }

    public static String toBinaryString(long i) {
        return IntegerUtil.toUnsignedLogRadixString(i, 1);
    }

    public static String toString(long value) {
        return new TStringBuilder().append(value).toString();
    }

    @Override
    public String toString() {
        return TLong.toString(this.value);
    }

    @Override
    public int hashCode() {
        return TLong.hashCode(this.value);
    }

    private static int hashCode(long value) {
        return (int)value ^ (int)(value >>> 32);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TLong && ((TLong)other).value == this.value;
    }

    @NoSideEffects
    public static native int compare(long var0, long var2);

    @Override
    public int compareTo(TLong other) {
        return TLong.compare(this.value, other.value);
    }

    public static TLong getLong(String nm) {
        return TLong.getLong(nm, null);
    }

    public static TLong getLong(String nm, long val) {
        return TLong.getLong(nm, TLong.valueOf(val));
    }

    public static TLong getLong(String nm, TLong val) {
        String result = nm != null ? TSystem.getProperty(nm) : null;
        try {
            return result != null ? TLong.valueOf(result) : val;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int numberOfLeadingZeros(long i) {
        if (i == 0L) {
            return 64;
        }
        int n = 0;
        if (i >>> 32 != 0L) {
            i >>>= 32;
            n |= 0x20;
        }
        if (i >>> 16 != 0L) {
            i >>>= 16;
            n |= 0x10;
        }
        if (i >>> 8 != 0L) {
            i >>>= 8;
            n |= 8;
        }
        if (i >>> 4 != 0L) {
            i >>>= 4;
            n |= 4;
        }
        if (i >>> 2 != 0L) {
            i >>>= 2;
            n |= 2;
        }
        if (i >>> 1 != 0L) {
            i >>>= 1;
            n |= 1;
        }
        return 64 - n - 1;
    }

    public static int numberOfTrailingZeros(long i) {
        if (i == 0L) {
            return 64;
        }
        int n = 0;
        if (i << 32 != 0L) {
            i <<= 32;
            n |= 0x20;
        }
        if (i << 16 != 0L) {
            i <<= 16;
            n |= 0x10;
        }
        if (i << 8 != 0L) {
            i <<= 8;
            n |= 8;
        }
        if (i << 4 != 0L) {
            i <<= 4;
            n |= 4;
        }
        if (i << 2 != 0L) {
            i <<= 2;
            n |= 2;
        }
        if (i << 1 != 0L) {
            i <<= 1;
            n |= 1;
        }
        return 64 - n - 1;
    }

    public static long highestOneBit(long i) {
        return i & Long.MIN_VALUE >>> TLong.numberOfLeadingZeros(i);
    }

    public static long lowestOneBit(long i) {
        return -i & i;
    }

    public static int bitCount(long i) {
        i = ((i & 0xAAAAAAAAAAAAAAAAL) >>> 1) + (i & 0x5555555555555555L);
        i = ((i & 0xCCCCCCCCCCCCCCCCL) >>> 2) + (i & 0x3333333333333333L);
        i = ((i & 0x7070707070707070L) >>> 4) + (i & 0x707070707070707L);
        i = ((i & 0xF000F000F000F00L) >>> 8) + (i & 0xF000F000F000FL);
        i = ((i & 0x1F0000001F0000L) >>> 16) + (i & 0x1F0000001FL);
        i = ((i & 0x3F00000000L) >>> 32) + (i & 0x3FL);
        return (int)i;
    }

    public static long rotateLeft(long i, int distance) {
        return i << (distance &= 0x3F) | i >>> 64 - distance;
    }

    public static long rotateRight(long i, int distance) {
        return i >>> (distance &= 0x3F) | i << 64 - distance;
    }

    public static long reverse(long i) {
        i = (i & 0xAAAAAAAAAAAAAAAAL) >>> 1 | (i & 0x5555555555555555L) << 1;
        i = (i & 0xCCCCCCCCCCCCCCCCL) >>> 2 | (i & 0x3333333333333333L) << 2;
        i = (i & 0xF0F0F0F0F0F0F0F0L) >>> 4 | (i & 0xF0F0F0F0F0F0F0FL) << 4;
        i = (i & 0xFF00FF00FF00FF00L) >>> 8 | (i & 0xFF00FF00FF00FFL) << 8;
        i = (i & 0xFFFF0000FFFF0000L) >>> 16 | (i & 0xFFFF0000FFFFL) << 16;
        i = (i & 0xFFFFFFFF00000000L) >>> 32 | (i & 0xFFFFFFFFL) << 32;
        return i;
    }

    public static long reverseBytes(long i) {
        i = (i & 0xFF00FF00FF00FF00L) >>> 8 | (i & 0xFF00FF00FF00FFL) << 8;
        i = (i & 0xFFFF0000FFFF0000L) >>> 16 | (i & 0xFFFF0000FFFFL) << 16;
        i = i >>> 32 | i << 32;
        return i;
    }

    public static int signum(long i) {
        return (int)(i >> 63 | -i >>> 63);
    }

    @GeneratedBy(value=LongNativeGenerator.class)
    @NoSideEffects
    public static native long divideUnsigned(long var0, long var2);

    @GeneratedBy(value=LongNativeGenerator.class)
    @NoSideEffects
    public static native long remainderUnsigned(long var0, long var2);

    @GeneratedBy(value=LongNativeGenerator.class)
    @NoSideEffects
    public static native int compareUnsigned(long var0, long var2);

    public static long min(long a, long b) {
        return TMath.min(a, b);
    }

    public static long max(long a, long b) {
        return TMath.max(a, b);
    }

    public static long sum(long a, long b) {
        return a + b;
    }
}

