/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.tz;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.teavm.classlib.impl.Base46;
import org.teavm.classlib.impl.CharFlow;
import org.teavm.classlib.impl.tz.AliasDateTimeZone;
import org.teavm.classlib.impl.tz.DateTimeZone;
import org.teavm.classlib.impl.tz.StorableDateTimeZone;
import org.teavm.interop.Import;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.JSBody;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.StringResource;

public final class DateTimeZoneProvider {
    private static Map<String, DateTimeZone> cache = new HashMap<String, DateTimeZone>();

    private DateTimeZoneProvider() {
    }

    public static DateTimeZone getTimeZone(String id) {
        if (!cache.containsKey(id)) {
            cache.put(id, DateTimeZoneProvider.createTimeZone(id));
        }
        return cache.get(id);
    }

    private static DateTimeZone createTimeZone(String id) {
        StringResource res = DateTimeZoneProvider.getTimeZoneResource(id);
        if (res == null) {
            return null;
        }
        String data = res.getValue();
        CharFlow flow = new CharFlow(data.toCharArray());
        if (Base46.decodeUnsigned(flow) == 4) {
            String aliasId = data.substring(flow.pointer);
            return new AliasDateTimeZone(id, DateTimeZoneProvider.getTimeZone(aliasId));
        }
        return StorableDateTimeZone.read(id, data);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getIds() {
        ArrayList<void> ids = new ArrayList<void>();
        for (String areaName : DateTimeZoneProvider.getResource().keys()) {
            ResourceMap<StringResource> area = DateTimeZoneProvider.getResource().get(areaName);
            for (String string : area.keys()) {
                void var9_9;
                if (!areaName.isEmpty()) {
                    String string2 = areaName + "/" + string;
                }
                ids.add(var9_9);
            }
        }
        return ids.toArray(new String[0]);
    }

    public static DateTimeZone detectTimezone() {
        List zones = new ArrayList<Score>();
        long time = System.currentTimeMillis();
        int offset = -DateTimeZoneProvider.getNativeOffset(System.currentTimeMillis());
        for (String id : DateTimeZoneProvider.getIds()) {
            int tzOffset;
            DateTimeZone tz = DateTimeZoneProvider.getTimeZone(id);
            if (tz instanceof AliasDateTimeZone || Math.abs((tzOffset = tz.getOffset(time) / 60000) - offset) > 120 || tz.previousTransition(time) == time) continue;
            zones.add(new Score(tz));
        }
        ArrayList<Score> scoreTable = new ArrayList<Score>(zones);
        HashMap<Long, List> zoneMap = new HashMap<Long, List>();
        PriorityQueue queue = new PriorityQueue(zones.size(), Comparator.reverseOrder());
        HashSet<Long> timeInQueue = new HashSet<Long>();
        long last = time;
        queue.add(time);
        zoneMap.put(time, new ArrayList(zones));
        while (!queue.isEmpty() && scoreTable.size() > 1) {
            time = (Long)queue.remove();
            timeInQueue.remove(time);
            zones = (List)zoneMap.remove(time);
            offset = -DateTimeZoneProvider.getNativeOffset(time);
            for (Score score : zones) {
                long prev = score.tz.previousTransition(time);
                if (prev == time) {
                    if (scoreTable.get(0) == score) {
                        return score.tz;
                    }
                    scoreTable.remove(score);
                    continue;
                }
                int tzOffset = score.tz.getOffset(time) / 60000;
                if (Math.abs(tzOffset - offset) > 120) {
                    scoreTable.remove(score);
                    continue;
                }
                List prevZones = zoneMap.computeIfAbsent(prev, k -> new ArrayList());
                prevZones.add(score);
                if (!timeInQueue.add(prev)) continue;
                queue.add(prev);
            }
            if (scoreTable.size() == 1 || ((Score)scoreTable.get((int)0)).tz.previousTransition(time) == time) {
                return ((Score)scoreTable.get((int)0)).tz;
            }
            if (scoreTable.size() > 1 && ((Score)scoreTable.get((int)0)).value + 2880 < ((Score)scoreTable.get((int)1)).value) {
                return ((Score)scoreTable.get((int)0)).tz;
            }
            for (int i = scoreTable.size() - 1; i >= 0; --i) {
                int j;
                Score score;
                score = (Score)scoreTable.get(i);
                int tzOffset = score.tz.getOffset(time) / 60000;
                if (tzOffset != offset) {
                    score.value += (int)((last - time) / 60000L) * Math.abs(tzOffset - offset) / 30;
                }
                for (j = i + 1; j < scoreTable.size() && score.value > ((Score)scoreTable.get((int)j)).value; ++j) {
                    scoreTable.set(j - 1, (Score)scoreTable.get(j));
                }
                scoreTable.set(j - 1, score);
            }
            last = time;
        }
        return ((Score)scoreTable.get((int)0)).tz;
    }

    private static StringResource getTimeZoneResource(String id) {
        String locationName;
        String areaName;
        int sepIndex = id.indexOf(47);
        if (sepIndex >= 0) {
            areaName = id.substring(0, sepIndex);
            locationName = id.substring(sepIndex + 1);
        } else {
            areaName = "";
            locationName = id;
        }
        if (!DateTimeZoneProvider.getResource().has(areaName)) {
            return null;
        }
        ResourceMap<StringResource> area = DateTimeZoneProvider.getResource().get(areaName);
        return area.has(locationName) ? area.get(locationName) : null;
    }

    @JSBody(params={"instant"}, script="return new Date(instant).getTimezoneOffset();")
    @Import(module="teavm", name="getNativeOffset")
    @Unmanaged
    private static native int getNativeOffset(double var0);

    private static native ResourceMap<ResourceMap<StringResource>> getResource();

    static class Score {
        DateTimeZone tz;
        int value;

        public Score(DateTimeZone tz) {
            this.tz = tz;
        }
    }
}

