/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.text;

import java.math.BigInteger;

public final class DoubleSynthesizerGenerator {
    private DoubleSynthesizerGenerator() {
    }

    public static void main(String[] args) {
        long[] mantissaList = new long[660];
        long[] expList = new long[660];
        int binOneShift = 1280;
        BigInteger binOne = BigInteger.ONE.shiftLeft(binOneShift);
        BigInteger dec = BigInteger.valueOf(1000000000000000000L);
        for (int i = 0; i <= 330; ++i) {
            BigInteger quot = binOne.divide(dec);
            mantissaList[330 - i] = DoubleSynthesizerGenerator.extractLong(quot);
            int exp = quot.bitLength() - binOneShift + 57;
            expList[330 - i] = 1023 + exp;
            dec = dec.multiply(BigInteger.valueOf(10L));
        }
        dec = BigInteger.valueOf(1000000000000000000L);
        BigInteger q = BigInteger.TEN;
        for (int i = 1; i < 330; ++i) {
            BigInteger quot = q.shiftLeft(binOneShift).divide(dec);
            mantissaList[330 + i] = DoubleSynthesizerGenerator.extractLong(quot);
            int exp = quot.bitLength() - binOneShift + 57;
            expList[330 + i] = 1023 + exp;
            q = q.multiply(BigInteger.TEN);
        }
        System.out.println("[mantissa]");
        for (long value : mantissaList) {
            System.out.println(value + "L,");
        }
        System.out.println();
        System.out.println("[exponent]");
        for (long value : expList) {
            System.out.println(value + ",");
        }
    }

    private static long extractLong(BigInteger n) {
        return n.shiftRight(n.bitLength() - 65).add(BigInteger.ONE).shiftRight(1).longValue();
    }
}

