/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.reflection;

import java.util.List;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.classlib.impl.reflection.ReflectionMethods;
import org.teavm.model.ClassReader;
import org.teavm.model.GenericTypeParameter;
import org.teavm.model.GenericValueType;
import org.teavm.model.MethodReader;
import org.teavm.model.ValueType;

class WasmGCReflectionGenericsHelper {
    private WasmGCIntrinsicContext context;
    private WasmFunction function;
    private WasmFunction variableConstructor;
    private WasmFunction variableConstructorWithBounds;
    private WasmFunction stubCreate;
    private WasmFunction stubCreateWithLevel;

    WasmGCReflectionGenericsHelper(WasmGCIntrinsicContext context, WasmFunction function) {
        this.context = context;
        this.function = function;
    }

    void initReflectionGenericsForClasses() {
        boolean withBounds = this.context.dependency().getMethod(ReflectionMethods.TYPE_VAR_GET_BOUNDS) != null;
        for (String className : this.context.dependency().getReachableClasses()) {
            ClassReader cls = this.context.hierarchy().getClassSource().get(className);
            if (cls == null) continue;
            this.initTypeParameters(cls, withBounds);
        }
    }

    private void initTypeParameters(ClassReader cls, boolean withBounds) {
        GenericTypeParameter[] params = cls.getGenericParameters();
        if (params == null || params.length == 0) {
            return;
        }
        WasmExpression array = this.writeTypeParameters(params, cls, null, withBounds);
        int fieldOffset = this.context.classInfoProvider().getClassTypeParametersOffset();
        WasmGCClassInfo clsInfo = this.context.classInfoProvider().getClassInfo(cls.getName());
        WasmGCClassInfo clsCls = this.context.classInfoProvider().getClassInfo("java.lang.Class");
        this.function.getBody().add(new WasmStructSet(clsCls.getStructure(), new WasmGetGlobal(clsInfo.getPointer()), fieldOffset, array));
    }

    private WasmExpression generateTypeParameterBounds(ClassReader cls, MethodReader method, List<GenericValueType.Reference> bounds) {
        WasmArray arrayType = this.context.classInfoProvider().getObjectArrayType();
        WasmArrayNewFixed array = new WasmArrayNewFixed(arrayType);
        for (GenericValueType.Reference bound : bounds) {
            array.getElements().add(this.writeGenericType(cls, method, bound));
        }
        return array;
    }

    WasmExpression writeTypeParameters(GenericTypeParameter[] params, ClassReader cls, MethodReader method, boolean withBounds) {
        WasmArray arrayType = this.context.classInfoProvider().getObjectArrayType();
        WasmArrayNewFixed array = new WasmArrayNewFixed(arrayType);
        for (GenericTypeParameter param : params) {
            List<Object> bounds;
            WasmGetGlobal nameRef = new WasmGetGlobal(this.context.strings().getStringConstant((String)param.getName()).global);
            List<Object> list = bounds = withBounds ? param.extractAllBounds() : List.of();
            if (bounds.isEmpty()) {
                array.getElements().add(new WasmCall(this.getVariableConstructor(), nameRef));
                continue;
            }
            array.getElements().add(new WasmCall(this.getVariableConstructorWithBounds(), nameRef, this.generateTypeParameterBounds(cls, method, bounds)));
        }
        return array;
    }

    WasmExpression writeGenericType(ClassReader contextClass, MethodReader contextMethod, GenericValueType type) {
        if (type instanceof GenericValueType.Object) {
            GenericValueType.Object objectType = (GenericValueType.Object)type;
            GenericValueType.Argument[] args = objectType.getArguments();
            WasmGCClassInfo clsInfo = this.context.classInfoProvider().getClassInfo(objectType.getFullClassName());
            WasmGetGlobal cls = new WasmGetGlobal(clsInfo.getPointer());
            if (args.length == 0) {
                return cls;
            }
            WasmArray arrayType = this.context.classInfoProvider().getObjectArrayType();
            WasmArrayNewFixed array = new WasmArrayNewFixed(arrayType);
            for (GenericValueType.Argument arg : args) {
                array.getElements().add(this.writeGenericType(contextClass, contextMethod, arg));
            }
            if (objectType.getParent() == null) {
                WasmFunction constructor = this.context.functions().forStaticMethod(ReflectionMethods.PARAM_TYPE_CREATE);
                return new WasmCall(constructor, cls, array);
            }
            WasmExpression owner = this.writeGenericType(contextClass, contextMethod, objectType.getParent());
            WasmFunction constructor = this.context.functions().forStaticMethod(ReflectionMethods.PARAM_TYPE_CREATE_OWNER);
            return new WasmCall(constructor, cls, array, owner);
        }
        if (type instanceof GenericValueType.Variable) {
            GenericTypeParameter param;
            int i;
            GenericTypeParameter[] genericParameters;
            GenericValueType.Variable typeVar = (GenericValueType.Variable)type;
            int level = 0;
            if (contextMethod != null) {
                genericParameters = contextMethod.getTypeParameters();
                for (i = 0; i < genericParameters.length; ++i) {
                    param = genericParameters[i];
                    if (!param.getName().equals(typeVar.getName())) continue;
                    return new WasmCall(this.getStubCreate(), new WasmInt32Constant(i));
                }
                ++level;
            }
            while (contextClass != null) {
                genericParameters = contextClass.getGenericParameters();
                if (genericParameters != null) {
                    for (i = 0; i < genericParameters.length; ++i) {
                        param = genericParameters[i];
                        if (!param.getName().equals(typeVar.getName())) continue;
                        if (level == 0) {
                            return new WasmCall(this.getStubCreate(), new WasmInt32Constant(i));
                        }
                        return new WasmCall(this.getStubCreateWithLevel(), new WasmInt32Constant(i), new WasmInt32Constant(level));
                    }
                }
                ++level;
                if (contextClass.getOwnerName() == null) break;
                contextClass = this.context.hierarchy().getClassSource().get(contextClass.getOwnerName());
            }
            throw new IllegalArgumentException("Unknown type variable: " + typeVar.getName());
        }
        if (type instanceof GenericValueType.Array) {
            ValueType nonGenericType = type.asValueType();
            if (nonGenericType == null) {
                GenericValueType.Array arrayType = (GenericValueType.Array)type;
                WasmFunction constructor = this.context.functions().forStaticMethod(ReflectionMethods.GENERIC_ARRAY_TYPE_CREATE);
                return new WasmCall(constructor, this.writeGenericType(contextClass, contextMethod, arrayType.getItemType()));
            }
            WasmGCClassInfo typeRef = this.context.classInfoProvider().getClassInfo(nonGenericType);
            return new WasmGetGlobal(typeRef.getPointer());
        }
        if (type instanceof GenericValueType.Primitive) {
            GenericValueType.Primitive primitiveType = (GenericValueType.Primitive)type;
            WasmGCClassInfo typeRef = this.context.classInfoProvider().getClassInfo(ValueType.primitive(primitiveType.getKind()));
            return new WasmGetGlobal(typeRef.getPointer());
        }
        if (type instanceof GenericValueType.Void) {
            WasmGCClassInfo typeRef = this.context.classInfoProvider().getClassInfo(ValueType.VOID);
            return new WasmGetGlobal(typeRef.getPointer());
        }
        throw new IllegalArgumentException("Unsupported generic type: " + String.valueOf(type));
    }

    private WasmExpression writeGenericType(ClassReader contextClass, MethodReader contextMethod, GenericValueType.Argument arg) {
        switch (arg.getKind()) {
            case INVARIANT: {
                return this.writeGenericType(contextClass, contextMethod, arg.getValue());
            }
            case ANY: {
                WasmFunction function = this.context.functions().forStaticMethod(ReflectionMethods.WILDCARD_TYPE_UPPER);
                WasmGCClassInfo typeType = this.context.classInfoProvider().getClassInfo("java.lang.reflect.Type");
                return new WasmCall(function, new WasmNullConstant(typeType.getType()));
            }
            case COVARIANT: {
                WasmFunction function = this.context.functions().forStaticMethod(ReflectionMethods.WILDCARD_TYPE_UPPER);
                return new WasmCall(function, this.writeGenericType(contextClass, contextMethod, arg.getValue()));
            }
            case CONTRAVARIANT: {
                WasmFunction function = this.context.functions().forStaticMethod(ReflectionMethods.WILDCARD_TYPE_LOWER);
                return new WasmCall(function, this.writeGenericType(contextClass, contextMethod, arg.getValue()));
            }
        }
        throw new IllegalArgumentException("Unsupported generic type: " + String.valueOf((Object)arg.getKind()));
    }

    private WasmFunction getVariableConstructor() {
        if (this.variableConstructor == null) {
            this.variableConstructor = this.context.functions().forStaticMethod(ReflectionMethods.TYPE_VAR_CREATE);
        }
        return this.variableConstructor;
    }

    private WasmFunction getVariableConstructorWithBounds() {
        if (this.variableConstructorWithBounds == null) {
            this.variableConstructorWithBounds = this.context.functions().forStaticMethod(ReflectionMethods.TYPE_VAR_CREATE_BOUNDS);
        }
        return this.variableConstructorWithBounds;
    }

    private WasmFunction getStubCreate() {
        if (this.stubCreate == null) {
            this.stubCreate = this.context.functions().forStaticMethod(ReflectionMethods.TYPE_VAR_STUB_CREATE);
        }
        return this.stubCreate;
    }

    private WasmFunction getStubCreateWithLevel() {
        if (this.stubCreateWithLevel == null) {
            this.stubCreateWithLevel = this.context.functions().forStaticMethod(ReflectionMethods.TYPE_VAR_STUB_CREATE_LEVEL);
        }
        return this.stubCreateWithLevel;
    }
}

