/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.currency;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.teavm.classlib.impl.currency.CurrencyResourceBuilder;
import org.teavm.common.binary.BinaryParser;
import org.teavm.common.binary.Blob;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.builders.ResourceArrayBuilder;
import org.teavm.platform.metadata.builders.ResourceBuilder;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CurrenciesGenerator
implements MetadataGenerator {
    @Override
    public ResourceBuilder generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        byte[] bytes;
        try (InputStream input = context.getResourceProvider().getResource("org/teavm/classlib/impl/currency/iso4217.bin").open();){
            bytes = input.readAllBytes();
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading ISO 4217 metadata from file");
        }
        return CurrenciesGenerator.parseBinaryData(bytes);
    }

    public static void main(String[] args) throws IOException {
        Document doc;
        try (FileInputStream input = new FileInputStream(args[0]);){
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(new BufferedInputStream(input));
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Error reading ISO 4217 metadata from file");
        }
        byte[] binaryData = CurrenciesGenerator.convertToBinary(doc);
        try (FileOutputStream output = new FileOutputStream(args[1]);){
            output.write(binaryData);
        }
    }

    private static void extractCurrencyData(Element tableElem, List<CurrencyData> currencies) {
        for (Element currencyElem : CurrenciesGenerator.childElements(tableElem)) {
            if (!currencyElem.getTagName().equals("CcyNtry")) continue;
            CurrencyData currency = new CurrencyData();
            boolean hasCode = false;
            for (Element propertyElem : CurrenciesGenerator.childElements(currencyElem)) {
                switch (propertyElem.getTagName()) {
                    case "Ccy": {
                        currency.code = CurrenciesGenerator.getText(propertyElem);
                        hasCode = true;
                        break;
                    }
                    case "CcyNbr": {
                        currency.numericCode = Integer.parseInt(CurrenciesGenerator.getText(propertyElem));
                        break;
                    }
                    case "CcyMnrUnts": {
                        String value = CurrenciesGenerator.getText(propertyElem);
                        currency.fractionDigits = value.equals("N.A.") ? -1 : Integer.parseInt(value);
                    }
                }
            }
            if (!hasCode) continue;
            currencies.add(currency);
        }
    }

    private void parseCurrencies(Element tableElem, ResourceArrayBuilder<CurrencyResourceBuilder> currencies) {
        for (Element currencyElem : CurrenciesGenerator.childElements(tableElem)) {
            if (!currencyElem.getTagName().equals("CcyNtry")) continue;
            CurrencyResourceBuilder currency = new CurrencyResourceBuilder();
            for (Element propertyElem : CurrenciesGenerator.childElements(currencyElem)) {
                switch (propertyElem.getTagName()) {
                    case "Ccy": {
                        currency.code = CurrenciesGenerator.getText(propertyElem);
                        break;
                    }
                    case "CcyNbr": {
                        currency.numericCode = Integer.parseInt(CurrenciesGenerator.getText(propertyElem));
                        break;
                    }
                    case "CcyMnrUnts": {
                        String value = CurrenciesGenerator.getText(propertyElem);
                        currency.fractionDigits = value.equals("N.A.") ? -1 : Integer.parseInt(value);
                    }
                }
            }
            currencies.values.add(currency);
        }
    }

    private static Iterable<Element> childElements(final Element parent) {
        return new Iterable<Element>(){
            NodeList nodes;
            {
                this.nodes = parent.getChildNodes();
            }

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){
                    int index = -1;
                    {
                        this.following();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Element next() {
                        Element result = (Element)nodes.item(this.index);
                        this.following();
                        return result;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < nodes.getLength();
                    }

                    private void following() {
                        while (++this.index < nodes.getLength() && nodes.item(this.index).getNodeType() != 1) {
                        }
                    }
                };
            }
        };
    }

    private static String getText(Element element) {
        StringBuilder sb = new StringBuilder();
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData cdata = (CharacterData)child;
                    sb.append(cdata.getData());
                    continue block4;
                }
                case 5: {
                    EntityReference ref = (EntityReference)child;
                    sb.append(ref.getNodeValue());
                }
            }
        }
        return sb.toString();
    }

    private static byte[] convertToBinary(Document doc) {
        Blob output = new Blob();
        ArrayList<CurrencyData> currencies = new ArrayList<CurrencyData>();
        Element root = doc.getDocumentElement();
        for (Element elem : CurrenciesGenerator.childElements(root)) {
            if (!elem.getTagName().equals("CcyTbl")) continue;
            CurrenciesGenerator.extractCurrencyData(elem, currencies);
        }
        output.writeLEB(currencies.size());
        for (CurrencyData currency : currencies) {
            output.writeString(currency.code);
            output.writeLEB(currency.numericCode);
            output.writeLEB(currency.fractionDigits + 1);
        }
        return output.toArray();
    }

    private static ResourceBuilder parseBinaryData(byte[] data) {
        ResourceArrayBuilder currencies = new ResourceArrayBuilder();
        BinaryParser input = new BinaryParser();
        input.data = data;
        int count = input.readLEB();
        for (int i = 0; i < count; ++i) {
            CurrencyResourceBuilder currency = new CurrencyResourceBuilder();
            currency.code = input.readString();
            currency.numericCode = input.readLEB();
            currency.fractionDigits = input.readLEB() - 1;
            currencies.values.add(currency);
        }
        return currencies;
    }

    private static class CurrencyData {
        String code;
        int numericCode;
        int fractionDigits;

        private CurrencyData() {
        }
    }
}

