/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.Arrays;

public final class Base64Impl {
    public static byte[] alphabet;
    public static byte[] urlAlphabet;
    public static int[] reverse;
    public static int[] urlReverse;

    private Base64Impl() {
    }

    public static byte[] decode(byte[] text, int[] mapping) {
        int outputSize = text.length / 4 * 3;
        int rem = text.length % 4;
        if (rem == 2 || rem == 3) {
            outputSize += rem - 1;
        }
        for (int i = text.length - 1; i >= 0 && text[i] == 61; --i) {
            --outputSize;
        }
        byte[] output = new byte[outputSize];
        Base64Impl.decode(text, output, mapping);
        return output;
    }

    public static byte[] decode(byte[] text) {
        return Base64Impl.decode(text, reverse);
    }

    public static void decode(byte[] text, byte[] output, int[] mapping) {
        int b;
        int a;
        int i;
        int inputSize = text.length;
        for (i = text.length - 1; i >= 0 && text[i] == 61; --i) {
            --inputSize;
        }
        int triples = inputSize / 4 * 4;
        i = 0;
        int j = 0;
        while (i < triples) {
            int a2 = Base64Impl.decode(mapping, text[i++]);
            int b2 = Base64Impl.decode(mapping, text[i++]);
            int c = Base64Impl.decode(mapping, text[i++]);
            int d = Base64Impl.decode(mapping, text[i++]);
            int out = a2 << 18 | b2 << 12 | c << 6 | d;
            output[j++] = (byte)(out >>> 16);
            output[j++] = (byte)(out >>> 8);
            output[j++] = (byte)out;
        }
        int rem = inputSize - i;
        if (rem == 2) {
            a = Base64Impl.decode(mapping, text[i]);
            b = Base64Impl.decode(mapping, text[i + 1]);
            output[j] = (byte)(a << 2 | b >>> 4);
        } else if (rem == 3) {
            a = Base64Impl.decode(mapping, text[i]);
            b = Base64Impl.decode(mapping, text[i + 1]);
            int c = Base64Impl.decode(mapping, text[i + 2]);
            output[j] = (byte)(a << 2 | b >>> 4);
            output[j + 1] = (byte)(b << 4 | c >>> 2);
        }
    }

    private static int decode(int[] mapping, byte c) {
        return mapping[c];
    }

    public static byte[] encode(byte[] data, byte[] mapping, boolean pad) {
        int rem;
        int outputSize = (data.length + 2) / 3 * 4;
        if (!pad && (rem = data.length % 3) != 0) {
            outputSize -= 3 - rem;
        }
        byte[] output = new byte[outputSize];
        Base64Impl.encode(data, output, mapping, pad);
        return output;
    }

    public static byte[] encode(byte[] data, boolean pad) {
        return Base64Impl.encode(data, alphabet, pad);
    }

    public static int encode(byte[] data, byte[] output, byte[] mapping, boolean pad) {
        int j;
        int triples = data.length / 3 * 3;
        int i = 0;
        for (j = 0; j < triples; ++j) {
            output[i++] = Base64Impl.encode(mapping, (byte)(data[j] >>> 2));
            output[i++] = Base64Impl.encode(mapping, (byte)(data[j] << 4 | (data[j + 1] & 0xFF) >>> 4));
            output[i++] = Base64Impl.encode(mapping, (byte)(data[++j] << 2 | (data[j + 1] & 0xFF) >>> 6));
            output[i++] = Base64Impl.encode(mapping, data[++j]);
        }
        int rem = data.length - j;
        if (rem == 1) {
            output[i++] = Base64Impl.encode(mapping, (byte)(data[j] >>> 2));
            output[i++] = Base64Impl.encode(mapping, (byte)(data[j] << 4));
            if (pad) {
                output[i++] = 61;
                output[i++] = 61;
            }
        } else if (rem == 2) {
            output[i++] = Base64Impl.encode(mapping, (byte)(data[j] >>> 2));
            output[i++] = Base64Impl.encode(mapping, (byte)(data[j] << 4 | (data[j + 1] & 0xFF) >>> 4));
            output[i++] = Base64Impl.encode(mapping, (byte)(data[++j] << 2));
            if (pad) {
                output[i++] = 61;
            }
        }
        return i;
    }

    private static byte encode(byte[] mapping, byte b) {
        return mapping[b & 0x3F];
    }

    static {
        int c;
        alphabet = new byte[64];
        urlAlphabet = new byte[64];
        reverse = new int[256];
        urlReverse = new int[256];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64Impl.alphabet[i] = (byte)c;
            Base64Impl.urlAlphabet[i] = (byte)c;
            ++i;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64Impl.alphabet[i] = (byte)c;
            Base64Impl.urlAlphabet[i] = (byte)c;
            ++i;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64Impl.alphabet[i] = (byte)c;
            Base64Impl.urlAlphabet[i] = (byte)c;
            ++i;
        }
        Base64Impl.alphabet[i] = 43;
        Base64Impl.urlAlphabet[i] = 45;
        Base64Impl.alphabet[++i] = 47;
        Base64Impl.urlAlphabet[i] = 95;
        ++i;
        Arrays.fill(reverse, -1);
        Arrays.fill(urlReverse, -1);
        for (i = 0; i < alphabet.length; ++i) {
            Base64Impl.reverse[Base64Impl.alphabet[i]] = i;
            Base64Impl.urlReverse[Base64Impl.urlAlphabet[i]] = i;
        }
    }
}

