/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.transformation.gc;

import java.util.LinkedHashSet;
import java.util.Set;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCastBranch;
import org.teavm.backend.wasm.model.expression.WasmDefaultExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.transformation.SuspensionPointCollector;

class NonOptimizableBlockCollector
extends WasmDefaultExpressionVisitor {
    SuspensionPointCollector suspendable;
    Set<WasmBlock> nonOptimizableBlocks;
    private Set<WasmBlock> breakTargets;
    private boolean isInSuspendingBlock = true;
    private WasmBlock currentBlock;

    NonOptimizableBlockCollector() {
    }

    @Override
    public void visit(WasmBlock expression) {
        boolean oldIsInSuspendingBlock = this.isInSuspendingBlock;
        WasmBlock oldCurrentBlock = this.currentBlock;
        Set<WasmBlock> oldBreakTargets = this.breakTargets;
        this.isInSuspendingBlock = this.suspendable.isSuspending(expression);
        this.currentBlock = expression;
        this.breakTargets = new LinkedHashSet<WasmBlock>();
        super.visit(expression);
        if (this.nonOptimizableBlocks.contains(expression)) {
            this.nonOptimizableBlocks.addAll(this.breakTargets);
        }
        this.isInSuspendingBlock = oldIsInSuspendingBlock;
        this.currentBlock = oldCurrentBlock;
        this.breakTargets = oldBreakTargets;
    }

    @Override
    public void visit(WasmBreak expression) {
        super.visit(expression);
        this.visitBranch(expression.getTarget());
    }

    @Override
    public void visit(WasmBranch expression) {
        super.visit(expression);
        this.visitBranch(expression.getTarget());
    }

    @Override
    public void visit(WasmCastBranch expression) {
        super.visit(expression);
        this.visitBranch(expression.getTarget());
    }

    @Override
    public void visit(WasmNullBranch expression) {
        super.visit(expression);
        this.visitBranch(expression.getTarget());
    }

    private void visitBranch(WasmBlock target) {
        if (!this.isInSuspendingBlock && this.suspendable.isSuspending(target)) {
            this.nonOptimizableBlocks.add(target);
        }
        this.breakTargets.add(target);
    }
}

