/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.util.Collections;
import java.util.List;
import org.teavm.backend.wasm.model.WasmBlockType;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmCastBranch;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmCopy;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmExternConversion;
import org.teavm.backend.wasm.model.expression.WasmFill;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatType;
import org.teavm.backend.wasm.model.expression.WasmFloatUnary;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt31Get;
import org.teavm.backend.wasm.model.expression.WasmInt31Reference;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIsNull;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmMemoryGrow;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullCondition;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmPop;
import org.teavm.backend.wasm.model.expression.WasmPush;
import org.teavm.backend.wasm.model.expression.WasmReferencesEqual;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmTest;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmTry;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;

public class WasmTypeInference
implements WasmExpressionVisitor {
    private List<? extends WasmType> result;

    public List<? extends WasmType> getResult() {
        return this.result;
    }

    public WasmType getSingleResult() {
        if (this.result.isEmpty()) {
            return null;
        }
        if (this.result.size() != 1) {
            throw new IllegalStateException("Can't get single result from multi-value expression");
        }
        return this.result.get(0);
    }

    private void setSingleType(WasmType type) {
        this.result = type == null ? Collections.emptyList() : List.of(type);
    }

    private void setBlockType(WasmBlockType type) {
        if (type == null) {
            this.result = Collections.emptyList();
        } else if (type instanceof WasmBlockType.Function) {
            WasmFunctionType function = ((WasmBlockType.Function)type).ref;
            this.result = function.getReturnTypes();
        } else {
            this.result = List.of(((WasmBlockType.Value)type).type);
        }
    }

    @Override
    public void visit(WasmBlock expression) {
        this.setBlockType(expression.getType());
    }

    @Override
    public void visit(WasmBranch expression) {
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
        } else {
            this.result = Collections.emptyList();
        }
    }

    @Override
    public void visit(WasmNullBranch expression) {
        if (expression.getCondition() == WasmNullCondition.NULL) {
            expression.getValue().acceptVisitor(this);
        } else if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
        } else {
            this.result = Collections.emptyList();
        }
    }

    @Override
    public void visit(WasmCastBranch expression) {
        switch (expression.getCondition()) {
            case SUCCESS: {
                this.result = List.of(expression.getSourceType());
                break;
            }
            case FAILURE: {
                this.setSingleType(expression.getType());
            }
        }
    }

    @Override
    public void visit(WasmBreak expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmSwitch expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmConditional expression) {
        this.setBlockType(expression.getType());
    }

    @Override
    public void visit(WasmReturn expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmUnreachable expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmInt32Constant expression) {
        this.result = List.of(WasmType.INT32);
    }

    @Override
    public void visit(WasmInt64Constant expression) {
        this.result = List.of(WasmType.INT64);
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
        this.result = List.of(WasmType.FLOAT32);
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
        this.result = List.of(WasmType.FLOAT64);
    }

    @Override
    public void visit(WasmGetLocal expression) {
        this.result = List.of(expression.getLocal().getType());
    }

    @Override
    public void visit(WasmSetLocal expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmGetGlobal expression) {
        this.result = List.of(expression.getGlobal().getType());
    }

    @Override
    public void visit(WasmSetGlobal expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmIntBinary expression) {
        this.result = List.of(WasmTypeInference.map(expression.getType()));
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        this.result = List.of(WasmTypeInference.map(expression.getType()));
    }

    @Override
    public void visit(WasmIntUnary expression) {
        this.result = List.of(WasmTypeInference.map(expression.getType()));
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        this.result = List.of(WasmTypeInference.map(expression.getType()));
    }

    @Override
    public void visit(WasmConversion expression) {
        this.result = List.of(WasmType.num(expression.getTargetType()));
    }

    @Override
    public void visit(WasmNullConstant expression) {
        this.result = List.of(expression.type);
    }

    @Override
    public void visit(WasmIsNull expression) {
        this.result = List.of(WasmType.INT32);
    }

    @Override
    public void visit(WasmCall expression) {
        WasmFunction function = expression.getFunction();
        this.result = function == null ? null : function.getType().getReturnTypes();
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        this.result = expression.getType().getReturnTypes();
    }

    @Override
    public void visit(WasmCallReference expression) {
        this.result = expression.getType().getReturnTypes();
    }

    @Override
    public void visit(WasmDrop expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        this.result = List.of(WasmType.INT32);
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        this.result = List.of(WasmType.INT64);
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        this.result = List.of(WasmType.FLOAT32);
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        this.result = List.of(WasmType.FLOAT64);
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmMemoryGrow expression) {
        this.result = List.of(WasmType.INT32);
    }

    @Override
    public void visit(WasmFill expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmCopy expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmTry expression) {
        this.result = List.of(expression.getType());
    }

    @Override
    public void visit(WasmThrow expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmReferencesEqual expression) {
        this.result = List.of(WasmType.INT32);
    }

    @Override
    public void visit(WasmCast expression) {
        this.result = List.of(expression.getTargetType());
    }

    @Override
    public void visit(WasmTest expression) {
        this.result = List.of(WasmType.INT32);
    }

    @Override
    public void visit(WasmExternConversion expression) {
        switch (expression.getType()) {
            case EXTERN_TO_ANY: {
                this.result = List.of(WasmType.Reference.ANY);
                break;
            }
            case ANY_TO_EXTERN: {
                this.result = List.of(WasmType.Reference.EXTERN);
            }
        }
    }

    @Override
    public void visit(WasmStructNew expression) {
        this.result = List.of(expression.getType().getReference());
    }

    @Override
    public void visit(WasmStructNewDefault expression) {
        this.result = List.of(expression.getType().getReference());
    }

    @Override
    public void visit(WasmStructGet expression) {
        this.result = List.of(expression.getType().getFields().get(expression.getFieldIndex()).getUnpackedType());
    }

    @Override
    public void visit(WasmStructSet expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmArrayNewDefault expression) {
        this.result = List.of(expression.getType().getReference());
    }

    @Override
    public void visit(WasmArrayNewFixed expression) {
        this.result = List.of(expression.getType().getReference());
    }

    @Override
    public void visit(WasmArrayGet expression) {
        this.result = List.of(expression.getType().getElementType().asUnpackedType());
    }

    @Override
    public void visit(WasmArraySet expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmArrayLength expression) {
        this.result = List.of(WasmType.INT32);
    }

    @Override
    public void visit(WasmArrayCopy expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmFunctionReference expression) {
        this.result = List.of(expression.getFunction().getType().getReference());
    }

    @Override
    public void visit(WasmInt31Get expression) {
        this.result = List.of(WasmType.INT32);
    }

    @Override
    public void visit(WasmInt31Reference expression) {
        this.result = List.of(WasmType.Reference.I31);
    }

    @Override
    public void visit(WasmPush expression) {
        this.result = Collections.emptyList();
    }

    @Override
    public void visit(WasmPop expression) {
        this.result = List.of(expression.getType());
    }

    private static WasmType map(WasmIntType type) {
        switch (type) {
            case INT32: {
                return WasmType.INT32;
            }
            case INT64: {
                return WasmType.INT64;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    private static WasmType map(WasmFloatType type) {
        switch (type) {
            case FLOAT32: {
                return WasmType.FLOAT32;
            }
            case FLOAT64: {
                return WasmType.FLOAT64;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }
}

