/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.annotations;

import java.util.List;
import java.util.function.Consumer;
import org.teavm.backend.wasm.generate.gc.annotations.WasmGCAnnotationsHelper;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringProvider;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.analysis.ClassMetadataRequirements;

public class WasmGCAnnotationsGenerator {
    private ClassReaderSource classes;
    private ClassMetadataRequirements metadataRequirements;
    private WasmGCClassGenerator classInfoProvider;
    private List<Consumer<WasmFunction>> parts;
    private WasmGCAnnotationsHelper helper;

    public WasmGCAnnotationsGenerator(ClassReaderSource classes, ClassMetadataRequirements metadataRequirements, WasmGCClassGenerator classInfoProvider, WasmGCStringProvider stringProvider, List<Consumer<WasmFunction>> parts) {
        this.helper = new WasmGCAnnotationsHelper(classes, classInfoProvider, stringProvider);
        this.classes = classes;
        this.metadataRequirements = metadataRequirements;
        this.classInfoProvider = classInfoProvider;
        this.parts = parts;
    }

    public void addClassAnnotations(String className, WasmGCClassInfo classInfo) {
        ClassReader cls = this.classes.get(className);
        if (cls == null) {
            return;
        }
        ClassMetadataRequirements.Info info = this.metadataRequirements.getInfo(className);
        if (!info.annotations()) {
            return;
        }
        WasmExpression annotationsExpr = this.helper.generateAnnotations(cls.getAnnotations().all());
        if (annotationsExpr == null) {
            return;
        }
        WasmGlobal global = classInfo.getPointer();
        WasmGCClassInfo classClass = this.classInfoProvider.getClassInfo("java.lang.Class");
        WasmStructSet setAnnotations = new WasmStructSet(classClass.getStructure(), new WasmGetGlobal(global), this.classInfoProvider.getClassAnnotationsOffset(), annotationsExpr);
        this.parts.add(f -> f.getBody().add(setAnnotations));
    }
}

