/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.common.methods;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.teavm.ast.ArrayType;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.BinaryExpr;
import org.teavm.ast.BlockStatement;
import org.teavm.ast.BoundCheckExpr;
import org.teavm.ast.BreakStatement;
import org.teavm.ast.CastExpr;
import org.teavm.ast.ConditionalExpr;
import org.teavm.ast.ConditionalStatement;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.ContinueStatement;
import org.teavm.ast.Expr;
import org.teavm.ast.ExprVisitor;
import org.teavm.ast.GotoPartStatement;
import org.teavm.ast.IdentifiedStatement;
import org.teavm.ast.InitClassStatement;
import org.teavm.ast.InstanceOfExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.InvocationType;
import org.teavm.ast.MonitorEnterStatement;
import org.teavm.ast.MonitorExitStatement;
import org.teavm.ast.NewExpr;
import org.teavm.ast.NewMultiArrayExpr;
import org.teavm.ast.OperationType;
import org.teavm.ast.PrimitiveCastExpr;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.ReturnStatement;
import org.teavm.ast.SequentialStatement;
import org.teavm.ast.Statement;
import org.teavm.ast.StatementVisitor;
import org.teavm.ast.SubscriptExpr;
import org.teavm.ast.SwitchClause;
import org.teavm.ast.SwitchStatement;
import org.teavm.ast.ThrowStatement;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.UnaryExpr;
import org.teavm.ast.UnwrapArrayExpr;
import org.teavm.ast.VariableExpr;
import org.teavm.ast.WhileStatement;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.generate.CachedExpression;
import org.teavm.backend.wasm.generate.ExpressionCache;
import org.teavm.backend.wasm.generate.TemporaryVariablePool;
import org.teavm.backend.wasm.generate.WasmGeneratorUtil;
import org.teavm.backend.wasm.generate.common.methods.BaseWasmGenerationContext;
import org.teavm.backend.wasm.model.WasmBlockType;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmNumType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCatch;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmFloatType;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIntUnaryOperation;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmTry;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.backend.wasm.render.WasmTypeInference;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;

public abstract class BaseWasmGenerationVisitor
implements StatementVisitor,
ExprVisitor {
    private static final MethodReference MONITOR_ENTER_SYNC = new MethodReference(Object.class, "monitorEnterSync", Object.class, Void.TYPE);
    private static final MethodReference MONITOR_EXIT_SYNC = new MethodReference(Object.class, "monitorExitSync", Object.class, Void.TYPE);
    private static final MethodReference MONITOR_ENTER = new MethodReference(Object.class, "monitorEnter", Object.class, Void.TYPE);
    private static final MethodReference MONITOR_EXIT = new MethodReference(Object.class, "monitorExit", Object.class, Void.TYPE);
    private static final int SWITCH_TABLE_THRESHOLD = 256;
    private BaseWasmGenerationContext context;
    protected final MethodReference currentMethod;
    protected final WasmTypeInference typeInference;
    protected final WasmFunction function;
    private int firstVariable;
    private IdentifiedStatement currentContinueTarget;
    private IdentifiedStatement currentBreakTarget;
    private Map<IdentifiedStatement, WasmBlock> breakTargets = new HashMap<IdentifiedStatement, WasmBlock>();
    private Map<IdentifiedStatement, WasmBlock> continueTargets = new HashMap<IdentifiedStatement, WasmBlock>();
    private Set<WasmBlock> usedBlocks = new HashSet<WasmBlock>();
    protected final TemporaryVariablePool tempVars;
    protected final ExpressionCache exprCache;
    private boolean async;
    protected WasmExpression result;
    protected List<WasmExpression> resultConsumer;
    protected int blockLevel;
    private WasmBlock returnBlock;

    public BaseWasmGenerationVisitor(BaseWasmGenerationContext context, MethodReference currentMethod, WasmFunction function, int firstVariable, boolean async) {
        this.context = context;
        this.currentMethod = currentMethod;
        this.function = function;
        this.firstVariable = firstVariable;
        this.tempVars = new TemporaryVariablePool(function);
        this.exprCache = new ExpressionCache(this.tempVars);
        this.typeInference = new WasmTypeInference();
        this.async = async;
    }

    public void setReturnBlock(WasmBlock returnBlock) {
        this.returnBlock = returnBlock;
    }

    public void generate(Statement statement, List<WasmExpression> target) {
        this.resultConsumer = target;
        statement.acceptVisitor(this);
        this.resultConsumer = null;
    }

    protected void accept(Expr expr) {
        expr.acceptVisitor(this);
    }

    protected void accept(Statement statement) {
        statement.acceptVisitor(this);
    }

    @Override
    public void visit(BinaryExpr expr) {
        block0 : switch (expr.getOperation()) {
            case ADD: {
                this.generateBinary(WasmIntBinaryOperation.ADD, WasmFloatBinaryOperation.ADD, expr);
                break;
            }
            case SUBTRACT: {
                this.generateBinary(WasmIntBinaryOperation.SUB, WasmFloatBinaryOperation.SUB, expr);
                break;
            }
            case MULTIPLY: {
                this.generateBinary(WasmIntBinaryOperation.MUL, WasmFloatBinaryOperation.MUL, expr);
                break;
            }
            case DIVIDE: {
                this.generateBinary(WasmIntBinaryOperation.DIV_SIGNED, WasmFloatBinaryOperation.DIV, expr);
                break;
            }
            case MODULO: {
                switch (expr.getType()) {
                    case INT: 
                    case LONG: {
                        this.generateBinary(WasmIntBinaryOperation.REM_SIGNED, expr);
                        break block0;
                    }
                }
                Class<?> type = this.convertType(expr.getType());
                MethodReference method = new MethodReference(WasmRuntime.class, "remainder", type, type, type);
                WasmCall call = new WasmCall(this.context.functions().forStaticMethod(method));
                this.accept(expr.getFirstOperand());
                call.getArguments().add(this.result);
                this.accept(expr.getSecondOperand());
                call.getArguments().add(this.result);
                call.setLocation(expr.getLocation());
                this.result = call;
                break;
            }
            case BITWISE_AND: {
                this.generateBinary(WasmIntBinaryOperation.AND, expr);
                break;
            }
            case BITWISE_OR: {
                this.generateBinary(WasmIntBinaryOperation.OR, expr);
                break;
            }
            case BITWISE_XOR: {
                this.generateBinary(WasmIntBinaryOperation.XOR, expr);
                break;
            }
            case EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.EQ, WasmFloatBinaryOperation.EQ, expr);
                break;
            }
            case NOT_EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.NE, WasmFloatBinaryOperation.NE, expr);
                break;
            }
            case GREATER: {
                this.generateBinary(WasmIntBinaryOperation.GT_SIGNED, WasmFloatBinaryOperation.GT, expr);
                break;
            }
            case GREATER_OR_EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.GE_SIGNED, WasmFloatBinaryOperation.GE, expr);
                break;
            }
            case LESS: {
                this.generateBinary(WasmIntBinaryOperation.LT_SIGNED, WasmFloatBinaryOperation.LT, expr);
                break;
            }
            case LESS_OR_EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.LE_SIGNED, WasmFloatBinaryOperation.LE, expr);
                break;
            }
            case LEFT_SHIFT: {
                this.generateBinary(WasmIntBinaryOperation.SHL, expr);
                break;
            }
            case RIGHT_SHIFT: {
                this.generateBinary(WasmIntBinaryOperation.SHR_SIGNED, expr);
                break;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                this.generateBinary(WasmIntBinaryOperation.SHR_UNSIGNED, expr);
                break;
            }
            case COMPARE_GREATER: {
                Class<?> type = this.convertType(expr.getType());
                MethodReference method = new MethodReference(WasmRuntime.class, "compare", type, type, Integer.TYPE);
                WasmCall call = new WasmCall(this.context.functions().forStaticMethod(method));
                this.accept(expr.getFirstOperand());
                call.getArguments().add(this.result);
                this.accept(expr.getSecondOperand());
                call.getArguments().add(this.result);
                call.setLocation(expr.getLocation());
                this.result = call;
                break;
            }
            case COMPARE_LESS: {
                Class<?> type = this.convertType(expr.getType());
                String name = expr.getType() == OperationType.INT || expr.getType() == OperationType.LONG ? "compare" : "compareLess";
                MethodReference method = new MethodReference(WasmRuntime.class, name, type, type, Integer.TYPE);
                WasmCall call = new WasmCall(this.context.functions().forStaticMethod(method));
                this.accept(expr.getFirstOperand());
                call.getArguments().add(this.result);
                this.accept(expr.getSecondOperand());
                call.getArguments().add(this.result);
                call.setLocation(expr.getLocation());
                this.result = call;
                break;
            }
            case AND: {
                this.generateAnd(expr);
                break;
            }
            case OR: {
                this.generateOr(expr);
            }
        }
    }

    private void generateBinary(WasmIntBinaryOperation intOp, WasmFloatBinaryOperation floatOp, BinaryExpr expr) {
        this.accept(expr.getFirstOperand());
        WasmExpression first = this.result;
        this.accept(expr.getSecondOperand());
        WasmExpression second = this.result;
        if (expr.getType() == null) {
            this.result = new WasmIntBinary(WasmIntType.INT32, intOp, first, second);
        } else {
            switch (expr.getType()) {
                case INT: {
                    this.result = new WasmIntBinary(WasmIntType.INT32, intOp, first, second);
                    break;
                }
                case LONG: {
                    this.result = new WasmIntBinary(WasmIntType.INT64, intOp, first, second);
                    break;
                }
                case FLOAT: {
                    this.result = new WasmFloatBinary(WasmFloatType.FLOAT32, floatOp, first, second);
                    break;
                }
                case DOUBLE: {
                    this.result = new WasmFloatBinary(WasmFloatType.FLOAT64, floatOp, first, second);
                }
            }
        }
        this.result.setLocation(expr.getLocation());
    }

    private void generateBinary(WasmIntBinaryOperation intOp, BinaryExpr expr) {
        this.accept(expr.getFirstOperand());
        WasmExpression first = this.result;
        this.accept(expr.getSecondOperand());
        WasmExpression second = this.result;
        if (expr.getType() == OperationType.LONG) {
            switch (expr.getOperation()) {
                case LEFT_SHIFT: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    second = new WasmConversion(WasmNumType.INT32, WasmNumType.INT64, false, second);
                    break;
                }
            }
        }
        switch (expr.getType()) {
            case INT: {
                this.result = new WasmIntBinary(WasmIntType.INT32, intOp, first, second);
                break;
            }
            case LONG: {
                this.result = new WasmIntBinary(WasmIntType.INT64, intOp, first, second);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                throw new AssertionError((Object)("Can't translate operation " + String.valueOf((Object)intOp) + " for type " + String.valueOf((Object)expr.getType())));
            }
        }
        this.result.setLocation(expr.getLocation());
    }

    private Class<?> convertType(OperationType type) {
        switch (type) {
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
        }
        throw new AssertionError((Object)type.toString());
    }

    private void generateAnd(BinaryExpr expr) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32.asBlock());
        this.accept(expr.getFirstOperand());
        WasmBranch branch = new WasmBranch(BaseWasmGenerationVisitor.negate(this.result), block);
        branch.setResult(new WasmInt32Constant(0));
        branch.setLocation(expr.getLocation());
        branch.getResult().setLocation(expr.getLocation());
        block.getBody().add(new WasmDrop(branch));
        this.accept(expr.getSecondOperand());
        block.getBody().add(this.result);
        block.setLocation(expr.getLocation());
        this.result = block;
    }

    private void generateOr(BinaryExpr expr) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32.asBlock());
        this.accept(expr.getFirstOperand());
        WasmBranch branch = new WasmBranch(this.result, block);
        branch.setResult(new WasmInt32Constant(1));
        branch.setLocation(expr.getLocation());
        branch.getResult().setLocation(expr.getLocation());
        block.getBody().add(new WasmDrop(branch));
        this.accept(expr.getSecondOperand());
        block.getBody().add(this.result);
        block.setLocation(expr.getLocation());
        this.result = block;
    }

    @Override
    public void visit(UnaryExpr expr) {
        switch (expr.getOperation()) {
            case INT_TO_BYTE: {
                this.accept(expr.getOperand());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, this.result, new WasmInt32Constant(24));
                this.result.setLocation(expr.getLocation());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_SIGNED, this.result, new WasmInt32Constant(24));
                this.result.setLocation(expr.getLocation());
                break;
            }
            case INT_TO_SHORT: {
                this.accept(expr.getOperand());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_SIGNED, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                break;
            }
            case INT_TO_CHAR: {
                this.accept(expr.getOperand());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_UNSIGNED, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                break;
            }
            case LENGTH: {
                this.accept(expr.getOperand());
                this.result = this.generateArrayLength(this.result);
                break;
            }
            case NOT: {
                this.accept(expr.getOperand());
                this.result = BaseWasmGenerationVisitor.negate(this.result);
                break;
            }
            case NEGATE: {
                this.accept(expr.getOperand());
                switch (expr.getType()) {
                    case INT: {
                        this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, new WasmInt32Constant(0), this.result);
                        this.result.setLocation(expr.getLocation());
                        break;
                    }
                    case LONG: {
                        this.result = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.SUB, new WasmInt64Constant(0L), this.result);
                        this.result.setLocation(expr.getLocation());
                        break;
                    }
                    case FLOAT: {
                        this.result = new WasmFloatBinary(WasmFloatType.FLOAT32, WasmFloatBinaryOperation.SUB, new WasmFloat32Constant(0.0f), this.result);
                        this.result.setLocation(expr.getLocation());
                        break;
                    }
                    case DOUBLE: {
                        this.result = new WasmFloatBinary(WasmFloatType.FLOAT64, WasmFloatBinaryOperation.SUB, new WasmFloat64Constant(0.0), this.result);
                        this.result.setLocation(expr.getLocation());
                    }
                }
                break;
            }
            case NULL_CHECK: {
                if (!this.isManaged()) {
                    expr.getOperand().acceptVisitor(this);
                    break;
                }
                this.result = this.nullCheck(expr.getOperand(), expr.getLocation());
            }
        }
    }

    protected abstract boolean isManaged();

    protected abstract boolean isManagedCall(MethodReference var1);

    protected WasmExpression nullCheck(Expr value, TextLocation location) {
        WasmBlock block = new WasmBlock(false);
        block.setLocation(location);
        this.accept(value);
        if (this.result instanceof WasmUnreachable) {
            return this.result;
        }
        this.result.acceptVisitor(this.typeInference);
        block.setType(this.typeInference.getSingleResult().asBlock());
        CachedExpression cachedValue = this.exprCache.create(this.result, this.typeInference.getSingleResult(), location, block.getBody());
        WasmBranch check = new WasmBranch(BaseWasmGenerationVisitor.negate(this.genIsNull(cachedValue.expr())), block);
        check.setResult(cachedValue.expr());
        block.getBody().add(new WasmDrop(check));
        CallSiteIdentifier callSiteId = this.generateCallSiteId(location);
        callSiteId.generateRegister(block.getBody(), location);
        this.generateThrowNPE(location, block.getBody());
        callSiteId.generateThrow(block.getBody(), location);
        cachedValue.release();
        return block;
    }

    protected abstract void generateThrowNPE(TextLocation var1, List<WasmExpression> var2);

    protected abstract WasmExpression generateArrayLength(WasmExpression var1);

    @Override
    public void visit(AssignmentStatement statement) {
        Expr left = statement.getLeftValue();
        if (left == null) {
            if (statement.getRightValue() instanceof InvocationExpr) {
                InvocationExpr invocation;
                this.invocation(invocation, this.resultConsumer, (invocation = (InvocationExpr)statement.getRightValue()).getMethod().getReturnType() != ValueType.VOID);
            } else {
                this.accept(statement.getRightValue());
                this.result.acceptVisitor(this.typeInference);
                if (this.typeInference.getResult() != null) {
                    this.result = new WasmDrop(this.result);
                    this.result.setLocation(statement.getLocation());
                }
                this.resultConsumer.add(this.result);
                this.result = null;
            }
        } else if (left instanceof VariableExpr) {
            VariableExpr varExpr = (VariableExpr)left;
            WasmLocal local = this.function.getLocalVariables().get(varExpr.getIndex() - this.firstVariable);
            this.accept(statement.getRightValue(), local.getType());
            WasmSetLocal setLocal = new WasmSetLocal(local, this.result);
            setLocal.setLocation(statement.getLocation());
            this.resultConsumer.add(setLocal);
        } else if (left instanceof QualificationExpr) {
            QualificationExpr lhs = (QualificationExpr)left;
            this.storeField(lhs.getQualified(), lhs.getField(), statement.getRightValue(), statement.getLocation());
        } else if (left instanceof SubscriptExpr) {
            SubscriptExpr lhs = (SubscriptExpr)left;
            this.storeArrayItem(lhs, statement.getRightValue());
        } else {
            throw new UnsupportedOperationException("This expression is not supported yet");
        }
    }

    protected abstract void storeField(Expr var1, FieldReference var2, Expr var3, TextLocation var4);

    private void storeArrayItem(SubscriptExpr leftValue, Expr rightValue) {
        leftValue.getArray().acceptVisitor(this);
        WasmExpression array = this.result;
        leftValue.getIndex().acceptVisitor(this);
        WasmExpression index = this.result;
        this.resultConsumer.add(this.storeArrayItem(array, index, rightValue, leftValue.getType()));
    }

    protected abstract WasmExpression storeArrayItem(WasmExpression var1, WasmExpression var2, Expr var3, ArrayType var4);

    @Override
    public void visit(ConditionalExpr expr) {
        this.accept(expr.getCondition());
        WasmConditional conditional = new WasmConditional(this.forCondition(this.result));
        this.accept(expr.getConsequent());
        conditional.getThenBlock().getBody().add(this.result);
        this.result.acceptVisitor(this.typeInference);
        WasmType thenType = this.typeInference.getSingleResult();
        conditional.getThenBlock().setType(thenType.asBlock());
        this.accept(expr.getAlternative());
        conditional.getElseBlock().getBody().add(this.result);
        this.result.acceptVisitor(this.typeInference);
        WasmType elseType = this.typeInference.getSingleResult();
        conditional.getElseBlock().setType(elseType.asBlock());
        conditional.setType(this.condBlockType(thenType, elseType, expr).asBlock());
        this.result = conditional;
    }

    protected WasmType condBlockType(WasmType thenType, WasmType elseType, ConditionalExpr conditional) {
        assert (thenType == elseType);
        return thenType;
    }

    @Override
    public void visit(SequentialStatement statement) {
        for (Statement part : statement.getSequence()) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(ConstantExpr expr) {
        if (expr.getValue() == null) {
            this.result = this.nullLiteral(expr);
        } else if (expr.getValue() instanceof Integer) {
            this.result = new WasmInt32Constant((Integer)expr.getValue());
        } else if (expr.getValue() instanceof Long) {
            this.result = new WasmInt64Constant((Long)expr.getValue());
        } else if (expr.getValue() instanceof Float) {
            this.result = new WasmFloat32Constant(((Float)expr.getValue()).floatValue());
        } else if (expr.getValue() instanceof Double) {
            this.result = new WasmFloat64Constant((Double)expr.getValue());
        } else if (expr.getValue() instanceof String) {
            this.result = this.stringLiteral((String)expr.getValue());
        } else if (expr.getValue() instanceof ValueType) {
            this.result = this.classLiteral((ValueType)expr.getValue());
        } else {
            throw new IllegalArgumentException("Constant unsupported: " + String.valueOf(expr.getValue()));
        }
        this.result.setLocation(expr.getLocation());
    }

    protected abstract WasmExpression nullLiteral(Expr var1);

    protected abstract WasmExpression nullLiteral(WasmType var1);

    protected abstract WasmExpression stringLiteral(String var1);

    protected abstract WasmExpression classLiteral(ValueType var1);

    @Override
    public void visit(ConditionalStatement statement) {
        this.accept(statement.getCondition());
        ++this.blockLevel;
        WasmConditional conditional = new WasmConditional(this.forCondition(this.result));
        this.visitMany(statement.getConsequent(), conditional.getThenBlock().getBody());
        this.visitMany(statement.getAlternative(), conditional.getElseBlock().getBody());
        --this.blockLevel;
        this.resultConsumer.add(conditional);
    }

    @Override
    public void visit(VariableExpr expr) {
        this.result = new WasmGetLocal(this.localVar(expr.getIndex()));
    }

    protected WasmLocal localVar(int index) {
        return this.function.getLocalVariables().get(index - this.firstVariable);
    }

    @Override
    public void visit(SwitchStatement statement) {
        int min = statement.getClauses().stream().flatMapToInt(clause -> Arrays.stream(clause.getConditions())).min().orElse(0);
        int max = statement.getClauses().stream().flatMapToInt(clause -> Arrays.stream(clause.getConditions())).max().orElse(0);
        WasmBlock defaultBlock = new WasmBlock(false);
        ++this.blockLevel;
        this.breakTargets.put(statement, defaultBlock);
        IdentifiedStatement oldBreakTarget = this.currentBreakTarget;
        this.currentBreakTarget = statement;
        WasmBlock wrapper = new WasmBlock(false);
        this.accept(statement.getValue());
        WasmExpression condition = this.result;
        WasmBlock initialWrapper = wrapper;
        List<SwitchClause> clauses = statement.getClauses();
        WasmBlock[] targets = new WasmBlock[clauses.size()];
        for (int i = 0; i < clauses.size(); ++i) {
            SwitchClause clause2 = clauses.get(i);
            WasmBlock caseBlock = new WasmBlock(false);
            caseBlock.getBody().add(wrapper);
            targets[i] = wrapper;
            this.visitMany(clause2.getBody(), caseBlock.getBody());
            wrapper = caseBlock;
        }
        defaultBlock.getBody().add(wrapper);
        this.visitMany(statement.getDefaultClause(), defaultBlock.getBody());
        WasmBlock defaultTarget = wrapper;
        wrapper = defaultBlock;
        if ((long)max - (long)min >= 256L) {
            this.translateSwitchToBinarySearch(statement, condition, initialWrapper, defaultTarget, targets);
        } else {
            this.translateSwitchToWasmSwitch(statement, condition, initialWrapper, defaultTarget, targets, min, max);
        }
        this.breakTargets.remove(statement);
        this.currentBreakTarget = oldBreakTarget;
        --this.blockLevel;
        this.resultConsumer.add(wrapper);
    }

    private void translateSwitchToBinarySearch(SwitchStatement statement, WasmExpression condition, WasmBlock initialWrapper, WasmBlock defaultTarget, WasmBlock[] targets) {
        ArrayList<TableEntry> entries = new ArrayList<TableEntry>();
        for (int i = 0; i < statement.getClauses().size(); ++i) {
            SwitchClause clause = statement.getClauses().get(i);
            for (int label : clause.getConditions()) {
                entries.add(new TableEntry(label, targets[i]));
            }
        }
        entries.sort(Comparator.comparingInt(entry -> entry.label));
        CachedExpression cachedCondition = this.exprCache.create(condition, WasmType.INT32, statement.getValue().getLocation(), initialWrapper.getBody());
        this.generateBinarySearch(entries, 0, entries.size() - 1, initialWrapper, defaultTarget, cachedCondition);
        cachedCondition.release();
    }

    private void generateBinarySearch(List<TableEntry> entries, int lower, int upper, WasmBlock consumer, WasmBlock defaultTarget, CachedExpression testValue) {
        if (upper - lower == 0) {
            int label = entries.get((int)lower).label;
            WasmIntBinary condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, testValue.expr(), new WasmInt32Constant(label));
            WasmConditional conditional = new WasmConditional(condition);
            consumer.getBody().add(conditional);
            conditional.getThenBlock().getBody().add(new WasmBreak(entries.get((int)lower).target));
            conditional.getElseBlock().getBody().add(new WasmBreak(defaultTarget));
        } else if (upper - lower <= 0) {
            consumer.getBody().add(new WasmBreak(defaultTarget));
        } else {
            int mid = (upper + lower) / 2;
            int label = entries.get((int)mid).label;
            WasmIntBinary condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GT_SIGNED, testValue.expr(), new WasmInt32Constant(label));
            WasmConditional conditional = new WasmConditional(condition);
            consumer.getBody().add(conditional);
            this.generateBinarySearch(entries, mid + 1, upper, conditional.getThenBlock(), defaultTarget, testValue);
            this.generateBinarySearch(entries, lower, mid, conditional.getElseBlock(), defaultTarget, testValue);
        }
    }

    private void translateSwitchToWasmSwitch(SwitchStatement statement, WasmExpression condition, WasmBlock initialWrapper, WasmBlock defaultTarget, WasmBlock[] targets, int min, int max) {
        if (min != 0) {
            condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, condition, new WasmInt32Constant(min));
        }
        WasmSwitch wasmSwitch = new WasmSwitch(condition, initialWrapper);
        initialWrapper.getBody().add(wasmSwitch);
        wasmSwitch.setDefaultTarget(defaultTarget);
        WasmBlock[] expandedTargets = new WasmBlock[max - min + 1];
        for (int i = 0; i < statement.getClauses().size(); ++i) {
            SwitchClause clause = statement.getClauses().get(i);
            for (int label : clause.getConditions()) {
                expandedTargets[label - min] = targets[i];
            }
        }
        for (WasmBlock target : expandedTargets) {
            wasmSwitch.getTargets().add(target != null ? target : wasmSwitch.getDefaultTarget());
        }
    }

    @Override
    public void visit(WhileStatement statement) {
        WasmBlock wrapper = new WasmBlock(false);
        WasmBlock loop = new WasmBlock(true);
        ++this.blockLevel;
        this.continueTargets.put(statement, loop);
        this.breakTargets.put(statement, wrapper);
        IdentifiedStatement oldBreakTarget = this.currentBreakTarget;
        IdentifiedStatement oldContinueTarget = this.currentContinueTarget;
        this.currentBreakTarget = statement;
        this.currentContinueTarget = statement;
        if (statement.getCondition() != null) {
            this.accept(statement.getCondition());
            loop.getBody().add(new WasmBranch(BaseWasmGenerationVisitor.negate(this.result), wrapper));
            this.usedBlocks.add(wrapper);
        }
        this.visitMany(statement.getBody(), loop.getBody());
        loop.getBody().add(new WasmBreak(loop));
        this.currentBreakTarget = oldBreakTarget;
        this.currentContinueTarget = oldContinueTarget;
        this.continueTargets.remove(statement);
        this.breakTargets.remove(statement);
        if (this.usedBlocks.contains(wrapper)) {
            wrapper.getBody().add(loop);
            this.resultConsumer.add(wrapper);
        } else {
            this.resultConsumer.add(loop);
        }
        --this.blockLevel;
    }

    protected WasmExpression invocation(InvocationExpr expr, List<WasmExpression> resultConsumer, boolean willDrop) {
        CallSiteIdentifier callSiteId = this.generateCallSiteId(expr.getLocation());
        if (this.needsCallSiteId() && this.isManagedCall(expr.getMethod())) {
            WasmBlock block;
            List<WasmExpression> targetList;
            WasmExpression invocation = this.generateInvocation(expr, callSiteId);
            invocation.setLocation(expr.getLocation());
            WasmType type = this.mapType(expr.getMethod().getReturnType());
            if (resultConsumer != null) {
                targetList = resultConsumer;
                this.result = null;
                block = null;
            } else {
                block = new WasmBlock(false);
                block.setType(type != null ? type.asBlock() : null);
                block.setLocation(expr.getLocation());
                targetList = block.getBody();
                this.result = block;
            }
            if (expr.getArguments().isEmpty()) {
                callSiteId.generateRegister(targetList, expr.getLocation());
            }
            WasmLocal resultVar = null;
            if (!willDrop) {
                if (type != null) {
                    resultVar = this.tempVars.acquire(type);
                    WasmSetLocal setLocal = new WasmSetLocal(resultVar, invocation);
                    setLocal.setLocation(expr.getLocation());
                    targetList.add(setLocal);
                } else {
                    targetList.add(invocation);
                }
            } else if (type == null) {
                targetList.add(invocation);
            } else {
                WasmDrop drop = new WasmDrop(invocation);
                drop.setLocation(expr.getLocation());
                targetList.add(drop);
            }
            callSiteId.checkHandlerId(targetList, expr.getLocation());
            if (resultVar != null) {
                WasmGetLocal getLocal = new WasmGetLocal(resultVar);
                getLocal.setLocation(expr.getLocation());
                targetList.add(getLocal);
                this.tempVars.release(resultVar);
            }
            return block;
        }
        WasmExpression resultExpr = this.generateInvocation(expr, null);
        resultExpr.setLocation(expr.getLocation());
        return this.trivialInvocation(resultExpr, resultConsumer, expr.getLocation(), willDrop);
    }

    private WasmExpression trivialInvocation(WasmExpression resultExpr, List<WasmExpression> resultConsumer, TextLocation location, boolean willDrop) {
        if (resultConsumer != null) {
            if (willDrop) {
                WasmDrop drop = new WasmDrop(resultExpr);
                drop.setLocation(location);
                resultConsumer.add(drop);
            } else {
                resultConsumer.add(resultExpr);
            }
            this.result = null;
            return null;
        }
        return resultExpr;
    }

    protected abstract CallSiteIdentifier generateCallSiteId(TextLocation var1);

    protected void acceptWithType(Expr expr, ValueType type) {
        this.accept(expr);
    }

    protected void accept(Expr expr, WasmType type) {
        this.accept(expr);
    }

    protected WasmExpression generateInvocation(InvocationExpr expr, CallSiteIdentifier callSiteId) {
        WasmLocal instanceVar;
        if (expr.getType() == InvocationType.STATIC || expr.getType() == InvocationType.SPECIAL) {
            MethodReader method = this.context.classes().resolve(expr.getMethod());
            MethodReference reference = method != null ? method.getReference() : expr.getMethod();
            WasmFunction function = expr.getType() == InvocationType.STATIC ? this.context.functions().forStaticMethod(reference) : this.context.functions().forInstanceMethod(reference);
            WasmCall call = new WasmCall(function);
            call.setSuspensionPoint(this.isAsyncSplit(reference));
            List<Expr> arguments = expr.getArguments();
            int argumentsSize = arguments.size();
            for (int i = 0; i < argumentsSize; ++i) {
                Expr argument = arguments.get(i);
                ValueType type = expr.getType() == InvocationType.STATIC ? reference.parameterType(i) : (i == 0 ? ValueType.object(reference.getClassName()) : reference.parameterType(i - 1));
                this.acceptWithType(argument, type);
                call.getArguments().add(this.result);
            }
            if (expr.getType() == InvocationType.SPECIAL) {
                WasmExpression firstArg = call.getArguments().get(0);
                call.getArguments().set(0, this.mapFirstArgumentForCall(firstArg, function, expr.getMethod()));
            }
            if (callSiteId != null) {
                callSiteId.addToLastArg(call.getArguments());
            }
            call.setLocation(expr.getLocation());
            return call;
        }
        if (expr.getType() == InvocationType.CONSTRUCTOR) {
            WasmBlock block = new WasmBlock(false);
            WasmType resultType = this.mapType(ValueType.object(expr.getMethod().getClassName()));
            block.setType(resultType.asBlock());
            WasmLocal tmp = this.tempVars.acquire(resultType);
            this.allocateObject(expr.getMethod().getClassName(), expr.getLocation(), tmp, block.getBody());
            WasmFunction function = this.context.functions().forInstanceMethod(expr.getMethod());
            WasmCall call = new WasmCall(function);
            call.setSuspensionPoint(this.isAsyncSplit(expr.getMethod()));
            call.getArguments().add(new WasmGetLocal(tmp));
            List<Expr> arguments = expr.getArguments();
            for (int i = 0; i < arguments.size(); ++i) {
                Expr argument = arguments.get(i);
                this.acceptWithType(argument, expr.getMethod().parameterType(i));
                call.getArguments().add(this.result);
            }
            if (callSiteId != null) {
                callSiteId.addToLastArg(call.getArguments());
            }
            block.getBody().add(call);
            block.getBody().add(new WasmGetLocal(tmp));
            this.tempVars.release(tmp);
            return block;
        }
        MethodReference reference = expr.getMethod();
        ValueType.Object instanceType = ValueType.object(expr.getMethod().getClassName());
        this.acceptWithType(expr.getArguments().get(0), instanceType);
        WasmType instanceWasmType = this.mapType(instanceType);
        WasmExpression instance = this.result;
        WasmBlock block = new WasmBlock(false);
        block.setType(this.mapTypeToBlock(reference.getReturnType()));
        boolean isTemporary = false;
        if (instance instanceof WasmGetLocal) {
            instanceVar = ((WasmGetLocal)instance).getLocal();
        } else {
            instanceVar = this.tempVars.acquire(instanceWasmType);
            block.getBody().add(new WasmSetLocal(instanceVar, instance));
            instance = new WasmGetLocal(instanceVar);
            isTemporary = true;
        }
        ArrayList<WasmExpression> arguments = new ArrayList<WasmExpression>();
        arguments.add(instance);
        for (int i = 1; i < expr.getArguments().size(); ++i) {
            this.acceptWithType(expr.getArguments().get(i), expr.getMethod().parameterType(i - 1));
            arguments.add(this.result);
        }
        if (callSiteId != null) {
            callSiteId.addToLastArg(arguments);
        }
        WasmExpression call = this.generateVirtualCall(instanceVar, reference, arguments);
        block.getBody().add(call);
        if (isTemporary) {
            this.tempVars.release(instanceVar);
        }
        return block;
    }

    protected WasmExpression mapFirstArgumentForCall(WasmExpression argument, WasmFunction function, MethodReference method) {
        return argument;
    }

    protected abstract WasmExpression generateVirtualCall(WasmLocal var1, MethodReference var2, List<WasmExpression> var3);

    protected boolean needsCallSiteId() {
        return this.isManaged();
    }

    @Override
    public void visit(BlockStatement statement) {
        WasmBlock block = new WasmBlock(false);
        ++this.blockLevel;
        if (statement.getId() != null) {
            this.breakTargets.put(statement, block);
        }
        this.visitMany(statement.getBody(), block.getBody());
        if (statement.getId() != null) {
            this.breakTargets.remove(statement);
        }
        this.resultConsumer.add(block);
        --this.blockLevel;
    }

    @Override
    public void visit(BreakStatement statement) {
        IdentifiedStatement target = statement.getTarget();
        if (target == null) {
            target = this.currentBreakTarget;
        }
        WasmBlock wasmTarget = this.breakTargets.get(target);
        this.usedBlocks.add(wasmTarget);
        WasmBreak br = new WasmBreak(wasmTarget);
        br.setLocation(statement.getLocation());
        this.resultConsumer.add(br);
    }

    @Override
    public void visit(ContinueStatement statement) {
        IdentifiedStatement target = statement.getTarget();
        if (target == null) {
            target = this.currentContinueTarget;
        }
        WasmBlock wasmTarget = this.continueTargets.get(target);
        this.usedBlocks.add(wasmTarget);
        WasmBreak br = new WasmBreak(wasmTarget);
        br.setLocation(statement.getLocation());
        this.resultConsumer.add(br);
    }

    @Override
    public void visit(NewExpr expr) {
        WasmBlock block = new WasmBlock(false);
        block.setLocation(expr.getLocation());
        block.setType(this.mapType(ValueType.object(expr.getConstructedClass())).asBlock());
        CallSiteIdentifier callSiteId = this.generateCallSiteId(expr.getLocation());
        callSiteId.generateRegister(block.getBody(), expr.getLocation());
        this.allocateObject(expr.getConstructedClass(), expr.getLocation(), null, block.getBody());
        this.result = block.getBody().size() == 1 ? block.getBody().get(0) : block;
    }

    protected abstract void allocateObject(String var1, TextLocation var2, WasmLocal var3, List<WasmExpression> var4);

    protected abstract WasmExpression allocateMultiArray(List<WasmExpression> var1, ValueType var2, Supplier<List<WasmExpression>> var3, TextLocation var4);

    @Override
    public void visit(NewMultiArrayExpr expr) {
        WasmBlock block = new WasmBlock(false);
        CallSiteIdentifier callSiteId = this.generateCallSiteId(expr.getLocation());
        callSiteId.generateRegister(block.getBody(), expr.getLocation());
        ValueType arrayType = expr.getType();
        block.setType(this.mapTypeToBlock(arrayType));
        WasmExpression call = this.allocateMultiArray(block.getBody(), expr.getType(), () -> {
            ArrayList<WasmExpression> wasmDimensions = new ArrayList<WasmExpression>();
            for (Expr dimension : expr.getDimensions()) {
                this.accept(dimension);
                wasmDimensions.add(this.result);
            }
            return wasmDimensions;
        }, expr.getLocation());
        block.getBody().add(call);
        this.result = block.getBody().size() == 1 ? block.getBody().get(0) : block;
    }

    @Override
    public void visit(ReturnStatement statement) {
        if (statement.getResult() != null) {
            this.acceptWithType(statement.getResult(), this.currentMethod.getReturnType());
            this.result = this.forceType(this.result, this.currentMethod.getReturnType());
        } else {
            this.result = null;
        }
        if (this.blockLevel == 0) {
            if (this.result != null) {
                if (this.result.getLocation() == null) {
                    this.result.setLocation(statement.getLocation());
                }
                this.resultConsumer.add(this.result);
            }
        } else if (this.returnBlock != null) {
            WasmBreak br = new WasmBreak(this.returnBlock);
            br.setLocation(statement.getLocation());
            br.setResult(this.result);
            this.resultConsumer.add(br);
        } else {
            WasmReturn wasmStatement = new WasmReturn(this.result);
            wasmStatement.setLocation(statement.getLocation());
            this.resultConsumer.add(wasmStatement);
        }
    }

    protected WasmExpression forceType(WasmExpression expression, ValueType type) {
        return expression;
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        this.acceptWithType(expr.getExpr(), expr.getType());
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32.asBlock());
        block.setLocation(expr.getLocation());
        this.result.acceptVisitor(this.typeInference);
        CachedExpression cachedObject = this.exprCache.create(this.result, this.typeInference.getSingleResult(), expr.getLocation(), block.getBody());
        WasmBranch ifNull = new WasmBranch(this.genIsNull(cachedObject.expr()), block);
        ifNull.setResult(new WasmInt32Constant(0));
        block.getBody().add(new WasmDrop(ifNull));
        block.getBody().add(this.generateInstanceOf(cachedObject.expr(), expr.getType()));
        cachedObject.release();
        this.result = block;
    }

    protected abstract WasmExpression generateInstanceOf(WasmExpression var1, ValueType var2);

    @Override
    public void visit(ThrowStatement statement) {
        CallSiteIdentifier callSiteId = this.generateCallSiteId(statement.getLocation());
        callSiteId.generateRegister(this.resultConsumer, statement.getLocation());
        this.accept(statement.getException());
        this.generateThrow(this.result, statement.getLocation(), this.resultConsumer);
        callSiteId.generateThrow(this.resultConsumer, statement.getLocation());
    }

    protected abstract void generateThrow(WasmExpression var1, TextLocation var2, List<WasmExpression> var3);

    @Override
    public void visit(CastExpr expr) {
        WasmType wasmTargetType = this.mapType(expr.getTarget());
        this.acceptWithType(expr.getValue(), expr.getTarget());
        this.result.acceptVisitor(this.typeInference);
        WasmType wasmSourceType = this.typeInference.getSingleResult();
        if (!expr.isWeak()) {
            if (wasmSourceType == null) {
                return;
            }
            WasmBlock block = new WasmBlock(false);
            block.setType(wasmSourceType.asBlock());
            block.setLocation(expr.getLocation());
            this.acceptWithType(expr.getValue(), expr.getTarget());
            CachedExpression valueToCast = this.exprCache.create(this.result, wasmSourceType, expr.getLocation(), block.getBody());
            WasmBranch nullCheck = new WasmBranch(this.genIsNull(valueToCast.expr()), block);
            nullCheck.setResult(this.nullLiteral(wasmTargetType));
            block.getBody().add(new WasmDrop(nullCheck));
            WasmExpression supertypeCall = this.generateInstanceOf(valueToCast.expr(), expr.getTarget());
            WasmBranch breakIfPassed = new WasmBranch(supertypeCall, block);
            breakIfPassed.setResult(valueToCast.expr());
            block.getBody().add(new WasmDrop(breakIfPassed));
            CallSiteIdentifier callSiteId = this.generateCallSiteId(expr.getLocation());
            callSiteId.generateRegister(block.getBody(), expr.getLocation());
            this.generateThrowCCE(expr.getLocation(), block.getBody());
            callSiteId.generateThrow(block.getBody(), expr.getLocation());
            valueToCast.release();
            this.result = block;
        }
        this.result.setLocation(expr.getLocation());
    }

    @Override
    public void visit(InitClassStatement statement) {
        if (this.needsClassInitializer(statement.getClassName())) {
            CallSiteIdentifier callSiteId = this.generateCallSiteId(statement.getLocation());
            callSiteId.generateRegister(this.resultConsumer, statement.getLocation());
            this.resultConsumer.add(this.generateClassInitializer(statement.getClassName(), statement.getLocation()));
            callSiteId.checkHandlerId(this.resultConsumer, statement.getLocation());
        }
    }

    protected abstract boolean needsClassInitializer(String var1);

    protected abstract WasmExpression generateClassInitializer(String var1, TextLocation var2);

    @Override
    public void visit(PrimitiveCastExpr expr) {
        this.accept(expr.getValue());
        WasmConversion conversion = new WasmConversion(WasmGeneratorUtil.mapType(expr.getSource()), WasmGeneratorUtil.mapType(expr.getTarget()), true, this.result);
        conversion.setNonTrapping(true);
        conversion.setLocation(expr.getLocation());
        this.result = conversion;
    }

    @Override
    public void visit(TryCatchStatement statement) {
        Statement next;
        ArrayList<TryCatchStatement> tryCatchStatements = new ArrayList<TryCatchStatement>();
        while (statement.getProtectedBody().size() == 1 && (next = statement.getProtectedBody().get(0)) instanceof TryCatchStatement) {
            tryCatchStatements.add(statement);
            statement = (TryCatchStatement)next;
        }
        tryCatchStatements.add(statement);
        this.generateTry(tryCatchStatements, statement.getProtectedBody());
    }

    protected void generateTry(List<TryCatchStatement> tryCatchStatements, List<Statement> protectedBody) {
        WasmBlock catchBlock;
        TryCatchStatement tryCatch;
        int i;
        WasmType throwableType = this.mapType(ValueType.object("java.lang.Throwable"));
        WasmBlock innerCatchBlock = new WasmBlock(false);
        ++this.blockLevel;
        ArrayList<WasmBlock> catchBlocks = new ArrayList<WasmBlock>();
        for (int i2 = 0; i2 < tryCatchStatements.size(); ++i2) {
            catchBlocks.add(new WasmBlock(false));
        }
        WasmBlock outerCatchBlock = (WasmBlock)catchBlocks.get(0);
        WasmTry tryBlock = new WasmTry();
        this.visitMany(protectedBody, tryBlock.getBody());
        if (!tryBlock.isTerminating()) {
            tryBlock.getBody().add(new WasmBreak(outerCatchBlock));
        }
        WasmCatch catchClause = new WasmCatch(this.context.getExceptionTag());
        tryBlock.getCatches().add(catchClause);
        innerCatchBlock.getBody().add(tryBlock);
        WasmLocal exceptionVar = this.tempVars.acquire(throwableType);
        catchClause.getCatchVariables().add(exceptionVar);
        WasmBlock currentBlock = innerCatchBlock;
        boolean catchesAll = false;
        for (i = tryCatchStatements.size() - 1; i >= 0; --i) {
            tryCatch = tryCatchStatements.get(i);
            catchBlock = (WasmBlock)catchBlocks.get(i);
            WasmType blockType = this.mapType(tryCatch.getExceptionType() != null ? ValueType.object(tryCatch.getExceptionType()) : ValueType.object("java.lang.Throwable"));
            currentBlock.setType(blockType.asBlock());
            if (tryCatch.getExceptionType() != null && !tryCatch.getExceptionType().equals(Throwable.class.getName())) {
                this.checkExceptionType(tryCatch, exceptionVar, innerCatchBlock.getBody(), currentBlock);
            } else {
                WasmBreak br = new WasmBreak(currentBlock);
                br.setResult(new WasmGetLocal(exceptionVar));
                innerCatchBlock.getBody().add(br);
                catchesAll = true;
            }
            currentBlock = catchBlock;
        }
        if (!catchesAll) {
            WasmThrow rethrowExpr = new WasmThrow(this.context.getExceptionTag());
            rethrowExpr.getArguments().add(new WasmGetLocal(exceptionVar));
            innerCatchBlock.getBody().add(rethrowExpr);
        }
        currentBlock = innerCatchBlock;
        for (i = tryCatchStatements.size() - 1; i >= 0; --i) {
            WasmLocal catchLocal;
            tryCatch = tryCatchStatements.get(i);
            catchBlock = (WasmBlock)catchBlocks.get(i);
            WasmLocal wasmLocal = catchLocal = tryCatch.getExceptionVariable() != null ? this.localVar(tryCatch.getExceptionVariable()) : null;
            if (catchLocal != null) {
                WasmSetLocal save = new WasmSetLocal(this.localVar(tryCatch.getExceptionVariable()), currentBlock);
                catchBlock.getBody().add(save);
            } else {
                catchBlock.getBody().add(new WasmDrop(currentBlock));
            }
            this.visitMany(tryCatch.getHandler(), catchBlock.getBody());
            if (!catchBlock.isTerminating() && catchBlock != outerCatchBlock) {
                catchBlock.getBody().add(new WasmBreak(outerCatchBlock));
            }
            currentBlock = catchBlock;
        }
        this.resultConsumer.add(outerCatchBlock);
        this.tempVars.release(exceptionVar);
        --this.blockLevel;
    }

    protected void checkExceptionType(TryCatchStatement tryCatch, WasmLocal exceptionVar, List<WasmExpression> target, WasmBlock targetBlock) {
        ValueType.Object exceptionType = ValueType.object(tryCatch.getExceptionType());
        WasmExpression isMatched = this.generateInstanceOf(new WasmGetLocal(exceptionVar), exceptionType);
        WasmBranch br = new WasmBranch(isMatched, targetBlock);
        br.setResult(new WasmGetLocal(exceptionVar));
        target.add(new WasmDrop(br));
    }

    private void visitMany(List<Statement> statements, List<WasmExpression> target) {
        List<WasmExpression> oldTarget = this.resultConsumer;
        this.resultConsumer = target;
        for (Statement part : statements) {
            this.accept(part);
        }
        this.resultConsumer = oldTarget;
    }

    @Override
    public void visit(GotoPartStatement statement) {
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        statement.getObjectRef().acceptVisitor(this);
        this.monitorEnter(this.result, statement.getLocation(), this.resultConsumer);
    }

    public void monitorEnter(WasmExpression obj, TextLocation location, List<WasmExpression> consumer) {
        WasmCall call = new WasmCall(this.context.functions().forStaticMethod(this.async ? MONITOR_ENTER : MONITOR_ENTER_SYNC));
        call.setLocation(location);
        call.getArguments().add(obj);
        if (this.async) {
            call.setSuspensionPoint(true);
        }
        CallSiteIdentifier callSiteId = this.generateCallSiteId(location);
        callSiteId.generateRegister(consumer, location);
        consumer.add(call);
        callSiteId.checkHandlerId(consumer, location);
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        statement.getObjectRef().acceptVisitor(this);
        this.monitorExit(this.result, statement.getLocation(), this.resultConsumer);
    }

    public void monitorExit(WasmExpression obj, TextLocation location, List<WasmExpression> consumer) {
        WasmCall call = new WasmCall(this.context.functions().forStaticMethod(this.async ? MONITOR_EXIT : MONITOR_EXIT_SYNC));
        call.setLocation(location);
        call.getArguments().add(obj);
        CallSiteIdentifier callSiteId = this.generateCallSiteId(location);
        callSiteId.generateRegister(consumer, location);
        consumer.add(call);
        callSiteId.checkHandlerId(consumer, location);
    }

    @Override
    public void visit(BoundCheckExpr expr) {
        if (!this.isManaged()) {
            expr.getIndex().acceptVisitor(this);
            return;
        }
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32.asBlock());
        block.setLocation(expr.getLocation());
        this.accept(expr.getIndex());
        CachedExpression index = this.exprCache.create(this.result, WasmType.INT32, expr.getLocation(), block.getBody());
        if (expr.getArray() != null) {
            WasmBlock condBlock = block;
            if (expr.isLower()) {
                condBlock = new WasmBlock(false);
                block.getBody().add(condBlock);
                WasmIntBinary lowerCond = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, index.expr(), new WasmInt32Constant(0));
                WasmBranch lowerBranch = new WasmBranch(lowerCond, condBlock);
                condBlock.getBody().add(lowerBranch);
            }
            this.accept(expr.getArray());
            WasmExpression upperBound = this.generateArrayLength(this.result);
            WasmIntBinary upperCond = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, index.expr(), upperBound);
            WasmBranch upperBranch = new WasmBranch(upperCond, block);
            upperBranch.setResult(index.expr());
            condBlock.getBody().add(new WasmDrop(upperBranch));
        } else if (expr.isLower()) {
            WasmIntBinary lowerCond = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GE_SIGNED, index.expr(), new WasmInt32Constant(0));
            WasmBranch lowerBranch = new WasmBranch(lowerCond, block);
            lowerBranch.setResult(index.expr());
            block.getBody().add(new WasmDrop(lowerBranch));
        }
        CallSiteIdentifier callSiteId = this.generateCallSiteId(expr.getLocation());
        callSiteId.generateRegister(block.getBody(), expr.getLocation());
        this.generateThrowAIOOBE(expr.getLocation(), block.getBody());
        callSiteId.generateThrow(block.getBody(), expr.getLocation());
        this.result = block;
    }

    protected abstract void generateThrowAIOOBE(TextLocation var1, List<WasmExpression> var2);

    protected abstract void generateThrowCCE(TextLocation var1, List<WasmExpression> var2);

    private static WasmExpression negate(WasmExpression expr) {
        WasmFloatBinaryOperation negatedOp;
        WasmExpression binary;
        if (expr instanceof WasmIntBinary) {
            WasmIntBinaryOperation negatedOp2;
            binary = (WasmIntBinary)expr;
            if (((WasmIntBinary)binary).getType() == WasmIntType.INT32 && ((WasmIntBinary)binary).getOperation() == WasmIntBinaryOperation.XOR) {
                if (BaseWasmGenerationVisitor.isOne(((WasmIntBinary)binary).getFirst())) {
                    WasmExpression result = ((WasmIntBinary)binary).getSecond();
                    if (result.getLocation() == null && expr.getLocation() != null) {
                        result.setLocation(expr.getLocation());
                    }
                    return result;
                }
                if (BaseWasmGenerationVisitor.isOne(((WasmIntBinary)binary).getSecond())) {
                    WasmExpression result = ((WasmIntBinary)binary).getFirst();
                    if (result.getLocation() == null && expr.getLocation() != null) {
                        result.setLocation(expr.getLocation());
                    }
                    return result;
                }
            }
            if ((negatedOp2 = BaseWasmGenerationVisitor.negate(((WasmIntBinary)binary).getOperation())) != null) {
                WasmIntBinary result = new WasmIntBinary(((WasmIntBinary)binary).getType(), negatedOp2, ((WasmIntBinary)binary).getFirst(), ((WasmIntBinary)binary).getSecond());
                result.setLocation(expr.getLocation());
                return result;
            }
        } else if (expr instanceof WasmFloatBinary && (negatedOp = BaseWasmGenerationVisitor.negate(((WasmFloatBinary)(binary = (WasmFloatBinary)expr)).getOperation())) != null) {
            WasmFloatBinary result = new WasmFloatBinary(((WasmFloatBinary)binary).getType(), negatedOp, ((WasmFloatBinary)binary).getFirst(), ((WasmFloatBinary)binary).getSecond());
            result.setLocation(expr.getLocation());
            return result;
        }
        WasmIntUnary result = new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.EQZ, expr);
        result.setLocation(expr.getLocation());
        return result;
    }

    private static boolean isOne(WasmExpression expression) {
        return expression instanceof WasmInt32Constant && ((WasmInt32Constant)expression).getValue() == 1;
    }

    private static boolean isZero(WasmExpression expression) {
        return expression instanceof WasmInt32Constant && ((WasmInt32Constant)expression).getValue() == 0;
    }

    private boolean isBoolean(WasmExpression expression) {
        if (expression instanceof WasmIntBinary) {
            WasmIntBinary binary = (WasmIntBinary)expression;
            switch (binary.getOperation()) {
                case EQ: 
                case NE: 
                case LT_SIGNED: 
                case LT_UNSIGNED: 
                case LE_SIGNED: 
                case LE_UNSIGNED: 
                case GT_SIGNED: 
                case GT_UNSIGNED: 
                case GE_SIGNED: 
                case GE_UNSIGNED: {
                    return true;
                }
            }
            return false;
        }
        if (expression instanceof WasmFloatBinary) {
            WasmFloatBinary binary = (WasmFloatBinary)expression;
            switch (binary.getOperation()) {
                case EQ: 
                case NE: 
                case LT: 
                case LE: 
                case GT: 
                case GE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private WasmExpression forCondition(WasmExpression expression) {
        if (expression instanceof WasmIntBinary) {
            WasmIntBinary binary = (WasmIntBinary)expression;
            switch (binary.getOperation()) {
                case EQ: {
                    if (BaseWasmGenerationVisitor.isZero(binary.getFirst()) && this.isBoolean(binary.getSecond())) {
                        return BaseWasmGenerationVisitor.negate(binary.getSecond());
                    }
                    if (!BaseWasmGenerationVisitor.isZero(binary.getSecond()) || !this.isBoolean(binary.getFirst())) break;
                    return BaseWasmGenerationVisitor.negate(binary.getFirst());
                }
                case NE: {
                    if (BaseWasmGenerationVisitor.isZero(binary.getFirst()) && this.isBoolean(binary.getSecond())) {
                        return binary.getSecond();
                    }
                    if (!BaseWasmGenerationVisitor.isZero(binary.getSecond()) || !this.isBoolean(binary.getFirst())) break;
                    return binary.getFirst();
                }
            }
        }
        return expression;
    }

    private static WasmIntBinaryOperation negate(WasmIntBinaryOperation op) {
        switch (op) {
            case EQ: {
                return WasmIntBinaryOperation.NE;
            }
            case NE: {
                return WasmIntBinaryOperation.EQ;
            }
            case LT_SIGNED: {
                return WasmIntBinaryOperation.GE_SIGNED;
            }
            case LT_UNSIGNED: {
                return WasmIntBinaryOperation.GE_UNSIGNED;
            }
            case LE_SIGNED: {
                return WasmIntBinaryOperation.GT_SIGNED;
            }
            case LE_UNSIGNED: {
                return WasmIntBinaryOperation.GT_UNSIGNED;
            }
            case GT_SIGNED: {
                return WasmIntBinaryOperation.LE_SIGNED;
            }
            case GT_UNSIGNED: {
                return WasmIntBinaryOperation.LE_UNSIGNED;
            }
            case GE_SIGNED: {
                return WasmIntBinaryOperation.LT_SIGNED;
            }
            case GE_UNSIGNED: {
                return WasmIntBinaryOperation.LT_UNSIGNED;
            }
        }
        return null;
    }

    private static WasmFloatBinaryOperation negate(WasmFloatBinaryOperation op) {
        switch (op) {
            case EQ: {
                return WasmFloatBinaryOperation.NE;
            }
            case NE: {
                return WasmFloatBinaryOperation.EQ;
            }
        }
        return null;
    }

    protected abstract WasmExpression genIsNull(WasmExpression var1);

    protected abstract WasmType mapType(ValueType var1);

    protected WasmExpression unwrapArray(WasmExpression array) {
        return array;
    }

    protected final WasmBlockType mapTypeToBlock(ValueType type) {
        WasmType result = this.mapType(type);
        return result != null ? result.asBlock() : null;
    }

    @Override
    public void visit(UnwrapArrayExpr expr) {
        this.accept(expr.getArray());
        this.result = this.unwrapArray(this.result);
        this.result.setLocation(expr.getLocation());
    }

    protected boolean isAsyncSplit(MethodReference methodRef) {
        return false;
    }

    protected final boolean isAsync() {
        return this.async;
    }

    protected abstract class CallSiteIdentifier {
        protected CallSiteIdentifier() {
        }

        public abstract void generateRegister(List<WasmExpression> var1, TextLocation var2);

        public final void addToLastArg(List<WasmExpression> args) {
            if (args.isEmpty()) {
                return;
            }
            WasmExpression arg = args.get(args.size() - 1);
            WasmBlock block = new WasmBlock(false);
            arg.acceptVisitor(BaseWasmGenerationVisitor.this.typeInference);
            block.setType(BaseWasmGenerationVisitor.this.typeInference.getSingleResult().asBlock());
            block.setLocation(arg.getLocation());
            block.getBody().add(arg);
            args.set(args.size() - 1, block);
            this.generateRegister(block.getBody(), arg.getLocation());
        }

        public abstract void checkHandlerId(List<WasmExpression> var1, TextLocation var2);

        public abstract void generateThrow(List<WasmExpression> var1, TextLocation var2);
    }

    static class TableEntry {
        final int label;
        final WasmBlock target;

        TableEntry(int label, WasmBlock target) {
            this.label = label;
            this.target = target;
        }
    }
}

